/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.message.DescribeBrokerAdditionsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractResponse;

public class DescribeBrokerAdditionsResponse
extends AbstractResponse {
    private final DescribeBrokerAdditionsResponseData data;

    public DescribeBrokerAdditionsResponse(DescribeBrokerAdditionsResponseData data) {
        super(ApiKeys.DESCRIBE_BROKER_ADDITIONS);
        this.data = data;
    }

    @Override
    public DescribeBrokerAdditionsResponseData data() {
        return this.data;
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return true;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return Collections.singletonMap(Errors.forCode(this.data.errorCode()), 1);
    }

    @Override
    public String toString() {
        return this.data.toString();
    }

    public static DescribeBrokerAdditionsResponse parse(ByteBuffer buffer, short version, MessageContext context) {
        return new DescribeBrokerAdditionsResponse(new DescribeBrokerAdditionsResponseData(new ByteBufferAccessor(buffer), version, context));
    }
}

