/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.http.server;

import io.confluent.kafka.http.server.KafkaHttpServerBinder;
import io.confluent.kafka.http.server.KafkaHttpServerInjector;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class KafkaHttpServerBinderTest {
    @Test
    public void bindInstance_noAnnotation_nonNull_bindsInstanceAndSupplier() {
        KafkaHttpServerBinder httpServerBinder = new KafkaHttpServerBinder();
        httpServerBinder.bindInstance(String.class, (Object)"foobar");
        KafkaHttpServerInjector injector = httpServerBinder.createInjector();
        Assertions.assertEquals((Object)"foobar", (Object)injector.getInstance(String.class));
        Assertions.assertEquals((Object)"foobar", injector.getSupplier(String.class).get());
    }

    @Test
    public void bindInstance_noAnnotation_null_bindsNullAndSupplier() {
        KafkaHttpServerBinder httpServerBinder = new KafkaHttpServerBinder();
        httpServerBinder.bindInstance(String.class, null);
        KafkaHttpServerInjector injector = httpServerBinder.createInjector();
        Assertions.assertNull((Object)injector.getInstance(String.class));
        Assertions.assertNull(injector.getSupplier(String.class).get());
    }

    @Test
    public void bindInstance_withAnnotation_nonNull_bindsInstanceAndSupplier() {
        KafkaHttpServerBinder httpServerBinder = new KafkaHttpServerBinder();
        httpServerBinder.bindInstance(String.class, FooBar.class, (Object)"foobar");
        KafkaHttpServerInjector injector = httpServerBinder.createInjector();
        Assertions.assertEquals((Object)"foobar", (Object)injector.getInstance(String.class, FooBar.class));
        Assertions.assertEquals((Object)"foobar", injector.getSupplier(String.class, FooBar.class).get());
    }

    @Test
    public void bindInstance_withAnnotation_null_bindsNullAndSupplier() {
        KafkaHttpServerBinder httpServerBinder = new KafkaHttpServerBinder();
        httpServerBinder.bindInstance(String.class, FooBar.class, null);
        KafkaHttpServerInjector injector = httpServerBinder.createInjector();
        Assertions.assertNull((Object)injector.getInstance(String.class, FooBar.class));
        Assertions.assertNull(injector.getSupplier(String.class, FooBar.class).get());
    }

    @Test
    public void bindSupplier_noAnnotation_nonNull_bindsInstanceAndSupplier() {
        KafkaHttpServerBinder httpServerBinder = new KafkaHttpServerBinder();
        httpServerBinder.bindSupplier(String.class, () -> "foobar");
        KafkaHttpServerInjector injector = httpServerBinder.createInjector();
        Assertions.assertEquals((Object)"foobar", (Object)injector.getInstance(String.class));
        Assertions.assertEquals((Object)"foobar", injector.getSupplier(String.class).get());
    }

    @Test
    public void bindSupplier_noAnnotation_null_bindsNullAndSupplier() {
        KafkaHttpServerBinder httpServerBinder = new KafkaHttpServerBinder();
        httpServerBinder.bindSupplier(String.class, () -> null);
        KafkaHttpServerInjector injector = httpServerBinder.createInjector();
        Assertions.assertNull((Object)injector.getInstance(String.class));
        Assertions.assertNull(injector.getSupplier(String.class).get());
    }

    @Test
    public void bindSupplier_withAnnotation_nonNull_bindsInstanceAndSupplier() {
        KafkaHttpServerBinder httpServerBinder = new KafkaHttpServerBinder();
        httpServerBinder.bindSupplier(String.class, FooBar.class, () -> "foobar");
        KafkaHttpServerInjector injector = httpServerBinder.createInjector();
        Assertions.assertEquals((Object)"foobar", (Object)injector.getInstance(String.class, FooBar.class));
        Assertions.assertEquals((Object)"foobar", injector.getSupplier(String.class, FooBar.class).get());
    }

    @Test
    public void bindSupplier_withAnnotation_null_bindsNullAndSupplier() {
        KafkaHttpServerBinder httpServerBinder = new KafkaHttpServerBinder();
        httpServerBinder.bindSupplier(String.class, FooBar.class, () -> null);
        KafkaHttpServerInjector injector = httpServerBinder.createInjector();
        Assertions.assertNull((Object)injector.getInstance(String.class, FooBar.class));
        Assertions.assertNull(injector.getSupplier(String.class, FooBar.class).get());
    }

    @Test
    public void bindingTwice_throwsException() {
        KafkaHttpServerBinder httpServerBinder = new KafkaHttpServerBinder();
        httpServerBinder.bindInstance(String.class, (Object)"foobar");
        try {
            httpServerBinder.bindInstance(String.class, (Object)"foobar");
            Assertions.fail((String)"Expected exception IllegalArgumentException to be thrown, but no exception was thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getInstance_noBinding_throwsException() {
        KafkaHttpServerBinder httpServerBinder = new KafkaHttpServerBinder();
        KafkaHttpServerInjector injector = httpServerBinder.createInjector();
        try {
            injector.getInstance(String.class);
            Assertions.fail((String)"Expected exception ProvisionException to be thrown, but no exception was thrown.");
        }
        catch (KafkaHttpServerInjector.ProvisionException provisionException) {
            // empty catch block
        }
    }

    @Test
    public void getSupplier_noBinding_throwsException() {
        KafkaHttpServerBinder httpServerBinder = new KafkaHttpServerBinder();
        KafkaHttpServerInjector injector = httpServerBinder.createInjector();
        try {
            injector.getSupplier(String.class);
            Assertions.fail((String)"Expected exception ProvisionException to be thrown, but no exception was thrown.");
        }
        catch (KafkaHttpServerInjector.ProvisionException provisionException) {
            // empty catch block
        }
    }

    private static @interface FooBar {
    }
}

