/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.clients.MetadataCache;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.MetadataResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MetadataCacheTest {
    @Test
    public void testMissingLeaderEndpoint() {
        TopicPartition topicPartition = new TopicPartition("topic", 0);
        MetadataResponse.PartitionMetadata partitionMetadata = new MetadataResponse.PartitionMetadata(Errors.NONE, topicPartition, Optional.of(5), Optional.of(10), Arrays.asList(5, 6, 7), Arrays.asList(5, 6, 7), Collections.emptyList());
        HashMap<Integer, Node> nodesById = new HashMap<Integer, Node>();
        nodesById.put(6, new Node(6, "localhost", 2077));
        nodesById.put(7, new Node(7, "localhost", 2078));
        nodesById.put(8, new Node(8, "localhost", 2079));
        MetadataCache cache = new MetadataCache("clusterId", nodesById, Collections.singleton(partitionMetadata), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), null, Collections.emptyMap());
        Cluster cluster = cache.cluster();
        Assertions.assertNull((Object)cluster.leaderFor(topicPartition));
        PartitionInfo partitionInfo = cluster.partition(topicPartition);
        Map replicas = Arrays.stream(partitionInfo.replicas()).collect(Collectors.toMap(Node::id, Function.identity()));
        Assertions.assertNull((Object)partitionInfo.leader());
        Assertions.assertEquals((int)3, (int)replicas.size());
        Assertions.assertTrue((boolean)((Node)replicas.get(5)).isEmpty());
        Assertions.assertEquals(nodesById.get(6), replicas.get(6));
        Assertions.assertEquals(nodesById.get(7), replicas.get(7));
    }
}

