/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.Collections;
import java.util.Map;
import org.apache.kafka.clients.admin.DeleteTopicsResult;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DeleteTopicsResultTest {
    @Test
    public void testDeleteTopicsResultWithNames() {
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.complete(null);
        Map<String, KafkaFutureImpl> topicNames = Collections.singletonMap("foo", future);
        DeleteTopicsResult topicNameFutures = DeleteTopicsResult.ofTopicNames(topicNames);
        Assertions.assertEquals(topicNames, (Object)topicNameFutures.topicNameValues());
        Assertions.assertNull((Object)topicNameFutures.topicIdValues());
        Assertions.assertTrue((boolean)topicNameFutures.all().isDone());
    }

    @Test
    public void testDeleteTopicsResultWithIds() {
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.complete(null);
        Map<Uuid, KafkaFutureImpl> topicIds = Collections.singletonMap(Uuid.randomUuid(), future);
        DeleteTopicsResult topicIdFutures = DeleteTopicsResult.ofTopicIds(topicIds);
        Assertions.assertEquals(topicIds, (Object)topicIdFutures.topicIdValues());
        Assertions.assertNull((Object)topicIdFutures.topicNameValues());
        Assertions.assertTrue((boolean)topicIdFutures.all().isDone());
    }

    @Test
    public void testInvalidConfigurations() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new DeleteTopicsResult(null, null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new DeleteTopicsResult(Collections.emptyMap(), Collections.emptyMap()));
    }
}

