/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.kafka.clients.GroupRebalanceConfig;
import org.apache.kafka.clients.consumer.internals.DefaultBackgroundThread;
import org.apache.kafka.clients.consumer.internals.DefaultEventHandler;
import org.apache.kafka.clients.consumer.internals.events.ApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.NoopApplicationEvent;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class DefaultEventHandlerTest {
    private int sessionTimeoutMs = 1000;
    private int rebalanceTimeoutMs = 1000;
    private int heartbeatIntervalMs = 1000;
    private String groupId = "g-1";
    private Optional<String> groupInstanceId = Optional.of("g-1");
    private long retryBackoffMs = 1000L;
    private final Properties properties = new Properties();
    private GroupRebalanceConfig rebalanceConfig;

    @BeforeEach
    public void setup() {
        this.properties.put("key.deserializer", StringDeserializer.class);
        this.properties.put("value.deserializer", StringDeserializer.class);
        this.properties.put("retry.backoff.ms", "100");
        this.rebalanceConfig = new GroupRebalanceConfig(this.sessionTimeoutMs, this.rebalanceTimeoutMs, this.heartbeatIntervalMs, this.groupId, this.groupInstanceId, this.retryBackoffMs, true);
    }

    @Test
    public void testBasicHandlerOps() {
        DefaultBackgroundThread bt = (DefaultBackgroundThread)Mockito.mock(DefaultBackgroundThread.class);
        LinkedBlockingQueue aq = new LinkedBlockingQueue();
        LinkedBlockingQueue bq = new LinkedBlockingQueue();
        DefaultEventHandler handler = new DefaultEventHandler(bt, aq, bq);
        Assertions.assertTrue((boolean)handler.isEmpty());
        Assertions.assertFalse((boolean)handler.poll().isPresent());
        handler.add((ApplicationEvent)new NoopApplicationEvent("test"));
        Assertions.assertEquals((int)1, (int)aq.size());
        handler.close();
        ((DefaultBackgroundThread)Mockito.verify((Object)bt, (VerificationMode)Mockito.times((int)1))).close();
    }
}

