/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.config.internals;

import java.util.Arrays;
import java.util.Collections;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ConfluentConfigsTest {
    @Test
    public void testSslEnabledListenersNull() {
        Assertions.assertEquals(Collections.emptyList(), (Object)ConfluentConfigs.sslListenerNames(Collections.emptyMap()));
    }

    @Test
    public void testSslEnabledListenersEmpty() {
        Assertions.assertEquals(Collections.emptyList(), (Object)ConfluentConfigs.sslListenerNames(Collections.singletonMap("listener.security.protocol.map", "")));
    }

    @Test
    public void testSslEnabledListenersAllPlaintext() {
        Assertions.assertEquals(Collections.emptyList(), (Object)ConfluentConfigs.sslListenerNames(Collections.singletonMap("listener.security.protocol.map", "INTERNAL:PLAINTEXT,REPLICATION:PLAINTEXT")));
    }

    @Test
    public void testSslEnabledListenersSomeSsl() {
        Assertions.assertEquals(Arrays.asList("EXTERNAL", "INTERNAL_ROOT_SCOPED"), (Object)ConfluentConfigs.sslListenerNames(Collections.singletonMap("listener.security.protocol.map", "EXTERNAL:SASL_SSL,INTERNAL:PLAINTEXT,REPLICATION:PLAINTEXT,INTERNAL_ROOT_SCOPED:SSL")));
    }
}

