/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.common.Configurable;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.TestSecurityConfig;
import org.apache.kafka.common.security.auth.AuthenticationContext;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipalBuilder;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ChannelBuildersTest {
    @Test
    public void testCreateConfigurableKafkaPrincipalBuilder() {
        HashMap<String, Class<ConfigurableKafkaPrincipalBuilder>> configs = new HashMap<String, Class<ConfigurableKafkaPrincipalBuilder>>();
        configs.put("principal.builder.class", ConfigurableKafkaPrincipalBuilder.class);
        KafkaPrincipalBuilder builder = ChannelBuilders.createPrincipalBuilder(configs, null, null);
        Assertions.assertTrue((boolean)(builder instanceof ConfigurableKafkaPrincipalBuilder));
        Assertions.assertTrue((boolean)((ConfigurableKafkaPrincipalBuilder)builder).configured);
    }

    @Test
    public void testChannelBuilderConfigs() {
        Properties props = new Properties();
        props.put("listener.name.listener1.gssapi.sasl.kerberos.service.name", "testkafka");
        props.put("listener.name.listener1.sasl.kerberos.service.name", "testkafkaglobal");
        props.put("plain.sasl.server.callback.handler.class", "callback");
        props.put("listener.name.listener1.gssapi.config1.key", "custom.config1");
        props.put("custom.config2.key", "custom.config2");
        props.put("listener.name.listener1.confluent.proxy.protocol.version", "V1");
        TestSecurityConfig securityConfig = new TestSecurityConfig(props);
        Map configs = ChannelBuilders.channelBuilderConfigs((AbstractConfig)securityConfig, (ListenerName)new ListenerName("listener1"));
        Assertions.assertNull(configs.get("listener.name.listener1.gssapi.sasl.kerberos.service.name"));
        Assertions.assertFalse((boolean)securityConfig.unused().contains("listener.name.listener1.gssapi.sasl.kerberos.service.name"));
        Assertions.assertEquals(configs.get("gssapi.sasl.kerberos.service.name"), (Object)"testkafka");
        Assertions.assertFalse((boolean)securityConfig.unused().contains("gssapi.sasl.kerberos.service.name"));
        Assertions.assertEquals(configs.get("sasl.kerberos.service.name"), (Object)"testkafkaglobal");
        Assertions.assertFalse((boolean)securityConfig.unused().contains("sasl.kerberos.service.name"));
        Assertions.assertNull(configs.get("listener.name.listener1.sasl.kerberos.service.name"));
        Assertions.assertFalse((boolean)securityConfig.unused().contains("listener.name.listener1.sasl.kerberos.service.name"));
        Assertions.assertNull(configs.get("plain.sasl.server.callback.handler.class"));
        Assertions.assertFalse((boolean)securityConfig.unused().contains("plain.sasl.server.callback.handler.class"));
        Assertions.assertEquals(configs.get("listener.name.listener1.gssapi.config1.key"), (Object)"custom.config1");
        Assertions.assertFalse((boolean)securityConfig.unused().contains("listener.name.listener1.gssapi.config1.key"));
        Assertions.assertEquals(configs.get("custom.config2.key"), (Object)"custom.config2");
        Assertions.assertFalse((boolean)securityConfig.unused().contains("custom.config2.key"));
        Assertions.assertEquals(configs.get("confluent.proxy.protocol.version"), (Object)"V1");
        Assertions.assertFalse((boolean)securityConfig.unused().contains("confluent.proxy.protocol.version"));
        Assertions.assertNull(configs.get("listener.name.listener1.confluent.proxy.protocol.version"));
        Assertions.assertFalse((boolean)securityConfig.unused().contains("listener.name.listener1.confluent.proxy.protocol.version"));
        securityConfig = new TestSecurityConfig(props);
        configs = ChannelBuilders.channelBuilderConfigs((AbstractConfig)securityConfig, null);
        Assertions.assertEquals(configs.get("listener.name.listener1.gssapi.sasl.kerberos.service.name"), (Object)"testkafka");
        Assertions.assertFalse((boolean)securityConfig.unused().contains("listener.name.listener1.gssapi.sasl.kerberos.service.name"));
        Assertions.assertNull(configs.get("gssapi.sasl.kerberos.service.name"));
        Assertions.assertFalse((boolean)securityConfig.unused().contains("gssapi.sasl.kerberos.service.name"));
        Assertions.assertEquals(configs.get("listener.name.listener1.sasl.kerberos.service.name"), (Object)"testkafkaglobal");
        Assertions.assertFalse((boolean)securityConfig.unused().contains("listener.name.listener1.sasl.kerberos.service.name"));
        Assertions.assertNull(configs.get("sasl.kerberos.service.name"));
        Assertions.assertFalse((boolean)securityConfig.unused().contains("sasl.kerberos.service.name"));
        Assertions.assertEquals(configs.get("plain.sasl.server.callback.handler.class"), (Object)"callback");
        Assertions.assertFalse((boolean)securityConfig.unused().contains("plain.sasl.server.callback.handler.class"));
        Assertions.assertEquals(configs.get("listener.name.listener1.gssapi.config1.key"), (Object)"custom.config1");
        Assertions.assertFalse((boolean)securityConfig.unused().contains("listener.name.listener1.gssapi.config1.key"));
        Assertions.assertEquals(configs.get("custom.config2.key"), (Object)"custom.config2");
        Assertions.assertFalse((boolean)securityConfig.unused().contains("custom.config2.key"));
        Assertions.assertEquals(configs.get("listener.name.listener1.confluent.proxy.protocol.version"), (Object)"V1");
        Assertions.assertFalse((boolean)securityConfig.unused().contains("listener.name.listener1.confluent.proxy.protocol.version"));
        Assertions.assertEquals(configs.get("confluent.proxy.protocol.version"), (Object)"NONE");
        Assertions.assertFalse((boolean)securityConfig.unused().contains("confluent.proxy.protocol.version"));
    }

    @Test
    public void testClientBuilderWithConfluentConfigs() {
        Properties props = new Properties();
        props.put("confluent.multitenant.parse.sni.host.name.enable", "true");
        props.put("confluent.multitenant.parse.lkc.id.enable", "true");
        TestSecurityConfig testConfig = new TestSecurityConfig(props);
        ChannelBuilder channelBuilder = ChannelBuilders.clientChannelBuilder((SecurityProtocol)SecurityProtocol.PLAINTEXT, (JaasContext.Type)JaasContext.Type.CLIENT, (AbstractConfig)testConfig, (ListenerName)new ListenerName("listener1"), (String)"PLAIN", (Time)new MockTime(), (boolean)true, (LogContext)new LogContext());
        Assertions.assertNotNull((Object)channelBuilder);
    }

    public static class ConfigurableKafkaPrincipalBuilder
    implements KafkaPrincipalBuilder,
    Configurable {
        private boolean configured = false;

        public void configure(Map<String, ?> configs) {
            this.configured = true;
        }

        public KafkaPrincipal build(AuthenticationContext context) {
            return null;
        }
    }
}

