/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.message.FetchRequestData;
import org.apache.kafka.common.message.ProduceRequestData;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.ProduceConsumeAuditLogTracker;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.record.RecordVersion;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.DetailedRequestAuditLogFilter;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.ProduceRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.LogAction;
import org.apache.kafka.common.utils.MockTime;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class DetailedRequestAuditLogFilterTest {
    private final MockTime time = new MockTime();

    @Test
    public void testDefaultConfig() {
        DetailedRequestAuditLogFilter filter = new DetailedRequestAuditLogFilter();
        HashMap configs = new HashMap();
        filter.configure(configs);
        DetailedRequestAuditLogFilter.SUPPORTED_APIS_MGMT_OPERATIONS.forEach(apiKey -> {
            Request request = new Request(this.newRequestContext((ApiKeys)apiKey), this.time.nanoseconds());
            Assertions.assertFalse((boolean)filter.processRequest(request.context, null, request.time).shouldLog());
        });
        DetailedRequestAuditLogFilter.SUPPORTED_APIS_PRODUCE_CONSUME.forEach(apiKey -> {
            Request request = new Request(this.newRequestContext((ApiKeys)apiKey), this.time.nanoseconds());
            Assertions.assertFalse((boolean)filter.processRequest(request.context, null, request.time).shouldLog());
        });
        Arrays.stream(ApiKeys.values()).filter(key -> !DetailedRequestAuditLogFilter.SUPPORTED_APIS_MGMT_OPERATIONS.contains(key)).forEach(apiKey -> {
            Request request = new Request(this.newRequestContext((ApiKeys)apiKey), this.time.nanoseconds());
            Assertions.assertFalse((boolean)filter.processRequest(request.context, null, request.time).shouldLog());
        });
        Arrays.stream(ApiKeys.values()).filter(key -> !DetailedRequestAuditLogFilter.SUPPORTED_APIS_PRODUCE_CONSUME.contains(key)).forEach(apiKey -> {
            Request request = new Request(this.newRequestContext((ApiKeys)apiKey), this.time.nanoseconds());
            Assertions.assertFalse((boolean)filter.processRequest(request.context, null, request.time).shouldLog());
        });
    }

    @Test
    public void testWithEnableDetailedAuditLogs() {
        DetailedRequestAuditLogFilter filter = new DetailedRequestAuditLogFilter();
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("confluent.security.event.logger.enable.detailed.audit.logs", "true");
        filter.configure(configs);
        DetailedRequestAuditLogFilter.SUPPORTED_APIS_MGMT_OPERATIONS.forEach(apiKey -> {
            Request request = new Request(this.newRequestContext((ApiKeys)apiKey), this.time.nanoseconds());
            Assertions.assertTrue((boolean)filter.processRequest(request.context, null, request.time).shouldLog());
        });
        Arrays.stream(ApiKeys.values()).filter(key -> !DetailedRequestAuditLogFilter.SUPPORTED_APIS_MGMT_OPERATIONS.contains(key)).forEach(apiKey -> {
            Request request = new Request(this.newRequestContext((ApiKeys)apiKey), this.time.nanoseconds());
            Assertions.assertFalse((boolean)filter.processRequest(request.context, null, request.time).shouldLog());
        });
    }

    @Test
    public void testWithEnableProduceConsumeAuditLogs() {
        DetailedRequestAuditLogFilter filter = new DetailedRequestAuditLogFilter();
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("confluent.security.event.logger.enable.produce.consume.audit.logs", "true");
        filter.configure(configs);
        RequestContext requestContext = (RequestContext)Mockito.mock(RequestContext.class);
        requestContext.produceConsumeAuditLogTracker = new ProduceConsumeAuditLogTracker();
        Mockito.when((Object)requestContext.apiKey()).thenReturn((Object)ApiKeys.PRODUCE);
        HashMap<String, List<Integer>> topicPartitionsMap = new HashMap<String, List<Integer>>();
        topicPartitionsMap.put("topic1", Arrays.asList(1, 2, 1));
        topicPartitionsMap.put("topic2", Collections.singletonList(1));
        ProduceRequest produceRequest1 = this.buildProduceRequest(topicPartitionsMap);
        LogAction kafkaEventLogAction = filter.processRequest(requestContext, (AbstractRequest)produceRequest1, 1L);
        Assertions.assertTrue((boolean)kafkaEventLogAction.shouldLog());
        requestContext.produceConsumeAuditLogTracker.addProduceTopic(new ProduceConsumeAuditLogTracker.TopicDetails(Uuid.ZERO_UUID, "topic1"));
        requestContext.produceConsumeAuditLogTracker.addProduceTopic(new ProduceConsumeAuditLogTracker.TopicDetails(Uuid.ZERO_UUID, "topic2"));
        topicPartitionsMap = new HashMap();
        topicPartitionsMap.put("topic1", Collections.singletonList(2));
        topicPartitionsMap.put("topic3", Arrays.asList(1, 2));
        ProduceRequest produceRequest2 = this.buildProduceRequest(topicPartitionsMap);
        kafkaEventLogAction = filter.processRequest(requestContext, (AbstractRequest)produceRequest2, 1L);
        Assertions.assertTrue((boolean)kafkaEventLogAction.shouldLog());
        requestContext.produceConsumeAuditLogTracker.addProduceTopic(new ProduceConsumeAuditLogTracker.TopicDetails(Uuid.ZERO_UUID, "topic3"));
        topicPartitionsMap = new HashMap();
        topicPartitionsMap.put("topic1", Collections.singletonList(1));
        topicPartitionsMap.put("topic2", Collections.singletonList(2));
        ProduceRequest produceRequest3 = this.buildProduceRequest(topicPartitionsMap);
        kafkaEventLogAction = filter.processRequest(requestContext, (AbstractRequest)produceRequest3, 1L);
        Assertions.assertFalse((boolean)kafkaEventLogAction.shouldLog());
        Mockito.when((Object)requestContext.apiKey()).thenReturn((Object)ApiKeys.FETCH);
        topicPartitionsMap = new HashMap();
        topicPartitionsMap.put("topic1", Arrays.asList(1, 2));
        topicPartitionsMap.put("topic2", Collections.singletonList(1));
        FetchRequest fetchRequest1 = this.buildFetchRequest(topicPartitionsMap);
        kafkaEventLogAction = filter.processRequest(requestContext, (AbstractRequest)fetchRequest1, 1L);
        Assertions.assertTrue((boolean)kafkaEventLogAction.shouldLog());
        requestContext.produceConsumeAuditLogTracker.addConsumeTopic(new ProduceConsumeAuditLogTracker.TopicDetails(Uuid.ZERO_UUID, "topic1"));
        requestContext.produceConsumeAuditLogTracker.addConsumeTopic(new ProduceConsumeAuditLogTracker.TopicDetails(Uuid.ZERO_UUID, "topic2"));
        topicPartitionsMap = new HashMap();
        topicPartitionsMap.put("topic1", Collections.singletonList(1));
        topicPartitionsMap.put("topic2", Collections.singletonList(1));
        FetchRequest fetchRequest2 = this.buildFetchRequest(topicPartitionsMap);
        kafkaEventLogAction = filter.processRequest(requestContext, (AbstractRequest)fetchRequest2, 1L);
        Assertions.assertFalse((boolean)kafkaEventLogAction.shouldLog());
        HashMap<Uuid, List<Integer>> topicIdPartitionsMap = new HashMap<Uuid, List<Integer>>();
        Uuid topic3 = Uuid.randomUuid();
        Uuid topic4 = Uuid.randomUuid();
        topicIdPartitionsMap.put(topic3, Arrays.asList(1, 2));
        topicIdPartitionsMap.put(topic4, Collections.singletonList(3));
        FetchRequest fetchRequest3 = this.buildFetchRequest(topicIdPartitionsMap);
        kafkaEventLogAction = filter.processRequest(requestContext, (AbstractRequest)fetchRequest3, 1L);
        Assertions.assertTrue((boolean)kafkaEventLogAction.shouldLog());
        requestContext.produceConsumeAuditLogTracker.addConsumeTopic(new ProduceConsumeAuditLogTracker.TopicDetails(topic3, ""));
        requestContext.produceConsumeAuditLogTracker.addConsumeTopic(new ProduceConsumeAuditLogTracker.TopicDetails(topic4, ""));
        EnumSet<ApiKeys> disabledAPIs = EnumSet.of(ApiKeys.PRODUCE);
        String disabledAPIsConfig = disabledAPIs.stream().map(key -> key.name).collect(Collectors.joining(","));
        configs.put("confluent.security.event.logger.detailed.audit.logs.disabled.apis", disabledAPIsConfig);
        filter.reconfigure(configs);
        topicPartitionsMap = new HashMap();
        topicPartitionsMap.put("topic3", Collections.singletonList(1));
        ProduceRequest produceRequest4 = this.buildProduceRequest(topicPartitionsMap);
        Mockito.when((Object)requestContext.apiKey()).thenReturn((Object)ApiKeys.PRODUCE);
        kafkaEventLogAction = filter.processRequest(requestContext, (AbstractRequest)produceRequest4, 1L);
        Assertions.assertFalse((boolean)kafkaEventLogAction.shouldLog());
        topicPartitionsMap = new HashMap();
        topicPartitionsMap.put("topic3", Collections.singletonList(2));
        FetchRequest fetchRequest4 = this.buildFetchRequest(topicPartitionsMap);
        Mockito.when((Object)requestContext.apiKey()).thenReturn((Object)ApiKeys.FETCH);
        kafkaEventLogAction = filter.processRequest(requestContext, (AbstractRequest)fetchRequest4, 1L);
        Assertions.assertTrue((boolean)kafkaEventLogAction.shouldLog());
    }

    @Test
    public void testDisabledApiConfig() {
        DetailedRequestAuditLogFilter filter = new DetailedRequestAuditLogFilter();
        EnumSet<ApiKeys> disabledAPIs = EnumSet.of(ApiKeys.DELETE_TOPICS, ApiKeys.CREATE_CLUSTER_LINKS, ApiKeys.ALTER_CONFIGS);
        String disabledAPIsConfig = disabledAPIs.stream().map(key -> key.name).collect(Collectors.joining(","));
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("confluent.security.event.logger.enable.detailed.audit.logs", "true");
        configs.put("confluent.security.event.logger.detailed.audit.logs.disabled.apis", disabledAPIsConfig);
        filter.configure(configs);
        DetailedRequestAuditLogFilter.SUPPORTED_APIS_MGMT_OPERATIONS.stream().filter(key -> !disabledAPIs.contains(key)).forEach(apiKey -> {
            Request request = new Request(this.newRequestContext((ApiKeys)apiKey), this.time.nanoseconds());
            Assertions.assertTrue((boolean)filter.processRequest(request.context, null, request.time).shouldLog());
        });
        disabledAPIs.forEach(apiKey -> {
            Request request = new Request(this.newRequestContext((ApiKeys)apiKey), this.time.nanoseconds());
            Assertions.assertFalse((boolean)filter.processRequest(request.context, null, request.time).shouldLog());
        });
        Arrays.stream(ApiKeys.values()).filter(key -> !DetailedRequestAuditLogFilter.SUPPORTED_APIS_MGMT_OPERATIONS.contains(key)).forEach(apiKey -> {
            Request request1 = new Request(this.newRequestContext((ApiKeys)apiKey), this.time.nanoseconds());
            Assertions.assertFalse((boolean)filter.processRequest(request1.context, null, request1.time).shouldLog());
        });
    }

    @Test
    public void testInvalidDefaultConfigs() {
        this.assertThrowsConfigException(Collections.singletonMap("confluent.security.event.logger.detailed.audit.logs.disabled.apis", "UnknownAPI"));
        this.assertThrowsConfigException(Collections.singletonMap("confluent.security.event.logger.detailed.audit.logs.disabled.apis", "CreateTopics,UnknownAPI"));
    }

    private void assertThrowsConfigException(Map<String, ?> configs) {
        DetailedRequestAuditLogFilter filter = new DetailedRequestAuditLogFilter();
        Assertions.assertThrows(ConfigException.class, () -> filter.validateReconfiguration(configs));
        Assertions.assertThrows(ConfigException.class, () -> filter.configure(configs));
        Assertions.assertThrows(ConfigException.class, () -> filter.reconfigure(configs));
    }

    private RequestContext newRequestContext(ApiKeys apiKey) {
        RequestHeader header = new RequestHeader(apiKey, apiKey.latestVersion(), "clientId", 1);
        return new RequestContext(header, "cxnId", InetAddress.getLoopbackAddress(), KafkaPrincipal.ANONYMOUS, new ListenerName("PLAINTEXT"), SecurityProtocol.PLAINTEXT, ClientInformation.EMPTY, null, false, Optional.empty());
    }

    private ProduceRequest buildProduceRequest(HashMap<String, List<Integer>> topicProduceDataCollectionMap) {
        ProduceRequestData.TopicProduceDataCollection topicProduceDataCollection = new ProduceRequestData.TopicProduceDataCollection(topicProduceDataCollectionMap.size());
        topicProduceDataCollectionMap.forEach((topic, partitions) -> topicProduceDataCollection.add((ImplicitLinkedHashCollection.Element)new ProduceRequestData.TopicProduceData().setName(topic).setPartitionData((List)new ArrayList<ProduceRequestData.PartitionProduceData>(){
            {
                partitions.forEach((? super T partition) -> this.add(new ProduceRequestData.PartitionProduceData().setIndex(partition.intValue())));
            }
        })));
        ProduceRequestData requestData = new ProduceRequestData().setAcks((short)-1).setTimeoutMs(30000).setTopicData(topicProduceDataCollection);
        return (ProduceRequest)ProduceRequest.forMagic((byte)RecordVersion.V2.value, (ProduceRequestData)requestData).build();
    }

    private <T> FetchRequest buildFetchRequest(HashMap<T, List<Integer>> fetchTopicMap) {
        ArrayList fetchTopics = new ArrayList();
        fetchTopicMap.forEach((topic, partitions) -> fetchTopics.add(new FetchRequestData.FetchTopic().setTopic(topic instanceof String ? (String)topic : "").setTopicId(topic instanceof Uuid ? (Uuid)topic : Uuid.ZERO_UUID).setPartitions((List)new ArrayList<FetchRequestData.FetchPartition>(){
            {
                partitions.forEach((? super T partition) -> this.add(new FetchRequestData.FetchPartition().setPartition(partition.intValue())));
            }
        })));
        FetchRequestData fetchRequestData = new FetchRequestData().setTopics(fetchTopics);
        return new FetchRequest(fetchRequestData, 12);
    }

    private static class Request {
        private final RequestContext context;
        private final long time;

        private Request(RequestContext context, long time) {
            this.context = context;
            this.time = time;
        }
    }
}

