/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.message.LeaderAndIsrResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.requests.LeaderAndIsrResponse;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LeaderAndIsrResponseTest {
    @Test
    public void testErrorCountsFromGetErrorResponse() {
        ArrayList<LeaderAndIsrRequestData.LeaderAndIsrPartitionState> partitionStates = new ArrayList<LeaderAndIsrRequestData.LeaderAndIsrPartitionState>();
        partitionStates.add(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName("foo").setPartitionIndex(0).setControllerEpoch(15).setLeader(1).setLeaderEpoch(10).setIsr(Collections.singletonList(10)).setPartitionEpoch(20).setReplicas(Collections.singletonList(10)).setIsNew(false));
        partitionStates.add(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName("foo").setPartitionIndex(1).setControllerEpoch(15).setLeader(1).setLeaderEpoch(10).setIsr(Collections.singletonList(10)).setPartitionEpoch(20).setReplicas(Collections.singletonList(10)).setIsNew(false));
        Map<String, Uuid> topicIds = Collections.singletonMap("foo", Uuid.randomUuid());
        LeaderAndIsrRequest request = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 15, 20, 0L, partitionStates, topicIds, false, Collections.emptySet(), false).build();
        LeaderAndIsrResponse response = request.getErrorResponse(0, (Throwable)Errors.CLUSTER_AUTHORIZATION_FAILED.exception());
        Assertions.assertEquals(Collections.singletonMap(Errors.CLUSTER_AUTHORIZATION_FAILED, 3), (Object)response.errorCounts());
    }

    @Test
    public void testErrorCountsWithTopLevelError() {
        Iterator iterator = ApiKeys.LEADER_AND_ISR.allVersions().iterator();
        while (iterator.hasNext()) {
            LeaderAndIsrResponse response;
            short version = (Short)iterator.next();
            if (version < 5) {
                List<LeaderAndIsrResponseData.LeaderAndIsrPartitionError> partitions = this.createPartitions("foo", Arrays.asList(Errors.NONE, Errors.NOT_LEADER_OR_FOLLOWER));
                response = new LeaderAndIsrResponse(new LeaderAndIsrResponseData().setErrorCode(Errors.UNKNOWN_SERVER_ERROR.code()).setPartitionErrors(partitions), version);
            } else {
                Uuid id = Uuid.randomUuid();
                LeaderAndIsrResponseData.LeaderAndIsrTopicErrorCollection topics = this.createTopic(id, Arrays.asList(Errors.NONE, Errors.NOT_LEADER_OR_FOLLOWER));
                response = new LeaderAndIsrResponse(new LeaderAndIsrResponseData().setErrorCode(Errors.UNKNOWN_SERVER_ERROR.code()).setTopics(topics), version);
            }
            Assertions.assertEquals(Collections.singletonMap(Errors.UNKNOWN_SERVER_ERROR, 3), (Object)response.errorCounts());
        }
    }

    @Test
    public void testErrorCountsNoTopLevelError() {
        Iterator iterator = ApiKeys.LEADER_AND_ISR.allVersions().iterator();
        while (iterator.hasNext()) {
            LeaderAndIsrResponse response;
            short version = (Short)iterator.next();
            if (version < 5) {
                List<LeaderAndIsrResponseData.LeaderAndIsrPartitionError> partitions = this.createPartitions("foo", Arrays.asList(Errors.NONE, Errors.CLUSTER_AUTHORIZATION_FAILED));
                response = new LeaderAndIsrResponse(new LeaderAndIsrResponseData().setErrorCode(Errors.NONE.code()).setPartitionErrors(partitions), version);
            } else {
                Uuid id = Uuid.randomUuid();
                LeaderAndIsrResponseData.LeaderAndIsrTopicErrorCollection topics = this.createTopic(id, Arrays.asList(Errors.NONE, Errors.CLUSTER_AUTHORIZATION_FAILED));
                response = new LeaderAndIsrResponse(new LeaderAndIsrResponseData().setErrorCode(Errors.NONE.code()).setTopics(topics), version);
            }
            Map errorCounts = response.errorCounts();
            Assertions.assertEquals((int)2, (int)errorCounts.size());
            Assertions.assertEquals((int)2, (int)((Integer)errorCounts.get(Errors.NONE)));
            Assertions.assertEquals((int)1, (int)((Integer)errorCounts.get(Errors.CLUSTER_AUTHORIZATION_FAILED)));
        }
    }

    @Test
    public void testToString() {
        Iterator iterator = ApiKeys.LEADER_AND_ISR.allVersions().iterator();
        while (iterator.hasNext()) {
            LeaderAndIsrResponse response;
            short version = (Short)iterator.next();
            if (version < 5) {
                List<LeaderAndIsrResponseData.LeaderAndIsrPartitionError> partitions = this.createPartitions("foo", Arrays.asList(Errors.NONE, Errors.CLUSTER_AUTHORIZATION_FAILED));
                response = new LeaderAndIsrResponse(new LeaderAndIsrResponseData().setErrorCode(Errors.NONE.code()).setPartitionErrors(partitions), version);
                String responseStr = response.toString();
                Assertions.assertTrue((boolean)responseStr.contains(LeaderAndIsrResponse.class.getSimpleName()));
                Assertions.assertTrue((boolean)responseStr.contains(partitions.toString()));
                Assertions.assertTrue((boolean)responseStr.contains("errorCode=" + Errors.NONE.code()));
                continue;
            }
            Uuid id = Uuid.randomUuid();
            LeaderAndIsrResponseData.LeaderAndIsrTopicErrorCollection topics = this.createTopic(id, Arrays.asList(Errors.NONE, Errors.CLUSTER_AUTHORIZATION_FAILED));
            response = new LeaderAndIsrResponse(new LeaderAndIsrResponseData().setErrorCode(Errors.NONE.code()).setTopics(topics), version);
            String responseStr = response.toString();
            Assertions.assertTrue((boolean)responseStr.contains(LeaderAndIsrResponse.class.getSimpleName()));
            Assertions.assertTrue((boolean)responseStr.contains(topics.toString()));
            Assertions.assertTrue((boolean)responseStr.contains(id.toString()));
            Assertions.assertTrue((boolean)responseStr.contains("errorCode=" + Errors.NONE.code()));
        }
    }

    private List<LeaderAndIsrResponseData.LeaderAndIsrPartitionError> createPartitions(String topicName, List<Errors> errors) {
        ArrayList<LeaderAndIsrResponseData.LeaderAndIsrPartitionError> partitions = new ArrayList<LeaderAndIsrResponseData.LeaderAndIsrPartitionError>();
        int partitionIndex = 0;
        for (Errors error : errors) {
            partitions.add(new LeaderAndIsrResponseData.LeaderAndIsrPartitionError().setTopicName(topicName).setPartitionIndex(partitionIndex++).setErrorCode(error.code()));
        }
        return partitions;
    }

    private LeaderAndIsrResponseData.LeaderAndIsrTopicErrorCollection createTopic(Uuid id, List<Errors> errors) {
        LeaderAndIsrResponseData.LeaderAndIsrTopicErrorCollection topics = new LeaderAndIsrResponseData.LeaderAndIsrTopicErrorCollection();
        LeaderAndIsrResponseData.LeaderAndIsrTopicError topic = new LeaderAndIsrResponseData.LeaderAndIsrTopicError();
        topic.setTopicId(id);
        ArrayList<LeaderAndIsrResponseData.LeaderAndIsrPartitionError> partitions = new ArrayList<LeaderAndIsrResponseData.LeaderAndIsrPartitionError>();
        int partitionIndex = 0;
        for (Errors error : errors) {
            partitions.add(new LeaderAndIsrResponseData.LeaderAndIsrPartitionError().setPartitionIndex(partitionIndex++).setErrorCode(error.code()));
        }
        topic.setPartitionErrors(partitions);
        topics.add((ImplicitLinkedHashCollection.Element)topic);
        return topics;
    }
}

