/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.LeaveGroupRequestData;
import org.apache.kafka.common.message.LeaveGroupResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.LeaveGroupRequest;
import org.apache.kafka.common.requests.LeaveGroupResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class LeaveGroupRequestTest {
    private final String groupId = "group_id";
    private final String memberIdOne = "member_1";
    private final String instanceIdOne = "instance_1";
    private final String memberIdTwo = "member_2";
    private final String instanceIdTwo = "instance_2";
    private final int throttleTimeMs = 10;
    private LeaveGroupRequest.Builder builder;
    private List<LeaveGroupRequestData.MemberIdentity> members;

    @BeforeEach
    public void setUp() {
        this.members = Arrays.asList(new LeaveGroupRequestData.MemberIdentity().setMemberId("member_1").setGroupInstanceId("instance_1"), new LeaveGroupRequestData.MemberIdentity().setMemberId("member_2").setGroupInstanceId("instance_2"));
        this.builder = new LeaveGroupRequest.Builder("group_id", this.members);
    }

    @Test
    public void testMultiLeaveConstructor() {
        LeaveGroupRequestData expectedData = new LeaveGroupRequestData().setGroupId("group_id").setMembers(this.members);
        Iterator iterator = ApiKeys.LEAVE_GROUP.allVersions().iterator();
        while (iterator.hasNext()) {
            short version = (Short)iterator.next();
            try {
                LeaveGroupRequest request = this.builder.build(version);
                if (version <= 2) {
                    Assertions.fail((String)("Older version " + version + " request data should not be created due to non-single members"));
                }
                Assertions.assertEquals((Object)expectedData, (Object)request.data());
                Assertions.assertEquals(this.members, (Object)request.members());
                LeaveGroupResponse expectedResponse = new LeaveGroupResponse(Collections.emptyList(), Errors.COORDINATOR_LOAD_IN_PROGRESS, 10, version);
                Assertions.assertEquals((Object)expectedResponse, (Object)request.getErrorResponse(10, (Throwable)Errors.COORDINATOR_LOAD_IN_PROGRESS.exception()));
            }
            catch (UnsupportedVersionException e) {
                Assertions.assertTrue((boolean)e.getMessage().contains("leave group request only supports single member instance"));
            }
        }
    }

    @Test
    public void testSingleLeaveConstructor() {
        LeaveGroupRequestData expectedData = new LeaveGroupRequestData().setGroupId("group_id").setMemberId("member_1");
        List<LeaveGroupRequestData.MemberIdentity> singleMember = Collections.singletonList(new LeaveGroupRequestData.MemberIdentity().setMemberId("member_1"));
        this.builder = new LeaveGroupRequest.Builder("group_id", singleMember);
        for (short version = 0; version <= 2; version = (short)(version + 1)) {
            LeaveGroupRequest request = this.builder.build(version);
            Assertions.assertEquals((Object)expectedData, (Object)request.data());
            Assertions.assertEquals(singleMember, (Object)request.members());
            int expectedThrottleTime = version >= 1 ? 10 : 0;
            LeaveGroupResponse expectedResponse = new LeaveGroupResponse(new LeaveGroupResponseData().setErrorCode(Errors.NOT_CONTROLLER.code()).setThrottleTimeMs(expectedThrottleTime));
            Assertions.assertEquals((Object)expectedResponse, (Object)request.getErrorResponse(10, (Throwable)Errors.NOT_CONTROLLER.exception()));
        }
    }

    @Test
    public void testBuildEmptyMembers() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new LeaveGroupRequest.Builder("group_id", Collections.emptyList()));
    }
}

