/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Collections;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.message.CreateTopicsResponseData;
import org.apache.kafka.common.message.ProduceRequestData;
import org.apache.kafka.common.message.SaslAuthenticateRequestData;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.network.TransferableChannel;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.requests.ByteBufferChannel;
import org.apache.kafka.common.requests.CreateTopicsResponse;
import org.apache.kafka.common.requests.RequestAndSize;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.ResponseHeader;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RequestContextTest {
    public static RequestContext makeContext(ApiKeys apiKey) throws UnknownHostException {
        return new RequestContext(new RequestHeader(apiKey, apiKey.latestVersion(), "client", 0), "1", InetAddress.getLocalHost(), KafkaPrincipal.ANONYMOUS, ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), SecurityProtocol.PLAINTEXT, ClientInformation.EMPTY, null, false);
    }

    @Test
    public void testSerdeUnsupportedApiVersionRequest() throws Exception {
        int correlationId = 23423;
        RequestHeader header = new RequestHeader(ApiKeys.API_VERSIONS, Short.MAX_VALUE, "", correlationId);
        RequestContext context = new RequestContext(header, "0", InetAddress.getLocalHost(), KafkaPrincipal.ANONYMOUS, new ListenerName("ssl"), SecurityProtocol.SASL_SSL, ClientInformation.EMPTY, null, false);
        Assertions.assertEquals((int)0, (int)context.apiVersion());
        ByteBuffer requestBuffer = ByteBuffer.allocate(8);
        requestBuffer.putInt(3709234);
        requestBuffer.putInt(29034);
        requestBuffer.flip();
        RequestAndSize requestAndSize = context.parseRequest(requestBuffer);
        Assertions.assertTrue((boolean)(requestAndSize.request instanceof ApiVersionsRequest));
        ApiVersionsRequest request = (ApiVersionsRequest)requestAndSize.request;
        Assertions.assertTrue((boolean)request.hasUnsupportedRequestVersion());
        RequestContext.ResponseSend responseSend = context.buildResponseSend((AbstractResponse)new ApiVersionsResponse(new ApiVersionsResponseData().setThrottleTimeMs(0).setErrorCode(Errors.UNSUPPORTED_VERSION.code()).setApiKeys(new ApiVersionsResponseData.ApiVersionCollection())));
        responseSend.getDelayedActions().forEach(action -> action.run());
        Send send = responseSend.getSend();
        ByteBufferChannel channel = new ByteBufferChannel(256L);
        send.writeTo((TransferableChannel)channel);
        ByteBuffer responseBuffer = channel.buffer();
        responseBuffer.flip();
        responseBuffer.getInt();
        ResponseHeader responseHeader = ResponseHeader.parse((ByteBuffer)responseBuffer, (short)ApiKeys.API_VERSIONS.responseHeaderVersion(header.apiVersion()));
        Assertions.assertEquals((int)correlationId, (int)responseHeader.correlationId());
        ApiVersionsResponse response = ApiVersionsResponse.parse((ByteBuffer)responseBuffer, (short)0, (MessageContext)MessageContext.IDENTITY);
        Assertions.assertEquals((short)Errors.UNSUPPORTED_VERSION.code(), (short)response.data().errorCode());
        Assertions.assertTrue((boolean)response.data().apiKeys().isEmpty());
    }

    @Test
    public void testEnvelopeResponseSerde() throws Exception {
        CreateTopicsResponseData.CreatableTopicResultCollection collection = new CreateTopicsResponseData.CreatableTopicResultCollection();
        collection.add((ImplicitLinkedHashCollection.Element)new CreateTopicsResponseData.CreatableTopicResult().setTopicConfigErrorCode(Errors.CLUSTER_AUTHORIZATION_FAILED.code()).setNumPartitions(5));
        CreateTopicsResponseData expectedResponse = new CreateTopicsResponseData().setThrottleTimeMs(10).setTopics(collection);
        int correlationId = 15;
        String clientId = "clientId";
        RequestHeader header = new RequestHeader(ApiKeys.CREATE_TOPICS, ApiKeys.CREATE_TOPICS.latestVersion(), clientId, correlationId);
        RequestContext context = new RequestContext(header, "0", InetAddress.getLocalHost(), KafkaPrincipal.ANONYMOUS, new ListenerName("ssl"), SecurityProtocol.SASL_SSL, ClientInformation.EMPTY, null, true);
        ByteBuffer buffer = context.buildResponseEnvelopePayload((AbstractResponse)new CreateTopicsResponse(expectedResponse));
        Assertions.assertEquals((int)buffer.capacity(), (int)buffer.limit(), (String)"Buffer limit and capacity should be the same");
        CreateTopicsResponse parsedResponse = (CreateTopicsResponse)AbstractResponse.parseResponse((ByteBuffer)buffer, (RequestHeader)header, (MessageContext)MessageContext.IDENTITY);
        Assertions.assertEquals((Object)expectedResponse, (Object)parsedResponse.data());
    }

    @Test
    public void testInvalidRequestForImplicitHashCollection() throws UnknownHostException {
        short version = 5;
        ByteBuffer corruptBuffer = this.produceRequest(version);
        corruptBuffer.putInt(8, 0x3FFFFFFF);
        RequestHeader header = new RequestHeader(ApiKeys.PRODUCE, version, "console-producer", 3);
        RequestContext context = new RequestContext(header, "0", InetAddress.getLocalHost(), KafkaPrincipal.ANONYMOUS, new ListenerName("ssl"), SecurityProtocol.SASL_SSL, ClientInformation.EMPTY, null, true);
        String msg = ((InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> context.parseRequest(corruptBuffer))).getCause().getMessage();
        Assertions.assertEquals((Object)"Tried to allocate a collection of size 1073741823, but there are only 17 bytes remaining.", (Object)msg);
    }

    @Test
    public void testInvalidRequestForArrayList() throws UnknownHostException {
        short version = 5;
        ByteBuffer corruptBuffer = this.produceRequest(version);
        corruptBuffer.putInt(17, Integer.MAX_VALUE);
        RequestHeader header = new RequestHeader(ApiKeys.PRODUCE, version, "console-producer", 3);
        RequestContext context = new RequestContext(header, "0", InetAddress.getLocalHost(), KafkaPrincipal.ANONYMOUS, new ListenerName("ssl"), SecurityProtocol.SASL_SSL, ClientInformation.EMPTY, null, true);
        String msg = ((InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> context.parseRequest(corruptBuffer))).getCause().getMessage();
        Assertions.assertEquals((Object)"Tried to allocate a collection of size 2147483647, but there are only 8 bytes remaining.", (Object)msg);
    }

    private ByteBuffer produceRequest(short version) {
        ProduceRequestData data = new ProduceRequestData().setAcks((short)-1).setTimeoutMs(1);
        data.topicData().add((ImplicitLinkedHashCollection.Element)new ProduceRequestData.TopicProduceData().setName("foo").setPartitionData(Collections.singletonList(new ProduceRequestData.PartitionProduceData().setIndex(42))));
        return this.serialize(version, (ApiMessage)data);
    }

    private ByteBuffer serialize(short version, ApiMessage data) {
        ObjectSerializationCache cache = new ObjectSerializationCache();
        data.size(cache, version);
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        data.write((Writable)new ByteBufferAccessor(buffer), cache, version);
        buffer.flip();
        return buffer;
    }

    @Test
    public void testInvalidRequestForByteArray() throws UnknownHostException {
        short version = 1;
        ByteBuffer corruptBuffer = this.serialize(version, (ApiMessage)new SaslAuthenticateRequestData().setAuthBytes(new byte[0]));
        corruptBuffer.putInt(0, Integer.MAX_VALUE);
        RequestHeader header = new RequestHeader(ApiKeys.SASL_AUTHENTICATE, version, "console-producer", 1);
        RequestContext context = new RequestContext(header, "0", InetAddress.getLocalHost(), KafkaPrincipal.ANONYMOUS, new ListenerName("ssl"), SecurityProtocol.SASL_SSL, ClientInformation.EMPTY, null, true);
        String msg = ((InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> context.parseRequest(corruptBuffer))).getCause().getMessage();
        Assertions.assertEquals((Object)"Error reading byte array of 2147483647 byte(s): only 0 byte(s) available", (Object)msg);
    }
}

