/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.kafka.clients.admin.FeatureUpdate;
import org.apache.kafka.common.errors.UnknownServerException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.UpdateFeaturesRequestData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.UpdateFeaturesRequest;
import org.apache.kafka.common.requests.UpdateFeaturesResponse;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UpdateFeaturesRequestTest {
    @Test
    public void testGetErrorResponse() {
        UpdateFeaturesRequestData.FeatureUpdateKeyCollection features = new UpdateFeaturesRequestData.FeatureUpdateKeyCollection();
        features.add((ImplicitLinkedHashCollection.Element)new UpdateFeaturesRequestData.FeatureUpdateKey().setFeature("foo").setMaxVersionLevel((short)2));
        features.add((ImplicitLinkedHashCollection.Element)new UpdateFeaturesRequestData.FeatureUpdateKey().setFeature("bar").setMaxVersionLevel((short)3));
        UpdateFeaturesRequest request = new UpdateFeaturesRequest(new UpdateFeaturesRequestData().setFeatureUpdates(features), 1);
        UpdateFeaturesResponse response = request.getErrorResponse(0, (Throwable)new UnknownServerException());
        Assertions.assertEquals((Object)Errors.UNKNOWN_SERVER_ERROR, (Object)response.topLevelError().error());
        Assertions.assertEquals((int)0, (int)response.data().results().size());
        Assertions.assertEquals(Collections.singletonMap(Errors.UNKNOWN_SERVER_ERROR, 1), (Object)response.errorCounts());
    }

    @Test
    public void testUpdateFeaturesV0() {
        UpdateFeaturesRequestData.FeatureUpdateKeyCollection features = new UpdateFeaturesRequestData.FeatureUpdateKeyCollection();
        features.add((ImplicitLinkedHashCollection.Element)new UpdateFeaturesRequestData.FeatureUpdateKey().setFeature("foo").setMaxVersionLevel((short)1).setAllowDowngrade(true));
        features.add((ImplicitLinkedHashCollection.Element)new UpdateFeaturesRequestData.FeatureUpdateKey().setFeature("bar").setMaxVersionLevel((short)3));
        UpdateFeaturesRequest request = new UpdateFeaturesRequest(new UpdateFeaturesRequestData().setFeatureUpdates(features), 0);
        ByteBuffer buffer = request.serialize();
        request = UpdateFeaturesRequest.parse((ByteBuffer)buffer, (short)0, (MessageContext)MessageContext.IDENTITY);
        ArrayList updates = new ArrayList(request.featureUpdates());
        Assertions.assertEquals((int)updates.size(), (int)2);
        Assertions.assertEquals((Object)((UpdateFeaturesRequest.FeatureUpdateItem)updates.get(0)).upgradeType(), (Object)FeatureUpdate.UpgradeType.SAFE_DOWNGRADE);
        Assertions.assertEquals((Object)((UpdateFeaturesRequest.FeatureUpdateItem)updates.get(1)).upgradeType(), (Object)FeatureUpdate.UpgradeType.UPGRADE);
    }

    @Test
    public void testUpdateFeaturesV1() {
        UpdateFeaturesRequestData.FeatureUpdateKeyCollection features = new UpdateFeaturesRequestData.FeatureUpdateKeyCollection();
        features.add((ImplicitLinkedHashCollection.Element)new UpdateFeaturesRequestData.FeatureUpdateKey().setFeature("foo").setMaxVersionLevel((short)1).setUpgradeType(FeatureUpdate.UpgradeType.SAFE_DOWNGRADE.code()));
        features.add((ImplicitLinkedHashCollection.Element)new UpdateFeaturesRequestData.FeatureUpdateKey().setFeature("bar").setMaxVersionLevel((short)3));
        UpdateFeaturesRequest request = new UpdateFeaturesRequest(new UpdateFeaturesRequestData().setFeatureUpdates(features), 1);
        ByteBuffer buffer = request.serialize();
        request = UpdateFeaturesRequest.parse((ByteBuffer)buffer, (short)1, (MessageContext)MessageContext.IDENTITY);
        ArrayList updates = new ArrayList(request.featureUpdates());
        Assertions.assertEquals((int)updates.size(), (int)2);
        Assertions.assertEquals((Object)((UpdateFeaturesRequest.FeatureUpdateItem)updates.get(0)).upgradeType(), (Object)FeatureUpdate.UpgradeType.SAFE_DOWNGRADE);
        Assertions.assertEquals((Object)((UpdateFeaturesRequest.FeatureUpdateItem)updates.get(1)).upgradeType(), (Object)FeatureUpdate.UpgradeType.UPGRADE);
    }

    @Test
    public void testUpdateFeaturesV1OldBoolean() {
        UpdateFeaturesRequestData.FeatureUpdateKeyCollection features = new UpdateFeaturesRequestData.FeatureUpdateKeyCollection();
        features.add((ImplicitLinkedHashCollection.Element)new UpdateFeaturesRequestData.FeatureUpdateKey().setFeature("foo").setMaxVersionLevel((short)1).setAllowDowngrade(true));
        features.add((ImplicitLinkedHashCollection.Element)new UpdateFeaturesRequestData.FeatureUpdateKey().setFeature("bar").setMaxVersionLevel((short)3));
        UpdateFeaturesRequest request = new UpdateFeaturesRequest(new UpdateFeaturesRequestData().setFeatureUpdates(features), 1);
        Assertions.assertThrows(UnsupportedVersionException.class, () -> ((UpdateFeaturesRequest)request).serialize(), (String)"This should fail since allowDowngrade is not supported in v1 of this RPC");
    }
}

