/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.test;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Meter;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.server.interceptor.RecordInterceptor;

public class InterceptorUtils {

    public static class AnotherMockRecordInterceptor
    implements RecordInterceptor {
        public static final List<Record> INTERCEPTED = new ArrayList<Record>();
        public static final Map<String, Object> CONFIGURED = new HashMap<String, Object>();

        public AnotherMockRecordInterceptor() {
            INTERCEPTED.clear();
            CONFIGURED.clear();
        }

        public void configure(Map<String, ?> configs) {
            CONFIGURED.putAll(configs);
        }

        public RecordInterceptor.RecordInterceptorResponse onAppend(TopicPartition tp, Record record) {
            INTERCEPTED.add(record);
            if (ByteBuffer.wrap("reject me please".getBytes()).equals(record.value())) {
                return RecordInterceptor.RecordInterceptorResponse.REJECT;
            }
            return RecordInterceptor.RecordInterceptorResponse.ACCEPT;
        }
    }

    public static class MockRecordInterceptor
    implements RecordInterceptor {
        public static final List<Record> INTERCEPTED = new ArrayList<Record>();
        public static final Map<String, Object> CONFIGURED = new HashMap<String, Object>();
        public static final String REJECTED_SENSOR_NAME = "rejectedRecords";
        private Sensor rejectedMetric;

        public MockRecordInterceptor() {
            INTERCEPTED.clear();
            CONFIGURED.clear();
        }

        public void configure(Map<String, ?> configs) {
            CONFIGURED.putAll(configs);
        }

        public RecordInterceptor.RecordInterceptorResponse onAppend(TopicPartition tp, Record record) {
            INTERCEPTED.add(record);
            if (ByteBuffer.wrap("reject me".getBytes()).equals(record.value())) {
                MockRecordInterceptor.incrementSensor(this.rejectedMetric);
                return RecordInterceptor.RecordInterceptorResponse.REJECT;
            }
            return RecordInterceptor.RecordInterceptorResponse.ACCEPT;
        }

        public void setMetrics(Metrics metrics, TopicPartition topicPartition) {
            if (metrics.getSensor(REJECTED_SENSOR_NAME) == null) {
                this.rejectedMetric = metrics.sensor(REJECTED_SENSOR_NAME);
                this.rejectedMetric.add((CompoundStat)new Meter(new MetricName("rejected-rate", "group", "desc", Collections.emptyMap()), new MetricName("rejected-total", "group", "desc", Collections.emptyMap())));
            }
        }

        private static void incrementSensor(Sensor sensor) {
            if (sensor != null) {
                sensor.record();
            }
        }
    }
}

