/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.availability;

import io.confluent.kafka.availability.ThreadCountersManager;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;

public class FilesWrapper {
    public static byte[] readAllBytes(Path path) throws IOException {
        return ThreadCountersManager.wrapIOChecked(() -> Files.readAllBytes(path));
    }

    public static void delete(Path path) throws IOException {
        ThreadCountersManager.wrapIOChecked(() -> Files.delete(path));
    }

    public static Path move(Path source, Path target, CopyOption ... options) throws IOException {
        return ThreadCountersManager.wrapIOChecked(() -> Files.move(source, target, options));
    }

    public static InputStream newInputStream(Path path, OpenOption ... options) throws IOException {
        return ThreadCountersManager.wrapIOChecked(() -> Files.newInputStream(path, options));
    }

    public static boolean deleteIfExists(Path path) throws IOException {
        return ThreadCountersManager.wrapIOChecked(() -> Files.deleteIfExists(path));
    }

    public static boolean exists(Path path, LinkOption ... options) {
        return ThreadCountersManager.wrapIO(() -> Files.exists(path, options));
    }

    public static Path createTempFile(String prefix, String suffix, FileAttribute<?> ... attrs) throws IOException {
        return ThreadCountersManager.wrapIOChecked(() -> Files.createTempFile(prefix, suffix, attrs));
    }

    public static Path createTempFile(Path dir, String prefix, String suffix, FileAttribute<?> ... attrs) throws IOException {
        return ThreadCountersManager.wrapIOChecked(() -> Files.createTempFile(dir, prefix, suffix, attrs));
    }

    public static Path createDirectories(Path dir, FileAttribute<?> ... attrs) throws IOException {
        return ThreadCountersManager.wrapIOChecked(() -> Files.createDirectories(dir, attrs));
    }

    public static Path createFile(Path path, FileAttribute<?> ... attrs) throws IOException {
        return ThreadCountersManager.wrapIOChecked(() -> Files.createFile(path, attrs));
    }

    public static Path setLastModifiedTime(Path path, FileTime time) throws IOException {
        return ThreadCountersManager.wrapIOChecked(() -> Files.setLastModifiedTime(path, time));
    }

    public static Path copy(Path source, Path target, CopyOption ... options) throws IOException {
        return ThreadCountersManager.wrapIOChecked(() -> Files.copy(source, target, options));
    }

    public static DirectoryStream<Path> newDirectoryStream(Path dir) throws IOException {
        return ThreadCountersManager.wrapIOChecked(() -> Files.newDirectoryStream(dir));
    }

    public static Path walkFileTree(Path start, FileVisitor<? super Path> visitor) throws IOException {
        return ThreadCountersManager.wrapIOChecked(() -> Files.walkFileTree(start, visitor));
    }
}

