/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals.events;

import java.time.Duration;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.internals.events.ApplicationEvent;
import org.apache.kafka.common.TopicPartition;

public class OffsetFetchApplicationEvent
extends ApplicationEvent {
    public final CompletableFuture<Map<TopicPartition, OffsetAndMetadata>> future;
    public final Set<TopicPartition> partitions;

    public OffsetFetchApplicationEvent(Set<TopicPartition> partitions) {
        super(ApplicationEvent.Type.FETCH_COMMITTED_OFFSET);
        this.partitions = partitions;
        this.future = new CompletableFuture();
    }

    public Map<TopicPartition, OffsetAndMetadata> complete(Duration duration) throws ExecutionException, InterruptedException, TimeoutException {
        return this.future.get(duration.toMillis(), TimeUnit.MILLISECONDS);
    }
}

