/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class AlterBrokerReplicaExclusionsResponseData
implements ApiMessage {
    int throttleTimeMs;
    short errorCode;
    String errorMessage;
    boolean wasApplied;
    List<BrokerReplicaExclusionResponse> brokerExclusions;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The error code, or null if there was no error with the request as a whole."), new Field("error_message", Type.NULLABLE_STRING, "The error message, or null if there was no error with the request as a whole."), new Field("was_applied", Type.BOOLEAN, "Denotes whether the exclusion was applied. Because the request is atomic in its nature, a failure to apply at least one exclusion operation results in none being applied."), new Field("broker_exclusions", new ArrayOf(BrokerReplicaExclusionResponse.SCHEMA_0), "Response for the broker replica exclusion request."));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public AlterBrokerReplicaExclusionsResponseData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public AlterBrokerReplicaExclusionsResponseData() {
        this.throttleTimeMs = 0;
        this.errorCode = 0;
        this.errorMessage = "";
        this.wasApplied = false;
        this.brokerExclusions = new ArrayList<BrokerReplicaExclusionResponse>(0);
    }

    @Override
    public short apiKey() {
        return 10015;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public void read(Readable _readable, short _version, MessageContext _context) {
        this.throttleTimeMs = _readable.readInt();
        this.errorCode = _readable.readShort();
        short length = _readable.readShort();
        if (length < 0) {
            this.errorMessage = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field errorMessage had invalid length " + length);
            }
            this.errorMessage = _readable.readString(length);
        }
        this.wasApplied = _readable.readByte() != 0;
        int arrayLength = _readable.readInt();
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field brokerExclusions was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ArrayList<BrokerReplicaExclusionResponse> newCollection = new ArrayList<BrokerReplicaExclusionResponse>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new BrokerReplicaExclusionResponse(_readable, _version, _context));
        }
        this.brokerExclusions = newCollection;
        this._unknownTaggedFields = null;
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        Object _stringBytes;
        int _numTaggedFields = 0;
        _writable.writeInt(this.throttleTimeMs);
        _writable.writeShort(this.errorCode);
        if (this.errorMessage == null) {
            _writable.writeShort((short)-1);
        } else {
            _stringBytes = _cache.getSerializedValue(this.errorMessage);
            _writable.writeShort((short)((byte[])_stringBytes).length);
            _writable.writeByteArray((byte[])_stringBytes);
        }
        _writable.writeByte(this.wasApplied ? (byte)1 : 0);
        _writable.writeInt(this.brokerExclusions.size());
        _stringBytes = this.brokerExclusions.iterator();
        while (_stringBytes.hasNext()) {
            BrokerReplicaExclusionResponse brokerExclusionsElement = (BrokerReplicaExclusionResponse)_stringBytes.next();
            brokerExclusionsElement.write(_writable, _cache, _version, _context);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        _size.addBytes(2);
        if (this.errorMessage == null) {
            _size.addBytes(2);
        } else {
            byte[] _stringBytes = this.errorMessage.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'errorMessage' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.errorMessage, _stringBytes);
            _size.addBytes(_stringBytes.length + 2);
        }
        _size.addBytes(1);
        _size.addBytes(4);
        for (BrokerReplicaExclusionResponse brokerExclusionsElement : this.brokerExclusions) {
            brokerExclusionsElement.addSize(_size, _cache, _version, _context);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AlterBrokerReplicaExclusionsResponseData)) {
            return false;
        }
        AlterBrokerReplicaExclusionsResponseData other = (AlterBrokerReplicaExclusionsResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
            return false;
        }
        if (this.wasApplied != other.wasApplied) {
            return false;
        }
        if (this.brokerExclusions == null ? other.brokerExclusions != null : !this.brokerExclusions.equals(other.brokerExclusions)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
        hashCode = 31 * hashCode + (this.wasApplied ? 1231 : 1237);
        hashCode = 31 * hashCode + (this.brokerExclusions == null ? 0 : this.brokerExclusions.hashCode());
        return hashCode;
    }

    @Override
    public AlterBrokerReplicaExclusionsResponseData duplicate() {
        AlterBrokerReplicaExclusionsResponseData _duplicate = new AlterBrokerReplicaExclusionsResponseData();
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        _duplicate.errorCode = this.errorCode;
        _duplicate.errorMessage = this.errorMessage == null ? null : this.errorMessage;
        _duplicate.wasApplied = this.wasApplied;
        ArrayList<BrokerReplicaExclusionResponse> newBrokerExclusions = new ArrayList<BrokerReplicaExclusionResponse>(this.brokerExclusions.size());
        for (BrokerReplicaExclusionResponse _element : this.brokerExclusions) {
            newBrokerExclusions.add(_element.duplicate());
        }
        _duplicate.brokerExclusions = newBrokerExclusions;
        return _duplicate;
    }

    public String toString() {
        return "AlterBrokerReplicaExclusionsResponseData(throttleTimeMs=" + this.throttleTimeMs + ", errorCode=" + this.errorCode + ", errorMessage=" + (this.errorMessage == null ? "null" : "'" + this.errorMessage.toString() + "'") + ", wasApplied=" + (this.wasApplied ? "true" : "false") + ", brokerExclusions=" + MessageUtil.deepToString(this.brokerExclusions.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public short errorCode() {
        return this.errorCode;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public boolean wasApplied() {
        return this.wasApplied;
    }

    public List<BrokerReplicaExclusionResponse> brokerExclusions() {
        return this.brokerExclusions;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public AlterBrokerReplicaExclusionsResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public AlterBrokerReplicaExclusionsResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public AlterBrokerReplicaExclusionsResponseData setErrorMessage(String v) {
        this.errorMessage = v;
        return this;
    }

    public AlterBrokerReplicaExclusionsResponseData setWasApplied(boolean v) {
        this.wasApplied = v;
        return this;
    }

    public AlterBrokerReplicaExclusionsResponseData setBrokerExclusions(List<BrokerReplicaExclusionResponse> v) {
        this.brokerExclusions = v;
        return this;
    }

    public static class BrokerReplicaExclusionResponse
    implements Message {
        int brokerId;
        byte exclusionOperationCode;
        short exclusionErrorCode;
        String exclusionErrorMessage;
        String reason;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("broker_id", Type.INT32, "The Broker ID for which the replica exclusion was requested"), new Field("exclusion_operation_code", Type.INT8, "The exclusion operation (SET, DELETE) that was performed on the given broker."), new Field("exclusion_error_code", Type.INT16, "The error code, or null if there was no error with the exclusion for this broker. Note that an error here means that the whole atomic operation was aborted."), new Field("exclusion_error_message", Type.NULLABLE_STRING, "The error message, or null if there was no error with the exclusion for this broker."), new Field("reason", Type.STRING, "The user-provided reason for excluding the broker."));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public BrokerReplicaExclusionResponse(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public BrokerReplicaExclusionResponse() {
            this.brokerId = 0;
            this.exclusionOperationCode = 0;
            this.exclusionErrorCode = 0;
            this.exclusionErrorMessage = "";
            this.reason = "";
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of BrokerReplicaExclusionResponse");
            }
            this.brokerId = _readable.readInt();
            this.exclusionOperationCode = _readable.readByte();
            this.exclusionErrorCode = _readable.readShort();
            short length = _readable.readShort();
            if (length < 0) {
                this.exclusionErrorMessage = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field exclusionErrorMessage had invalid length " + length);
                }
                this.exclusionErrorMessage = _readable.readString(length);
            }
            length = _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field reason was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field reason had invalid length " + length);
            }
            this.reason = _readable.readString(length);
            this._unknownTaggedFields = null;
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            byte[] _stringBytes;
            int _numTaggedFields = 0;
            _writable.writeInt(this.brokerId);
            _writable.writeByte(this.exclusionOperationCode);
            _writable.writeShort(this.exclusionErrorCode);
            if (this.exclusionErrorMessage == null) {
                _writable.writeShort((short)-1);
            } else {
                _stringBytes = _cache.getSerializedValue(this.exclusionErrorMessage);
                _writable.writeShort((short)_stringBytes.length);
                _writable.writeByteArray(_stringBytes);
            }
            _stringBytes = _cache.getSerializedValue(this.reason);
            _writable.writeShort((short)_stringBytes.length);
            _writable.writeByteArray(_stringBytes);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            byte[] _stringBytes;
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of BrokerReplicaExclusionResponse");
            }
            _size.addBytes(4);
            _size.addBytes(1);
            _size.addBytes(2);
            if (this.exclusionErrorMessage == null) {
                _size.addBytes(2);
            } else {
                _stringBytes = this.exclusionErrorMessage.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'exclusionErrorMessage' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.exclusionErrorMessage, _stringBytes);
                _size.addBytes(_stringBytes.length + 2);
            }
            _stringBytes = this.reason.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'reason' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.reason, _stringBytes);
            _size.addBytes(_stringBytes.length + 2);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof BrokerReplicaExclusionResponse)) {
                return false;
            }
            BrokerReplicaExclusionResponse other = (BrokerReplicaExclusionResponse)obj;
            if (this.brokerId != other.brokerId) {
                return false;
            }
            if (this.exclusionOperationCode != other.exclusionOperationCode) {
                return false;
            }
            if (this.exclusionErrorCode != other.exclusionErrorCode) {
                return false;
            }
            if (this.exclusionErrorMessage == null ? other.exclusionErrorMessage != null : !this.exclusionErrorMessage.equals(other.exclusionErrorMessage)) {
                return false;
            }
            if (this.reason == null ? other.reason != null : !this.reason.equals(other.reason)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.brokerId;
            hashCode = 31 * hashCode + this.exclusionOperationCode;
            hashCode = 31 * hashCode + this.exclusionErrorCode;
            hashCode = 31 * hashCode + (this.exclusionErrorMessage == null ? 0 : this.exclusionErrorMessage.hashCode());
            hashCode = 31 * hashCode + (this.reason == null ? 0 : this.reason.hashCode());
            return hashCode;
        }

        @Override
        public BrokerReplicaExclusionResponse duplicate() {
            BrokerReplicaExclusionResponse _duplicate = new BrokerReplicaExclusionResponse();
            _duplicate.brokerId = this.brokerId;
            _duplicate.exclusionOperationCode = this.exclusionOperationCode;
            _duplicate.exclusionErrorCode = this.exclusionErrorCode;
            _duplicate.exclusionErrorMessage = this.exclusionErrorMessage == null ? null : this.exclusionErrorMessage;
            _duplicate.reason = this.reason;
            return _duplicate;
        }

        public String toString() {
            return "BrokerReplicaExclusionResponse(brokerId=" + this.brokerId + ", exclusionOperationCode=" + this.exclusionOperationCode + ", exclusionErrorCode=" + this.exclusionErrorCode + ", exclusionErrorMessage=" + (this.exclusionErrorMessage == null ? "null" : "'" + this.exclusionErrorMessage.toString() + "'") + ", reason=" + (this.reason == null ? "null" : "'" + this.reason.toString() + "'") + ")";
        }

        public int brokerId() {
            return this.brokerId;
        }

        public byte exclusionOperationCode() {
            return this.exclusionOperationCode;
        }

        public short exclusionErrorCode() {
            return this.exclusionErrorCode;
        }

        public String exclusionErrorMessage() {
            return this.exclusionErrorMessage;
        }

        public String reason() {
            return this.reason;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public BrokerReplicaExclusionResponse setBrokerId(int v) {
            this.brokerId = v;
            return this;
        }

        public BrokerReplicaExclusionResponse setExclusionOperationCode(byte v) {
            this.exclusionOperationCode = v;
            return this;
        }

        public BrokerReplicaExclusionResponse setExclusionErrorCode(short v) {
            this.exclusionErrorCode = v;
            return this;
        }

        public BrokerReplicaExclusionResponse setExclusionErrorMessage(String v) {
            this.exclusionErrorMessage = v;
            return this;
        }

        public BrokerReplicaExclusionResponse setReason(String v) {
            this.reason = v;
            return this;
        }
    }
}

