/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.ListClusterLinksResponseData;
import org.apache.kafka.common.protocol.MessageUtil;

public class ListClusterLinksResponseDataJsonConverter {
    public static ListClusterLinksResponseData read(JsonNode _node, short _version) {
        ListClusterLinksResponseData _object = new ListClusterLinksResponseData();
        JsonNode _throttleTimeMsNode = _node.get("throttleTimeMs");
        if (_throttleTimeMsNode == null) {
            throw new RuntimeException("ListClusterLinksResponseData: unable to locate field 'throttleTimeMs', which is mandatory in version " + _version);
        }
        _object.throttleTimeMs = MessageUtil.jsonNodeToInt(_throttleTimeMsNode, "ListClusterLinksResponseData");
        JsonNode _errorCodeNode = _node.get("errorCode");
        if (_errorCodeNode == null) {
            throw new RuntimeException("ListClusterLinksResponseData: unable to locate field 'errorCode', which is mandatory in version " + _version);
        }
        _object.errorCode = MessageUtil.jsonNodeToShort(_errorCodeNode, "ListClusterLinksResponseData");
        JsonNode _errorMessageNode = _node.get("errorMessage");
        if (_errorMessageNode == null) {
            throw new RuntimeException("ListClusterLinksResponseData: unable to locate field 'errorMessage', which is mandatory in version " + _version);
        }
        if (_errorMessageNode.isNull()) {
            _object.errorMessage = null;
        } else {
            if (!_errorMessageNode.isTextual()) {
                throw new RuntimeException("ListClusterLinksResponseData expected a string type, but got " + _node.getNodeType());
            }
            _object.errorMessage = _errorMessageNode.asText();
        }
        JsonNode _entriesNode = _node.get("entries");
        if (_entriesNode == null) {
            throw new RuntimeException("ListClusterLinksResponseData: unable to locate field 'entries', which is mandatory in version " + _version);
        }
        if (_entriesNode.isNull()) {
            _object.entries = null;
        } else {
            if (!_entriesNode.isArray()) {
                throw new RuntimeException("ListClusterLinksResponseData expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<ListClusterLinksResponseData.EntryData> _collection = new ArrayList<ListClusterLinksResponseData.EntryData>(_entriesNode.size());
            _object.entries = _collection;
            for (JsonNode _element : _entriesNode) {
                _collection.add(EntryDataJsonConverter.read(_element, _version));
            }
        }
        return _object;
    }

    public static JsonNode write(ListClusterLinksResponseData _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        _node.set("throttleTimeMs", (JsonNode)new IntNode(_object.throttleTimeMs));
        _node.set("errorCode", (JsonNode)new ShortNode(_object.errorCode));
        if (_object.errorMessage == null) {
            _node.set("errorMessage", (JsonNode)NullNode.instance);
        } else {
            _node.set("errorMessage", (JsonNode)new TextNode(_object.errorMessage));
        }
        if (_object.entries == null) {
            _node.set("entries", (JsonNode)NullNode.instance);
        } else {
            ArrayNode _entriesArray = new ArrayNode(JsonNodeFactory.instance);
            for (ListClusterLinksResponseData.EntryData _element : _object.entries) {
                _entriesArray.add(EntryDataJsonConverter.write(_element, _version, _serializeRecords));
            }
            _node.set("entries", (JsonNode)_entriesArray);
        }
        return _node;
    }

    public static JsonNode write(ListClusterLinksResponseData _object, short _version) {
        return ListClusterLinksResponseDataJsonConverter.write(_object, _version, true);
    }

    public static class EntryDataJsonConverter {
        public static ListClusterLinksResponseData.EntryData read(JsonNode _node, short _version) {
            ListClusterLinksResponseData.EntryData _object = new ListClusterLinksResponseData.EntryData();
            JsonNode _linkNameNode = _node.get("linkName");
            if (_linkNameNode == null) {
                throw new RuntimeException("EntryData: unable to locate field 'linkName', which is mandatory in version " + _version);
            }
            if (!_linkNameNode.isTextual()) {
                throw new RuntimeException("EntryData expected a string type, but got " + _node.getNodeType());
            }
            _object.linkName = _linkNameNode.asText();
            JsonNode _linkIdNode = _node.get("linkId");
            if (_linkIdNode == null) {
                throw new RuntimeException("EntryData: unable to locate field 'linkId', which is mandatory in version " + _version);
            }
            if (!_linkIdNode.isTextual()) {
                throw new RuntimeException("EntryData expected a JSON string type, but got " + _node.getNodeType());
            }
            _object.linkId = Uuid.fromString(_linkIdNode.asText());
            JsonNode _remoteClusterIdNode = _node.get("remoteClusterId");
            if (_remoteClusterIdNode == null) {
                throw new RuntimeException("EntryData: unable to locate field 'remoteClusterId', which is mandatory in version " + _version);
            }
            if (_remoteClusterIdNode.isNull()) {
                _object.remoteClusterId = null;
            } else {
                if (!_remoteClusterIdNode.isTextual()) {
                    throw new RuntimeException("EntryData expected a string type, but got " + _node.getNodeType());
                }
                _object.remoteClusterId = _remoteClusterIdNode.asText();
            }
            JsonNode _localClusterIdNode = _node.get("localClusterId");
            if (_localClusterIdNode == null) {
                if (_version >= 1) {
                    throw new RuntimeException("EntryData: unable to locate field 'localClusterId', which is mandatory in version " + _version);
                }
                _object.localClusterId = "";
            } else {
                if (!_localClusterIdNode.isTextual()) {
                    throw new RuntimeException("EntryData expected a string type, but got " + _node.getNodeType());
                }
                _object.localClusterId = _localClusterIdNode.asText();
            }
            JsonNode _topicsNode = _node.get("topics");
            if (_topicsNode == null) {
                throw new RuntimeException("EntryData: unable to locate field 'topics', which is mandatory in version " + _version);
            }
            if (_topicsNode.isNull()) {
                _object.topics = null;
            } else {
                if (!_topicsNode.isArray()) {
                    throw new RuntimeException("EntryData expected a JSON array, but got " + _node.getNodeType());
                }
                ArrayList<String> _collection = new ArrayList<String>(_topicsNode.size());
                _object.topics = _collection;
                for (JsonNode _element : _topicsNode) {
                    if (!_element.isTextual()) {
                        throw new RuntimeException("EntryData element expected a string type, but got " + _node.getNodeType());
                    }
                    _collection.add(_element.asText());
                }
            }
            JsonNode _availableNode = _node.get("available");
            if (_availableNode == null) {
                if (_version >= 2 && _version <= 4) {
                    throw new RuntimeException("EntryData: unable to locate field 'available', which is mandatory in version " + _version);
                }
                _object.available = false;
            } else {
                if (!_availableNode.isBoolean()) {
                    throw new RuntimeException("EntryData expected Boolean type, but got " + _node.getNodeType());
                }
                _object.available = _availableNode.asBoolean();
            }
            JsonNode _linkErrorCodeNode = _node.get("linkErrorCode");
            if (_linkErrorCodeNode == null) {
                if (_version >= 4) {
                    throw new RuntimeException("EntryData: unable to locate field 'linkErrorCode', which is mandatory in version " + _version);
                }
                _object.linkErrorCode = 0;
            } else {
                _object.linkErrorCode = MessageUtil.jsonNodeToShort(_linkErrorCodeNode, "EntryData");
            }
            JsonNode _linkErrorMessageNode = _node.get("linkErrorMessage");
            if (_linkErrorMessageNode == null) {
                if (_version >= 4) {
                    throw new RuntimeException("EntryData: unable to locate field 'linkErrorMessage', which is mandatory in version " + _version);
                }
                _object.linkErrorMessage = null;
            } else if (_linkErrorMessageNode.isNull()) {
                _object.linkErrorMessage = null;
            } else {
                if (!_linkErrorMessageNode.isTextual()) {
                    throw new RuntimeException("EntryData expected a string type, but got " + _node.getNodeType());
                }
                _object.linkErrorMessage = _linkErrorMessageNode.asText();
            }
            JsonNode _linkStateNode = _node.get("linkState");
            if (_linkStateNode == null) {
                if (_version >= 5) {
                    throw new RuntimeException("EntryData: unable to locate field 'linkState', which is mandatory in version " + _version);
                }
                _object.linkState = (short)-1;
            } else {
                _object.linkState = MessageUtil.jsonNodeToShort(_linkStateNode, "EntryData");
            }
            return _object;
        }

        public static JsonNode write(ListClusterLinksResponseData.EntryData _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("linkName", (JsonNode)new TextNode(_object.linkName));
            _node.set("linkId", (JsonNode)new TextNode(_object.linkId.toString()));
            if (_object.remoteClusterId == null) {
                _node.set("remoteClusterId", (JsonNode)NullNode.instance);
            } else {
                _node.set("remoteClusterId", (JsonNode)new TextNode(_object.remoteClusterId));
            }
            if (_version >= 1) {
                _node.set("localClusterId", (JsonNode)new TextNode(_object.localClusterId));
            }
            if (_object.topics == null) {
                _node.set("topics", (JsonNode)NullNode.instance);
            } else {
                ArrayNode _topicsArray = new ArrayNode(JsonNodeFactory.instance);
                for (String _element : _object.topics) {
                    _topicsArray.add((JsonNode)new TextNode(_element));
                }
                _node.set("topics", (JsonNode)_topicsArray);
            }
            if (_version >= 2 && _version <= 4) {
                _node.set("available", (JsonNode)BooleanNode.valueOf((boolean)_object.available));
            }
            if (_version >= 4) {
                _node.set("linkErrorCode", (JsonNode)new ShortNode(_object.linkErrorCode));
            }
            if (_version >= 4) {
                if (_object.linkErrorMessage == null) {
                    _node.set("linkErrorMessage", (JsonNode)NullNode.instance);
                } else {
                    _node.set("linkErrorMessage", (JsonNode)new TextNode(_object.linkErrorMessage));
                }
            }
            if (_version >= 5) {
                _node.set("linkState", (JsonNode)new ShortNode(_object.linkState));
            }
            return _node;
        }

        public static JsonNode write(ListClusterLinksResponseData.EntryData _object, short _version) {
            return EntryDataJsonConverter.write(_object, _version, true);
        }
    }
}

