/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class ReverseConnectionRequestData
implements ApiMessage {
    Uuid clusterLinkId;
    String sourceClusterId;
    String targetClusterId;
    int sourceBrokerId;
    String sourceHost;
    int sourcePort;
    int initiateRequestId;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema[] SCHEMAS;
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 1;

    public ReverseConnectionRequestData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public ReverseConnectionRequestData() {
        this.clusterLinkId = Uuid.ZERO_UUID;
        this.sourceClusterId = "";
        this.targetClusterId = "";
        this.sourceBrokerId = 0;
        this.sourceHost = "";
        this.sourcePort = 0;
        this.initiateRequestId = 0;
    }

    @Override
    public short apiKey() {
        return 10014;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 1;
    }

    @Override
    public void read(Readable _readable, short _version, MessageContext _context) {
        this.clusterLinkId = _readable.readUuid();
        int length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            throw new RuntimeException("non-nullable field sourceClusterId was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field sourceClusterId had invalid length " + length);
        }
        this.sourceClusterId = _readable.readString(length);
        length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            throw new RuntimeException("non-nullable field targetClusterId was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field targetClusterId had invalid length " + length);
        }
        this.targetClusterId = _readable.readString(length);
        this.sourceBrokerId = _readable.readInt();
        length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            throw new RuntimeException("non-nullable field sourceHost was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field sourceHost had invalid length " + length);
        }
        this.sourceHost = _readable.readString(length);
        this.sourcePort = _readable.readInt();
        this.initiateRequestId = _readable.readInt();
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _writable.writeUuid(this.clusterLinkId);
        byte[] _stringBytes = _cache.getSerializedValue(this.sourceClusterId);
        _writable.writeUnsignedVarint(_stringBytes.length + 1);
        _writable.writeByteArray(_stringBytes);
        _stringBytes = _cache.getSerializedValue(this.targetClusterId);
        _writable.writeUnsignedVarint(_stringBytes.length + 1);
        _writable.writeByteArray(_stringBytes);
        _writable.writeInt(this.sourceBrokerId);
        _stringBytes = _cache.getSerializedValue(this.sourceHost);
        _writable.writeUnsignedVarint(_stringBytes.length + 1);
        _writable.writeByteArray(_stringBytes);
        _writable.writeInt(this.sourcePort);
        _writable.writeInt(this.initiateRequestId);
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _size.addBytes(16);
        byte[] _stringBytes = this.sourceClusterId.getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'sourceClusterId' field is too long to be serialized");
        }
        _cache.cacheSerializedValue(this.sourceClusterId, _stringBytes);
        _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        _stringBytes = this.targetClusterId.getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'targetClusterId' field is too long to be serialized");
        }
        _cache.cacheSerializedValue(this.targetClusterId, _stringBytes);
        _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        _size.addBytes(4);
        _stringBytes = this.sourceHost.getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'sourceHost' field is too long to be serialized");
        }
        _cache.cacheSerializedValue(this.sourceHost, _stringBytes);
        _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        _size.addBytes(4);
        _size.addBytes(4);
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ReverseConnectionRequestData)) {
            return false;
        }
        ReverseConnectionRequestData other = (ReverseConnectionRequestData)obj;
        if (!this.clusterLinkId.equals(other.clusterLinkId)) {
            return false;
        }
        if (this.sourceClusterId == null ? other.sourceClusterId != null : !this.sourceClusterId.equals(other.sourceClusterId)) {
            return false;
        }
        if (this.targetClusterId == null ? other.targetClusterId != null : !this.targetClusterId.equals(other.targetClusterId)) {
            return false;
        }
        if (this.sourceBrokerId != other.sourceBrokerId) {
            return false;
        }
        if (this.sourceHost == null ? other.sourceHost != null : !this.sourceHost.equals(other.sourceHost)) {
            return false;
        }
        if (this.sourcePort != other.sourcePort) {
            return false;
        }
        if (this.initiateRequestId != other.initiateRequestId) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.clusterLinkId.hashCode();
        hashCode = 31 * hashCode + (this.sourceClusterId == null ? 0 : this.sourceClusterId.hashCode());
        hashCode = 31 * hashCode + (this.targetClusterId == null ? 0 : this.targetClusterId.hashCode());
        hashCode = 31 * hashCode + this.sourceBrokerId;
        hashCode = 31 * hashCode + (this.sourceHost == null ? 0 : this.sourceHost.hashCode());
        hashCode = 31 * hashCode + this.sourcePort;
        hashCode = 31 * hashCode + this.initiateRequestId;
        return hashCode;
    }

    @Override
    public ReverseConnectionRequestData duplicate() {
        ReverseConnectionRequestData _duplicate = new ReverseConnectionRequestData();
        _duplicate.clusterLinkId = this.clusterLinkId;
        _duplicate.sourceClusterId = this.sourceClusterId;
        _duplicate.targetClusterId = this.targetClusterId;
        _duplicate.sourceBrokerId = this.sourceBrokerId;
        _duplicate.sourceHost = this.sourceHost;
        _duplicate.sourcePort = this.sourcePort;
        _duplicate.initiateRequestId = this.initiateRequestId;
        return _duplicate;
    }

    public String toString() {
        return "ReverseConnectionRequestData(clusterLinkId=" + this.clusterLinkId.toString() + ", sourceClusterId=" + (this.sourceClusterId == null ? "null" : "'" + this.sourceClusterId.toString() + "'") + ", targetClusterId=" + (this.targetClusterId == null ? "null" : "'" + this.targetClusterId.toString() + "'") + ", sourceBrokerId=" + this.sourceBrokerId + ", sourceHost=" + (this.sourceHost == null ? "null" : "'" + this.sourceHost.toString() + "'") + ", sourcePort=" + this.sourcePort + ", initiateRequestId=" + this.initiateRequestId + ")";
    }

    public Uuid clusterLinkId() {
        return this.clusterLinkId;
    }

    public String sourceClusterId() {
        return this.sourceClusterId;
    }

    public String targetClusterId() {
        return this.targetClusterId;
    }

    public int sourceBrokerId() {
        return this.sourceBrokerId;
    }

    public String sourceHost() {
        return this.sourceHost;
    }

    public int sourcePort() {
        return this.sourcePort;
    }

    public int initiateRequestId() {
        return this.initiateRequestId;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public ReverseConnectionRequestData setClusterLinkId(Uuid v) {
        this.clusterLinkId = v;
        return this;
    }

    public ReverseConnectionRequestData setSourceClusterId(String v) {
        this.sourceClusterId = v;
        return this;
    }

    public ReverseConnectionRequestData setTargetClusterId(String v) {
        this.targetClusterId = v;
        return this;
    }

    public ReverseConnectionRequestData setSourceBrokerId(int v) {
        this.sourceBrokerId = v;
        return this;
    }

    public ReverseConnectionRequestData setSourceHost(String v) {
        this.sourceHost = v;
        return this;
    }

    public ReverseConnectionRequestData setSourcePort(int v) {
        this.sourcePort = v;
        return this;
    }

    public ReverseConnectionRequestData setInitiateRequestId(int v) {
        this.initiateRequestId = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field("cluster_link_id", Type.UUID, "Cluster link ID to which this connection is assigned."), new Field("source_cluster_id", Type.COMPACT_STRING, "The cluster ID of the requesting source broker from which the connection originated."), new Field("target_cluster_id", Type.COMPACT_STRING, "The cluster ID of the target broker."), new Field("source_broker_id", Type.INT32, "The broker ID making the request."), new Field("source_host", Type.COMPACT_STRING, "The hostname of the broker making the request."), new Field("source_port", Type.INT32, "The port of the broker making the request."), new Field("initiate_request_id", Type.INT32, "Request id from InitiateReverseConnection request sent by target broker or -1 if this is a persistent connection from source."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
    }
}

