/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Function;
import org.apache.kafka.common.network.CCloudTrafficType;
import org.apache.kafka.common.network.ProxyTlvValidator;

public class ProxyTlvType {
    public static final int PP2_TYPE_CFLT = 239;
    public static final int PP2_SUBTYPE_CFLT_LKC_ID = 1;
    public static final int PP2_SUBTYPE_CFLT_CCLOUD_TRAFFIC_TYPE = 2;
    private static final Set<ProxyTlvType> REGISTERED_TYPES = new HashSet<ProxyTlvType>();
    public static final ProxyTlvType LKC_ID = new Builder(239).subtype(1).validator(bytes -> {
        String lkcId = ProxyTlvType.lkcString(bytes);
        if (lkcId.trim().isEmpty()) {
            throw new IOException("The LKC ID in the TLV is missing");
        }
        if (!lkcId.startsWith("lkc-")) {
            throw new IOException("The LKC ID in the TLV (" + lkcId + ") is malformed");
        }
    }).valueComputer(ProxyTlvType::lkcString).build();
    public static final ProxyTlvType CCLOUD_TRAFFIC_TYPE = new Builder(239).subtype(2).validator(bytes -> CCloudTrafficType.valueOf(bytes)).valueComputer(CCloudTrafficType::valueOf).build();
    public final int type;
    public final Optional<Integer> subtype;
    public final Optional<ProxyTlvValidator> validator;
    private final Optional<Function<byte[], Object>> valueComputer;

    public static String lkcString(byte[] bytes) {
        return new String(Arrays.copyOfRange(bytes, 1, bytes.length), StandardCharsets.UTF_8);
    }

    public ProxyTlvType(int type) {
        this(type, Optional.empty(), Optional.empty(), Optional.empty());
    }

    private ProxyTlvType(int type, Optional<Integer> subtype, Optional<ProxyTlvValidator> validator, Optional<Function<byte[], Object>> valueComputer) {
        this.type = type;
        this.subtype = subtype;
        this.validator = validator;
        this.valueComputer = valueComputer;
    }

    public static Set<ProxyTlvType> registeredTypes() {
        return Collections.unmodifiableSet(REGISTERED_TYPES);
    }

    public int type() {
        return this.type;
    }

    public Optional<Integer> subtype() {
        return this.subtype;
    }

    public Optional<ProxyTlvValidator> validator() {
        return this.validator;
    }

    public Object computeValue(byte[] value) {
        return this.valueComputer.map(objectFunction -> objectFunction.apply(value)).orElse(null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProxyTlvType that = (ProxyTlvType)o;
        return this.type == that.type && this.subtype.equals(that.subtype);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.subtype);
    }

    public String toString() {
        return new StringJoiner(", ", ProxyTlvType.class.getSimpleName() + "[", "]").add("type=" + this.type).add("subtype=" + this.subtype).toString();
    }

    static class Builder {
        final int type;
        Optional<Integer> subtype = Optional.empty();
        Optional<ProxyTlvValidator> validator = Optional.empty();
        Optional<Function<byte[], Object>> valueComputer = Optional.empty();

        Builder(int type) {
            this.type = type;
        }

        Builder subtype(int subtype) {
            this.subtype = Optional.of(subtype);
            return this;
        }

        Builder validator(ProxyTlvValidator validator) {
            this.validator = Optional.of(validator);
            return this;
        }

        Builder valueComputer(Function<byte[], Object> valueComputer) {
            this.valueComputer = Optional.of(valueComputer);
            return this;
        }

        ProxyTlvType build() {
            ProxyTlvType ptt = new ProxyTlvType(this.type, this.subtype, this.validator, this.valueComputer);
            REGISTERED_TYPES.add(ptt);
            return ptt;
        }
    }
}

