/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.authenticator;

import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.kafka.common.security.authenticator.AbstractLogin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLogin
extends AbstractLogin {
    private static final Logger log = LoggerFactory.getLogger(DefaultLogin.class);

    @Override
    public void relogin() throws LoginException {
        log.debug("Re-login for updating credential");
        LoginContext loginContext = this.loginContext();
        if (!loginContext.getSubject().getPrivateCredentials().isEmpty()) {
            log.debug("Log out since subject contains credentials");
            loginContext.logout();
        }
        log.debug("Login again");
        loginContext.login();
    }

    @Override
    public String serviceName() {
        return "kafka";
    }

    @Override
    public void close() {
    }
}

