/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.util.Objects;
import java.util.function.Supplier;

public final class Lazy<T> {
    private volatile T value;

    public T getOrCompute(Supplier<T> supplier) {
        T result = this.value;
        return result == null ? this.maybeCompute(supplier) : result;
    }

    private synchronized T maybeCompute(Supplier<T> supplier) {
        if (this.value == null) {
            this.value = Objects.requireNonNull(supplier.get());
        }
        return this.value;
    }

    public String toString() {
        return "Lazy{value=" + this.value + '}';
    }
}

