/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.security.Security;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.config.SecurityConfig;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProviderCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecurityConfig.class);
    private static final Map<String, ResourceType> NAME_TO_RESOURCE_TYPES = new HashMap<String, ResourceType>(ResourceType.values().length);
    private static final Map<String, PatternType> NAME_TO_PATTERN_TYPES = new HashMap<String, PatternType>(PatternType.values().length);
    private static final Map<String, AclOperation> NAME_TO_OPERATIONS = new HashMap<String, AclOperation>(AclOperation.values().length);
    private static final Map<String, AclPermissionType> NAME_TO_PERMISSION_TYPES = new HashMap<String, AclPermissionType>(AclPermissionType.values().length);

    public static KafkaPrincipal parseKafkaPrincipal(String str) {
        if (str == null || str.isEmpty()) {
            throw new IllegalArgumentException("expected a string in format principalType:principalName but got " + str);
        }
        String[] split = str.split(":", 2);
        if (split.length != 2) {
            throw new IllegalArgumentException("expected a string in format principalType:principalName but got " + str);
        }
        return new KafkaPrincipal(split[0], split[1]);
    }

    public static void addConfiguredSecurityProviders(Map<String, ?> configs) {
        String securityProviderClassesStr = (String)configs.get("security.providers");
        if (securityProviderClassesStr == null || securityProviderClassesStr.equals("")) {
            return;
        }
        try {
            String[] securityProviderClasses = securityProviderClassesStr.replaceAll("\\s+", "").split(",");
            for (int index = 0; index < securityProviderClasses.length; ++index) {
                SecurityProviderCreator securityProviderCreator = (SecurityProviderCreator)Class.forName(securityProviderClasses[index]).getConstructor(new Class[0]).newInstance(new Object[0]);
                securityProviderCreator.configure(configs);
                Security.insertProviderAt(securityProviderCreator.getProvider(), index + 1);
            }
        }
        catch (ClassCastException e) {
            LOGGER.error("Creators provided through security.providers are expected to be sub-classes of SecurityProviderCreator");
        }
        catch (ClassNotFoundException cnfe) {
            LOGGER.error("Unrecognized security provider creator class", (Throwable)cnfe);
        }
        catch (ReflectiveOperationException e) {
            LOGGER.error("Unexpected implementation of security provider creator class", (Throwable)e);
        }
    }

    public static ResourceType resourceType(String name) {
        return SecurityUtils.valueFromMap(NAME_TO_RESOURCE_TYPES, name, ResourceType.UNKNOWN);
    }

    public static PatternType patternType(String name) {
        return SecurityUtils.valueFromMap(NAME_TO_PATTERN_TYPES, name, PatternType.UNKNOWN);
    }

    public static AclOperation operation(String name) {
        return SecurityUtils.valueFromMap(NAME_TO_OPERATIONS, name, AclOperation.UNKNOWN);
    }

    public static AclPermissionType permissionType(String name) {
        return SecurityUtils.valueFromMap(NAME_TO_PERMISSION_TYPES, name, AclPermissionType.UNKNOWN);
    }

    private static <T> T valueFromMap(Map<String, T> map, String key, T unknown) {
        T value = map.get(key);
        if (value == null) {
            value = map.get(key.toUpperCase(Locale.ROOT));
        }
        return value == null ? unknown : value;
    }

    public static String resourceTypeName(ResourceType resourceType) {
        return SecurityUtils.toPascalCase(resourceType.name());
    }

    public static String operationName(AclOperation operation) {
        return SecurityUtils.toPascalCase(operation.name());
    }

    public static String permissionTypeName(AclPermissionType permissionType) {
        return SecurityUtils.toPascalCase(permissionType.name());
    }

    public static String toPascalCase(String name) {
        StringBuilder builder = new StringBuilder();
        boolean capitalizeNext = true;
        for (char c : name.toCharArray()) {
            if (c == '_') {
                capitalizeNext = true;
                continue;
            }
            if (capitalizeNext) {
                builder.append(Character.toUpperCase(c));
                capitalizeNext = false;
                continue;
            }
            builder.append(Character.toLowerCase(c));
        }
        return builder.toString();
    }

    public static void authorizeByResourceTypeCheckArgs(AclOperation op, ResourceType type) {
        if (type == ResourceType.ANY) {
            throw new IllegalArgumentException("Must specify a non-filter resource type for authorizeByResourceType");
        }
        if (type == ResourceType.UNKNOWN) {
            throw new IllegalArgumentException("Unknown resource type");
        }
        if (op == AclOperation.ANY) {
            throw new IllegalArgumentException("Must specify a non-filter operation type for authorizeByResourceType");
        }
        if (op == AclOperation.UNKNOWN) {
            throw new IllegalArgumentException("Unknown operation type");
        }
    }

    public static boolean denyAll(ResourcePattern pattern) {
        return pattern.patternType() == PatternType.LITERAL && pattern.name().equals("*");
    }

    public static String clusterLinkDescription(Collection<Uuid> linkIds) {
        StringBuilder builder = new StringBuilder();
        if (!linkIds.isEmpty()) {
            builder.append(" (managed by ");
            int index = 0;
            for (Uuid linkId : linkIds) {
                if (index++ != 0) {
                    builder.append(", ");
                }
                builder.append(Uuid.ZERO_UUID.equals(linkId) ? "LocalCluster" : "ClusterLinkId:" + linkId);
            }
            builder.append(")");
        }
        return builder.toString();
    }

    public static AccessControlEntry aceWithClusterLinkIds(AccessControlEntry ace, Collection<Uuid> linkIds) {
        return new AccessControlEntry(ace.principal(), ace.host(), ace.operation(), ace.permissionType(), linkIds);
    }

    public static AccessControlEntry aceWithoutLinkId(AccessControlEntry ace) {
        return new AccessControlEntry(ace.principal(), ace.host(), ace.operation(), ace.permissionType());
    }

    public static AclBinding aclWithClusterLinkIds(AclBinding acl, Collection<Uuid> linkIds) {
        return new AclBinding(acl.pattern(), SecurityUtils.aceWithClusterLinkIds(acl.entry(), linkIds));
    }

    public static AccessControlEntryFilter aceFilterWithClusterLinkIds(AccessControlEntryFilter ace, Collection<Uuid> linkIds) {
        return new AccessControlEntryFilter(ace.principal(), ace.host(), ace.operation(), ace.permissionType(), linkIds);
    }

    public static AclBindingFilter aclFilterWithClusterLinkIds(AclBindingFilter filter, Collection<Uuid> linkIds) {
        AccessControlEntryFilter entryFilter = filter.entryFilter();
        return new AclBindingFilter(filter.patternFilter(), new AccessControlEntryFilter(entryFilter.principal(), entryFilter.host(), entryFilter.operation(), entryFilter.permissionType(), linkIds));
    }

    static {
        for (ResourceType resourceType : ResourceType.values()) {
            String resourceTypeName = SecurityUtils.toPascalCase(resourceType.name());
            NAME_TO_RESOURCE_TYPES.put(resourceTypeName, resourceType);
            NAME_TO_RESOURCE_TYPES.put(resourceTypeName.toUpperCase(Locale.ROOT), resourceType);
        }
        for (Enum enum_ : PatternType.values()) {
            String patternTypeName = SecurityUtils.toPascalCase(enum_.name());
            NAME_TO_PATTERN_TYPES.put(patternTypeName, (PatternType)enum_);
            NAME_TO_PATTERN_TYPES.put(patternTypeName.toUpperCase(Locale.ROOT), (PatternType)enum_);
        }
        for (Enum enum_ : AclOperation.values()) {
            String operationName = SecurityUtils.toPascalCase(enum_.name());
            NAME_TO_OPERATIONS.put(operationName, (AclOperation)enum_);
            NAME_TO_OPERATIONS.put(operationName.toUpperCase(Locale.ROOT), (AclOperation)enum_);
        }
        for (Enum enum_ : AclPermissionType.values()) {
            String permissionName = SecurityUtils.toPascalCase(enum_.name());
            NAME_TO_PERMISSION_TYPES.put(permissionName, (AclPermissionType)enum_);
            NAME_TO_PERMISSION_TYPES.put(permissionName.toUpperCase(Locale.ROOT), (AclPermissionType)enum_);
        }
    }
}

