/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant;

import java.net.InetAddress;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class InetAddressToTenantContext {
    private ConcurrentMap<InetAddress, String> inetAddressToTenant = new ConcurrentHashMap<InetAddress, String>();
    private ConcurrentMap<InetAddress, String> inetAddressToAPIKey = new ConcurrentHashMap<InetAddress, String>();
    private boolean trackInetAddressToTenantEnabled;
    private boolean trackInetAddressToAPIKeyEnabled;

    public InetAddressToTenantContext(boolean trackInetAddressToTenant, boolean trackInetAddressToAPIKey) {
        this.trackInetAddressToTenantEnabled = trackInetAddressToTenant;
        this.trackInetAddressToAPIKeyEnabled = trackInetAddressToAPIKey;
    }

    public InetAddressToTenantContext() {
        this(false, false);
    }

    public boolean isTrackInetAddressToTenantEnabled() {
        return this.trackInetAddressToTenantEnabled;
    }

    public void setTrackInetAddressToTenantEnabled(boolean trackInetAddressToTenantEnabled) {
        this.trackInetAddressToTenantEnabled = trackInetAddressToTenantEnabled;
    }

    public boolean isTrackInetAddressToAPIKeyEnabled() {
        return this.trackInetAddressToAPIKeyEnabled;
    }

    public void setTrackInetAddressToAPIKeyEnabled(boolean trackInetAddressToAPIKeyEnabled) {
        this.trackInetAddressToAPIKeyEnabled = trackInetAddressToAPIKeyEnabled;
    }

    public ConcurrentMap<InetAddress, String> getInetAddressToTenant() {
        return this.inetAddressToTenant;
    }

    public ConcurrentMap<InetAddress, String> getInetAddressToAPIKey() {
        return this.inetAddressToAPIKey;
    }

    public void trackAPIKeyByInetAddress(InetAddress inetAddress, String apiKey) {
        this.inetAddressToAPIKey.put(inetAddress, apiKey);
    }

    public void trackTenantIdByInetAddress(InetAddress inetAddress, String tenantId) {
        this.inetAddressToTenant.put(inetAddress, tenantId);
    }
}

