/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.AddPartitionsToTxnRequestData;
import org.apache.kafka.common.message.AddPartitionsToTxnResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AddPartitionsToTxnResponse;

public class AddPartitionsToTxnRequest
extends AbstractRequest {
    private final AddPartitionsToTxnRequestData data;

    public AddPartitionsToTxnRequest(AddPartitionsToTxnRequestData data, short version) {
        super(ApiKeys.ADD_PARTITIONS_TO_TXN, version);
        this.data = data;
    }

    @Override
    public AddPartitionsToTxnRequestData data() {
        return this.data;
    }

    @Override
    public AddPartitionsToTxnResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        Errors error = Errors.forException(e);
        AddPartitionsToTxnResponseData response = new AddPartitionsToTxnResponseData();
        if (this.version() < 4) {
            response.setResultsByTopicV3AndBelow(this.errorResponseForTopics(this.data.v3AndBelowTopics(), error));
        } else {
            response.setErrorCode(error.code());
        }
        response.setThrottleTimeMs(throttleTimeMs);
        return new AddPartitionsToTxnResponse(response);
    }

    public static List<TopicPartition> getPartitions(AddPartitionsToTxnRequestData.AddPartitionsToTxnTopicCollection topics) {
        ArrayList<TopicPartition> partitions = new ArrayList<TopicPartition>();
        for (AddPartitionsToTxnRequestData.AddPartitionsToTxnTopic topicCollection : topics) {
            for (Integer partition : topicCollection.partitions()) {
                partitions.add(new TopicPartition(topicCollection.name(), partition));
            }
        }
        return partitions;
    }

    public Map<String, List<TopicPartition>> partitionsByTransaction() {
        HashMap<String, List<TopicPartition>> partitionsByTransaction = new HashMap<String, List<TopicPartition>>();
        for (AddPartitionsToTxnRequestData.AddPartitionsToTxnTransaction transaction : this.data.transactions()) {
            List<TopicPartition> partitions = AddPartitionsToTxnRequest.getPartitions(transaction.topics());
            partitionsByTransaction.put(transaction.transactionalId(), partitions);
        }
        return partitionsByTransaction;
    }

    public AddPartitionsToTxnRequest normalizeRequest() {
        return new AddPartitionsToTxnRequest(new AddPartitionsToTxnRequestData().setTransactions(this.singletonTransaction()), this.version());
    }

    private AddPartitionsToTxnRequestData.AddPartitionsToTxnTransactionCollection singletonTransaction() {
        AddPartitionsToTxnRequestData.AddPartitionsToTxnTransactionCollection singleTxn = new AddPartitionsToTxnRequestData.AddPartitionsToTxnTransactionCollection();
        singleTxn.add(new AddPartitionsToTxnRequestData.AddPartitionsToTxnTransaction().setTransactionalId(this.data.v3AndBelowTransactionalId()).setProducerId(this.data.v3AndBelowProducerId()).setProducerEpoch(this.data.v3AndBelowProducerEpoch()).setTopics(this.data.v3AndBelowTopics()));
        return singleTxn;
    }

    public AddPartitionsToTxnResponseData.AddPartitionsToTxnResult errorResponseForTransaction(String transactionalId, Errors e) {
        AddPartitionsToTxnResponseData.AddPartitionsToTxnResult txnResult = new AddPartitionsToTxnResponseData.AddPartitionsToTxnResult().setTransactionalId(transactionalId);
        AddPartitionsToTxnResponseData.AddPartitionsToTxnTopicResultCollection topicResults = this.errorResponseForTopics(this.data.transactions().find(transactionalId).topics(), e);
        txnResult.setTopicResults(topicResults);
        return txnResult;
    }

    private AddPartitionsToTxnResponseData.AddPartitionsToTxnTopicResultCollection errorResponseForTopics(AddPartitionsToTxnRequestData.AddPartitionsToTxnTopicCollection topics, Errors e) {
        AddPartitionsToTxnResponseData.AddPartitionsToTxnTopicResultCollection topicResults = new AddPartitionsToTxnResponseData.AddPartitionsToTxnTopicResultCollection();
        for (AddPartitionsToTxnRequestData.AddPartitionsToTxnTopic topic : topics) {
            AddPartitionsToTxnResponseData.AddPartitionsToTxnTopicResult topicResult = new AddPartitionsToTxnResponseData.AddPartitionsToTxnTopicResult().setName(topic.name());
            AddPartitionsToTxnResponseData.AddPartitionsToTxnPartitionResultCollection partitionResult = new AddPartitionsToTxnResponseData.AddPartitionsToTxnPartitionResultCollection();
            for (Integer partition : topic.partitions()) {
                partitionResult.add(new AddPartitionsToTxnResponseData.AddPartitionsToTxnPartitionResult().setPartitionIndex(partition).setPartitionErrorCode(e.code()));
            }
            topicResult.setResultsByPartition(partitionResult);
            topicResults.add(topicResult);
        }
        return topicResults;
    }

    public static AddPartitionsToTxnRequest parse(ByteBuffer buffer, short version, MessageContext context) {
        return new AddPartitionsToTxnRequest(new AddPartitionsToTxnRequestData(new ByteBufferAccessor(buffer), version, context), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<AddPartitionsToTxnRequest> {
        public final AddPartitionsToTxnRequestData data;

        public static Builder forClient(String transactionalId, long producerId, short producerEpoch, List<TopicPartition> partitions) {
            AddPartitionsToTxnRequestData.AddPartitionsToTxnTopicCollection topics = Builder.buildTxnTopicCollection(partitions);
            return new Builder(ApiKeys.ADD_PARTITIONS_TO_TXN.oldestVersion(), 3, new AddPartitionsToTxnRequestData().setV3AndBelowTransactionalId(transactionalId).setV3AndBelowProducerId(producerId).setV3AndBelowProducerEpoch(producerEpoch).setV3AndBelowTopics(topics));
        }

        public static Builder forBroker(AddPartitionsToTxnRequestData.AddPartitionsToTxnTransactionCollection transactions) {
            return new Builder(4, ApiKeys.ADD_PARTITIONS_TO_TXN.latestVersion(), new AddPartitionsToTxnRequestData().setTransactions(transactions));
        }

        private Builder(short minVersion, short maxVersion, AddPartitionsToTxnRequestData data) {
            super(ApiKeys.ADD_PARTITIONS_TO_TXN, minVersion, maxVersion);
            this.data = data;
        }

        private static AddPartitionsToTxnRequestData.AddPartitionsToTxnTopicCollection buildTxnTopicCollection(List<TopicPartition> partitions) {
            HashMap<String, List> partitionMap = new HashMap<String, List>();
            for (TopicPartition topicPartition : partitions) {
                String topicName = topicPartition.topic();
                partitionMap.compute(topicName, (key, subPartitions) -> {
                    if (subPartitions == null) {
                        subPartitions = new ArrayList<Integer>();
                    }
                    subPartitions.add(topicPartition.partition());
                    return subPartitions;
                });
            }
            AddPartitionsToTxnRequestData.AddPartitionsToTxnTopicCollection topics = new AddPartitionsToTxnRequestData.AddPartitionsToTxnTopicCollection();
            for (Map.Entry partitionEntry : partitionMap.entrySet()) {
                topics.add(new AddPartitionsToTxnRequestData.AddPartitionsToTxnTopic().setName((String)partitionEntry.getKey()).setPartitions((List)partitionEntry.getValue()));
            }
            return topics;
        }

        @Override
        public AddPartitionsToTxnRequest build(short version) {
            return new AddPartitionsToTxnRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

