/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.availability;

import io.confluent.kafka.availability.ThreadCountersManager;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class FileChannelWrapper {
    public static FileChannel open(Path path, OpenOption ... options) throws IOException {
        return ThreadCountersManager.wrapIOChecked(() -> FileChannel.open(path, options));
    }

    public static void force(FileChannel fileChannel, boolean force) throws IOException {
        ThreadCountersManager.wrapIOChecked(() -> fileChannel.force(force));
    }

    public static void truncate(FileChannel fileChannel, long size) throws IOException {
        ThreadCountersManager.wrapIOChecked(() -> fileChannel.truncate(size));
    }

    public static void close(FileChannel fileChannel) throws IOException {
        ThreadCountersManager.wrapIOChecked(fileChannel::close);
    }

    public static long write(FileChannel channel, ByteBuffer sourceBuffer, long filePosition) throws IOException {
        return ThreadCountersManager.wrapIOChecked(() -> channel.write(sourceBuffer, filePosition)).intValue();
    }

    public static int write(FileChannel channel, ByteBuffer src) throws IOException {
        return ThreadCountersManager.wrapIOChecked(() -> channel.write(src));
    }

    public static long size(FileChannel channel) throws IOException {
        return ThreadCountersManager.wrapIOChecked(channel::size);
    }

    public static long transferTo(FileChannel channel, long position, long count, WritableByteChannel target) throws IOException {
        return ThreadCountersManager.wrapIOChecked(() -> channel.transferTo(position, count, target));
    }
}

