/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant;

import io.confluent.kafka.multitenant.TenantMetadata;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.common.security.auth.ConfluentPrincipal;
import org.apache.kafka.common.security.auth.IdentityMetadata;
import org.apache.kafka.common.security.auth.KafkaPrincipal;

public class MultiTenantPrincipal
extends ConfluentPrincipal {
    public static final String TENANT_USER_TYPE = "TenantUser";
    public static final String WILDCARD_PRINCIPAL_NAME = "*";
    public static final String TENANT_WILDCARD_USER_TYPE = "TenantUser*";
    public static final String DELIMITER = "_";
    public static final String USERV2 = "UserV2";
    public static final KafkaPrincipal WILDCARD_USERV2_PRINCIPAL = new KafkaPrincipal("UserV2", "*");
    public static final String TENANT_USERV2_TYPE = "TenantUserV2";
    public static final String POOL_ID_PREFIX = "pool";
    public static final String GROUP_PREFIX = "group";
    public static final String SPIFFE_ID_PREFIX = "spiffe";
    public static final String REGEX_INTEGER_ID_PRINCIPAL = "[0-9]+";
    public static final String TENANT_WILDCARD_USERV2_TYPE = "TenantUserV2*";
    private final String user;
    private final TenantMetadata tenantMetadata;

    public MultiTenantPrincipal(String user, TenantMetadata tenantMetadata) {
        this(user, user, tenantMetadata);
    }

    public MultiTenantPrincipal(String user, String saslAuthenticationId, TenantMetadata tenantMetadata) {
        this(user, saslAuthenticationId, tenantMetadata, null);
    }

    public MultiTenantPrincipal(String user, TenantMetadata tenantMetadata, IdentityMetadata identityMetadata) {
        this(user, user, tenantMetadata, identityMetadata);
    }

    public MultiTenantPrincipal(String user, String saslAuthenticationId, TenantMetadata tenantMetadata, IdentityMetadata identityMetadata) {
        this(user, saslAuthenticationId, Optional.empty(), tenantMetadata, identityMetadata);
    }

    public MultiTenantPrincipal(String user, String saslAuthenticationId, Optional<String> networkId, TenantMetadata tenantMetadata, IdentityMetadata identityMetadata) {
        this(user, saslAuthenticationId, networkId, tenantMetadata, identityMetadata, tenantMetadata.userResourceId != null ? Collections.singletonList(tenantMetadata.userResourceId) : Collections.singletonList(user));
    }

    public MultiTenantPrincipal(String user, String saslAuthenticationId, Optional<String> networkId, TenantMetadata tenantMetadata, IdentityMetadata identityMetadata, List<String> authorizationIds) {
        super(TENANT_USER_TYPE, tenantMetadata.tenantPrefix() + user, saslAuthenticationId, networkId, false, Collections.emptySet(), authorizationIds, identityMetadata);
        this.user = user;
        this.tenantMetadata = tenantMetadata;
    }

    public TenantMetadata tenantMetadata() {
        return this.tenantMetadata;
    }

    public String user() {
        return this.user;
    }

    public boolean isSuperUser(boolean enableDataplaneRbacForPKC, boolean oauthSuperUserDisable) {
        if (this.tenantMetadata.isServiceAccount) {
            return false;
        }
        if (this.tenantMetadata.isHealthcheckTenant) {
            return true;
        }
        return this.isInternalUser() || this.tenantMetadata.isApiKeyAuthenticated && !enableDataplaneRbacForPKC || !this.tenantMetadata.isApiKeyAuthenticated && !enableDataplaneRbacForPKC && !oauthSuperUserDisable;
    }

    public boolean isInternalUser() {
        return "0".equals(this.user);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MultiTenantPrincipal that = (MultiTenantPrincipal)o;
        return Objects.equals(this.tenantMetadata, that.tenantMetadata);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.tenantMetadata != null ? this.tenantMetadata.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "MultiTenantPrincipal(tenantMetadata=" + this.tenantMetadata + ", identityMetadata=" + super.identityMetadata() + ", user=" + this.user + ", authorizationIds=" + super.authorizationIds() + ")";
    }

    public static boolean isTenantPrincipal(KafkaPrincipal principal) {
        return principal.getPrincipalType().startsWith(TENANT_USER_TYPE);
    }

    public static boolean isAuthorizationIdUserResourceId(String authorizationId) {
        return !authorizationId.contains(POOL_ID_PREFIX) && !authorizationId.contains(SPIFFE_ID_PREFIX) && !authorizationId.contains(GROUP_PREFIX);
    }
}

