/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.EntityType;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class AlterMirrorsRequestData
implements ApiMessage {
    List<OpData> ops;
    List<MirrorOperation> mirrorOperations;
    boolean validateOnly;
    int timeoutMs;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("ops", new CompactArrayOf(OpData.SCHEMA_0), "The mirror control operations."), new Field("validate_only", Type.BOOLEAN, "Whether to validate that the cluster links can be created, but not actually create them."), new Field("timeout_ms", Type.INT32, "The time, in milliseconds, to allow for request completion."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema SCHEMA_1 = new Schema(new Field("ops", new CompactArrayOf(OpData.SCHEMA_1), "The mirror control operations."), new Field("validate_only", Type.BOOLEAN, "Whether to validate that the cluster links can be created, but not actually create them."), new Field("timeout_ms", Type.INT32, "The time, in milliseconds, to allow for request completion."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema SCHEMA_5;
    public static final Schema SCHEMA_6;
    public static final Schema[] SCHEMAS;
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 6;

    public AlterMirrorsRequestData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public AlterMirrorsRequestData() {
        this.ops = new ArrayList<OpData>(0);
        this.mirrorOperations = new ArrayList<MirrorOperation>(0);
        this.validateOnly = false;
        this.timeoutMs = 0;
    }

    @Override
    public short apiKey() {
        return 10006;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 6;
    }

    @Override
    public final void read(Readable _readable, short _version, MessageContext _context) {
        int i;
        ArrayList<OpData> newCollection;
        int arrayLength;
        if (_version <= 1) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field ops was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList<OpData>(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new OpData(_readable, _version, _context));
            }
            this.ops = newCollection;
        } else {
            this.ops = new ArrayList<OpData>(0);
        }
        if (_version >= 2) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field mirrorOperations was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add((OpData)((Object)new MirrorOperation(_readable, _version, _context)));
            }
            this.mirrorOperations = newCollection;
        } else {
            this.mirrorOperations = new ArrayList<MirrorOperation>(0);
        }
        this.validateOnly = _readable.readByte() != 0;
        this.timeoutMs = _readable.readInt();
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        if (_version <= 1) {
            _writable.writeUnsignedVarint(this.ops.size() + 1);
            for (OpData opsElement : this.ops) {
                opsElement.write(_writable, _cache, _version, _context);
            }
        } else if (!this.ops.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default ops at version " + _version);
        }
        if (_version >= 2) {
            _writable.writeUnsignedVarint(this.mirrorOperations.size() + 1);
            for (MirrorOperation mirrorOperationsElement : this.mirrorOperations) {
                mirrorOperationsElement.write(_writable, _cache, _version, _context);
            }
        } else if (!this.mirrorOperations.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default mirrorOperations at version " + _version);
        }
        _writable.writeByte(this.validateOnly ? (byte)1 : 0);
        _writable.writeInt(this.timeoutMs);
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        if (_version <= 1) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.ops.size() + 1));
            for (OpData opsElement : this.ops) {
                opsElement.addSize(_size, _cache, _version, _context);
            }
        }
        if (_version >= 2) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.mirrorOperations.size() + 1));
            for (MirrorOperation mirrorOperationsElement : this.mirrorOperations) {
                mirrorOperationsElement.addSize(_size, _cache, _version, _context);
            }
        }
        _size.addBytes(1);
        _size.addBytes(4);
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AlterMirrorsRequestData)) {
            return false;
        }
        AlterMirrorsRequestData other = (AlterMirrorsRequestData)obj;
        if (this.ops == null ? other.ops != null : !this.ops.equals(other.ops)) {
            return false;
        }
        if (this.mirrorOperations == null ? other.mirrorOperations != null : !this.mirrorOperations.equals(other.mirrorOperations)) {
            return false;
        }
        if (this.validateOnly != other.validateOnly) {
            return false;
        }
        if (this.timeoutMs != other.timeoutMs) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.ops == null ? 0 : this.ops.hashCode());
        hashCode = 31 * hashCode + (this.mirrorOperations == null ? 0 : this.mirrorOperations.hashCode());
        hashCode = 31 * hashCode + (this.validateOnly ? 1231 : 1237);
        hashCode = 31 * hashCode + this.timeoutMs;
        return hashCode;
    }

    @Override
    public AlterMirrorsRequestData duplicate() {
        AlterMirrorsRequestData _duplicate = new AlterMirrorsRequestData();
        ArrayList<OpData> newOps = new ArrayList<OpData>(this.ops.size());
        for (OpData _element : this.ops) {
            newOps.add(_element.duplicate());
        }
        _duplicate.ops = newOps;
        ArrayList<MirrorOperation> newMirrorOperations = new ArrayList<MirrorOperation>(this.mirrorOperations.size());
        for (MirrorOperation _element : this.mirrorOperations) {
            newMirrorOperations.add(_element.duplicate());
        }
        _duplicate.mirrorOperations = newMirrorOperations;
        _duplicate.validateOnly = this.validateOnly;
        _duplicate.timeoutMs = this.timeoutMs;
        return _duplicate;
    }

    public String toString() {
        return "AlterMirrorsRequestData(ops=" + MessageUtil.deepToString(this.ops.iterator()) + ", mirrorOperations=" + MessageUtil.deepToString(this.mirrorOperations.iterator()) + ", validateOnly=" + (this.validateOnly ? "true" : "false") + ", timeoutMs=" + this.timeoutMs + ")";
    }

    public List<OpData> ops() {
        return this.ops;
    }

    public List<MirrorOperation> mirrorOperations() {
        return this.mirrorOperations;
    }

    public boolean validateOnly() {
        return this.validateOnly;
    }

    public int timeoutMs() {
        return this.timeoutMs;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public AlterMirrorsRequestData setOps(List<OpData> v) {
        this.ops = v;
        return this;
    }

    public AlterMirrorsRequestData setMirrorOperations(List<MirrorOperation> v) {
        this.mirrorOperations = v;
        return this;
    }

    public AlterMirrorsRequestData setValidateOnly(boolean v) {
        this.validateOnly = v;
        return this;
    }

    public AlterMirrorsRequestData setTimeoutMs(int v) {
        this.timeoutMs = v;
        return this;
    }

    static {
        SCHEMA_3 = SCHEMA_2 = new Schema(new Field("mirror_operations", new CompactArrayOf(MirrorOperation.SCHEMA_2), "The mirror control operations."), new Field("validate_only", Type.BOOLEAN, "Whether to validate that the cluster links can be created, but not actually create them."), new Field("timeout_ms", Type.INT32, "The time, in milliseconds, to allow for request completion."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMA_4 = new Schema(new Field("mirror_operations", new CompactArrayOf(MirrorOperation.SCHEMA_4), "The mirror control operations."), new Field("validate_only", Type.BOOLEAN, "Whether to validate that the cluster links can be created, but not actually create them."), new Field("timeout_ms", Type.INT32, "The time, in milliseconds, to allow for request completion."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMA_5 = new Schema(new Field("mirror_operations", new CompactArrayOf(MirrorOperation.SCHEMA_5), "The mirror control operations."), new Field("validate_only", Type.BOOLEAN, "Whether to validate that the cluster links can be created, but not actually create them."), new Field("timeout_ms", Type.INT32, "The time, in milliseconds, to allow for request completion."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMA_6 = new Schema(new Field("mirror_operations", new CompactArrayOf(MirrorOperation.SCHEMA_6), "The mirror control operations."), new Field("validate_only", Type.BOOLEAN, "Whether to validate that the cluster links can be created, but not actually create them."), new Field("timeout_ms", Type.INT32, "The time, in milliseconds, to allow for request completion."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6};
    }

    public static class MirrorOperationData
    implements Message {
        Uuid sourceTopicId;
        String sourceTopicName;
        Uuid expectedLocalTopicId;
        List<Long> stoppedLogEndOffsets;
        short mirrorTopicErrorCode;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_4 = new Schema(new Field("source_topic_id", Type.UUID, "The source topic id. Used only when converting a writable topic into a mirror topic."), new Field("source_topic_name", Type.COMPACT_STRING, "The source topic name of the mirror topic. Used only when converting a writable topic into a mirror topic."), new Field("expected_local_topic_id", Type.UUID, "The expected local topic id of the topic being converted to a mirror topic. Used only when converting a writable topic into a mirror topic."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema SCHEMA_5 = new Schema(new Field("source_topic_id", Type.UUID, "The source topic id. Used only when converting a writable topic into a mirror topic."), new Field("source_topic_name", Type.COMPACT_STRING, "The source topic name of the mirror topic. Used only when converting a writable topic into a mirror topic."), new Field("expected_local_topic_id", Type.UUID, "The expected local topic id of the topic being converted to a mirror topic. Used only when converting a writable topic into a mirror topic."), new Field("stopped_log_end_offsets", CompactArrayOf.nullable(Type.INT64), "List of log end offsets ordered by partition ids at which the mirror topic was stopped. Null if the mirror topic is not stopped."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema SCHEMA_6 = new Schema(new Field("source_topic_id", Type.UUID, "The source topic id. Used only when converting a writable topic into a mirror topic."), new Field("source_topic_name", Type.COMPACT_STRING, "The source topic name of the mirror topic. Used only when converting a writable topic into a mirror topic."), new Field("expected_local_topic_id", Type.UUID, "The expected local topic id of the topic being converted to a mirror topic. Used only when converting a writable topic into a mirror topic."), new Field("stopped_log_end_offsets", CompactArrayOf.nullable(Type.INT64), "List of log end offsets ordered by partition ids at which the mirror topic was stopped. Null if the mirror topic is not stopped."), new Field("mirror_topic_error_code", Type.INT16, "Mirror topic error code used when failing a mirror topic."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{null, null, null, null, SCHEMA_4, SCHEMA_5, SCHEMA_6};
        public static final short LOWEST_SUPPORTED_VERSION = 4;
        public static final short HIGHEST_SUPPORTED_VERSION = 6;

        public MirrorOperationData(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public MirrorOperationData() {
            this.sourceTopicId = Uuid.ZERO_UUID;
            this.sourceTopicName = "";
            this.expectedLocalTopicId = Uuid.ZERO_UUID;
            this.stoppedLogEndOffsets = null;
            this.mirrorTopicErrorCode = 0;
        }

        @Override
        public short lowestSupportedVersion() {
            return 2;
        }

        @Override
        public short highestSupportedVersion() {
            return 6;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 6) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of MirrorOperationData");
            }
            this.sourceTopicId = _readable.readUuid();
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field sourceTopicName was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field sourceTopicName had invalid length " + length);
            }
            this.sourceTopicName = _context.read(EntityType.TOPIC_NAME, _readable.readString(length));
            this.expectedLocalTopicId = _readable.readUuid();
            if (_version >= 5) {
                int arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    this.stoppedLogEndOffsets = null;
                } else {
                    if (arrayLength > _readable.remaining()) {
                        throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                    }
                    ArrayList<Long> newCollection = new ArrayList<Long>(arrayLength);
                    for (int i = 0; i < arrayLength; ++i) {
                        newCollection.add(_readable.readLong());
                    }
                    this.stoppedLogEndOffsets = newCollection;
                }
            } else {
                this.stoppedLogEndOffsets = null;
            }
            this.mirrorTopicErrorCode = _version >= 6 ? _readable.readShort() : (short)0;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            if (_version < 4) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of MirrorOperationData");
            }
            int _numTaggedFields = 0;
            _writable.writeUuid(this.sourceTopicId);
            Object _stringBytes = _cache.getSerializedValue(this.sourceTopicName);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeUuid(this.expectedLocalTopicId);
            if (_version >= 5) {
                if (this.stoppedLogEndOffsets == null) {
                    _writable.writeUnsignedVarint(0);
                } else {
                    _writable.writeUnsignedVarint(this.stoppedLogEndOffsets.size() + 1);
                    _stringBytes = this.stoppedLogEndOffsets.iterator();
                    while (_stringBytes.hasNext()) {
                        Long stoppedLogEndOffsetsElement = (Long)_stringBytes.next();
                        _writable.writeLong(stoppedLogEndOffsetsElement);
                    }
                }
            } else if (this.stoppedLogEndOffsets != null) {
                throw new UnsupportedVersionException("Attempted to write a non-default stoppedLogEndOffsets at version " + _version);
            }
            if (_version >= 6) {
                _writable.writeShort(this.mirrorTopicErrorCode);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 6) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of MirrorOperationData");
            }
            _size.addBytes(16);
            byte[] _stringBytes = _context.write(EntityType.TOPIC_NAME, this.sourceTopicName).getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'sourceTopicName' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.sourceTopicName, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _size.addBytes(16);
            if (_version >= 5) {
                if (this.stoppedLogEndOffsets == null) {
                    _size.addBytes(1);
                } else {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.stoppedLogEndOffsets.size() + 1));
                    _size.addBytes(this.stoppedLogEndOffsets.size() * 8);
                }
            }
            if (_version >= 6) {
                _size.addBytes(2);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MirrorOperationData)) {
                return false;
            }
            MirrorOperationData other = (MirrorOperationData)obj;
            if (!this.sourceTopicId.equals(other.sourceTopicId)) {
                return false;
            }
            if (this.sourceTopicName == null ? other.sourceTopicName != null : !this.sourceTopicName.equals(other.sourceTopicName)) {
                return false;
            }
            if (!this.expectedLocalTopicId.equals(other.expectedLocalTopicId)) {
                return false;
            }
            if (this.stoppedLogEndOffsets == null ? other.stoppedLogEndOffsets != null : !this.stoppedLogEndOffsets.equals(other.stoppedLogEndOffsets)) {
                return false;
            }
            if (this.mirrorTopicErrorCode != other.mirrorTopicErrorCode) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.sourceTopicId.hashCode();
            hashCode = 31 * hashCode + (this.sourceTopicName == null ? 0 : this.sourceTopicName.hashCode());
            hashCode = 31 * hashCode + this.expectedLocalTopicId.hashCode();
            hashCode = 31 * hashCode + (this.stoppedLogEndOffsets == null ? 0 : this.stoppedLogEndOffsets.hashCode());
            hashCode = 31 * hashCode + this.mirrorTopicErrorCode;
            return hashCode;
        }

        @Override
        public MirrorOperationData duplicate() {
            MirrorOperationData _duplicate = new MirrorOperationData();
            _duplicate.sourceTopicId = this.sourceTopicId;
            _duplicate.sourceTopicName = this.sourceTopicName;
            _duplicate.expectedLocalTopicId = this.expectedLocalTopicId;
            if (this.stoppedLogEndOffsets == null) {
                _duplicate.stoppedLogEndOffsets = null;
            } else {
                ArrayList<Long> newStoppedLogEndOffsets = new ArrayList<Long>(this.stoppedLogEndOffsets.size());
                for (Long _element : this.stoppedLogEndOffsets) {
                    newStoppedLogEndOffsets.add(_element);
                }
                _duplicate.stoppedLogEndOffsets = newStoppedLogEndOffsets;
            }
            _duplicate.mirrorTopicErrorCode = this.mirrorTopicErrorCode;
            return _duplicate;
        }

        public String toString() {
            return "MirrorOperationData(sourceTopicId=" + this.sourceTopicId.toString() + ", sourceTopicName=" + (this.sourceTopicName == null ? "null" : "'" + this.sourceTopicName.toString() + "'") + ", expectedLocalTopicId=" + this.expectedLocalTopicId.toString() + ", stoppedLogEndOffsets=" + (this.stoppedLogEndOffsets == null ? "null" : MessageUtil.deepToString(this.stoppedLogEndOffsets.iterator())) + ", mirrorTopicErrorCode=" + this.mirrorTopicErrorCode + ")";
        }

        public Uuid sourceTopicId() {
            return this.sourceTopicId;
        }

        public String sourceTopicName() {
            return this.sourceTopicName;
        }

        public Uuid expectedLocalTopicId() {
            return this.expectedLocalTopicId;
        }

        public List<Long> stoppedLogEndOffsets() {
            return this.stoppedLogEndOffsets;
        }

        public short mirrorTopicErrorCode() {
            return this.mirrorTopicErrorCode;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public MirrorOperationData setSourceTopicId(Uuid v) {
            this.sourceTopicId = v;
            return this;
        }

        public MirrorOperationData setSourceTopicName(String v) {
            this.sourceTopicName = v;
            return this;
        }

        public MirrorOperationData setExpectedLocalTopicId(Uuid v) {
            this.expectedLocalTopicId = v;
            return this;
        }

        public MirrorOperationData setStoppedLogEndOffsets(List<Long> v) {
            this.stoppedLogEndOffsets = v;
            return this;
        }

        public MirrorOperationData setMirrorTopicErrorCode(short v) {
            this.mirrorTopicErrorCode = v;
            return this;
        }
    }

    public static class MirrorOperation
    implements Message {
        String topic;
        byte operationCode;
        MirrorOperationData mirrorOperationData;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 2;
        public static final short HIGHEST_SUPPORTED_VERSION = 6;

        public MirrorOperation(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public MirrorOperation() {
            this.topic = "";
            this.operationCode = 0;
            this.mirrorOperationData = null;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 6;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 6) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of MirrorOperation");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field topic was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field topic had invalid length " + length);
            }
            this.topic = _context.read(EntityType.TOPIC_NAME, _readable.readString(length));
            this.operationCode = _readable.readByte();
            this.mirrorOperationData = _version >= 4 ? (_readable.readByte() < 0 ? null : new MirrorOperationData(_readable, _version, _context)) : null;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            if (_version < 2) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of MirrorOperation");
            }
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue(this.topic);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _writable.writeByte(this.operationCode);
            if (_version >= 4) {
                if (this.mirrorOperationData == null) {
                    _writable.writeByte((byte)-1);
                } else {
                    _writable.writeByte((byte)1);
                    this.mirrorOperationData.write(_writable, _cache, _version, _context);
                }
            } else if (this.mirrorOperationData != null) {
                throw new UnsupportedVersionException("Attempted to write a non-default mirrorOperationData at version " + _version);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 6) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of MirrorOperation");
            }
            byte[] _stringBytes = _context.write(EntityType.TOPIC_NAME, this.topic).getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'topic' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.topic, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _size.addBytes(1);
            if (_version >= 4) {
                if (this.mirrorOperationData == null) {
                    _size.addBytes(1);
                } else {
                    _size.addBytes(1);
                    this.mirrorOperationData.addSize(_size, _cache, _version, _context);
                }
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MirrorOperation)) {
                return false;
            }
            MirrorOperation other = (MirrorOperation)obj;
            if (this.topic == null ? other.topic != null : !this.topic.equals(other.topic)) {
                return false;
            }
            if (this.operationCode != other.operationCode) {
                return false;
            }
            if (this.mirrorOperationData == null ? other.mirrorOperationData != null : !this.mirrorOperationData.equals(other.mirrorOperationData)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.topic == null ? 0 : this.topic.hashCode());
            hashCode = 31 * hashCode + this.operationCode;
            hashCode = 31 * hashCode + (this.mirrorOperationData == null ? 0 : this.mirrorOperationData.hashCode());
            return hashCode;
        }

        @Override
        public MirrorOperation duplicate() {
            MirrorOperation _duplicate = new MirrorOperation();
            _duplicate.topic = this.topic;
            _duplicate.operationCode = this.operationCode;
            _duplicate.mirrorOperationData = this.mirrorOperationData == null ? null : this.mirrorOperationData.duplicate();
            return _duplicate;
        }

        public String toString() {
            return "MirrorOperation(topic=" + (this.topic == null ? "null" : "'" + this.topic.toString() + "'") + ", operationCode=" + this.operationCode + ", mirrorOperationData=" + (this.mirrorOperationData == null ? "null" : this.mirrorOperationData.toString()) + ")";
        }

        public String topic() {
            return this.topic;
        }

        public byte operationCode() {
            return this.operationCode;
        }

        public MirrorOperationData mirrorOperationData() {
            return this.mirrorOperationData;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public MirrorOperation setTopic(String v) {
            this.topic = v;
            return this;
        }

        public MirrorOperation setOperationCode(byte v) {
            this.operationCode = v;
            return this;
        }

        public MirrorOperation setMirrorOperationData(MirrorOperationData v) {
            this.mirrorOperationData = v;
            return this;
        }

        static {
            SCHEMA_3 = SCHEMA_2 = new Schema(new Field("topic", Type.COMPACT_STRING, "The mirror topic's name."), new Field("operation_code", Type.INT8, "The operation to perform on the mirror."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMA_4 = new Schema(new Field("topic", Type.COMPACT_STRING, "The mirror topic's name."), new Field("operation_code", Type.INT8, "The operation to perform on the mirror."), new Field("mirror_operation_data", MirrorOperationData.SCHEMA_4, "Data needed for the mirror topic operation."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMA_5 = new Schema(new Field("topic", Type.COMPACT_STRING, "The mirror topic's name."), new Field("operation_code", Type.INT8, "The operation to perform on the mirror."), new Field("mirror_operation_data", MirrorOperationData.SCHEMA_5, "Data needed for the mirror topic operation."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMA_6 = new Schema(new Field("topic", Type.COMPACT_STRING, "The mirror topic's name."), new Field("operation_code", Type.INT8, "The operation to perform on the mirror."), new Field("mirror_operation_data", MirrorOperationData.SCHEMA_6, "Data needed for the mirror topic operation."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{null, null, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6};
        }
    }

    public static class PauseMirrorTopicData
    implements Message {
        String topic;
        boolean enable;
        boolean linkLevel;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_1 = new Schema(new Field("topic", Type.COMPACT_STRING, "The mirror topic's name."), new Field("enable", Type.BOOLEAN, "If true, pauses the topic's mirroring, otherwise removes the paused state."), new Field("link_level", Type.BOOLEAN, "Whether the pausing is being applied at the link level (internal), otherwise topic level (client)."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{null, SCHEMA_1};
        public static final short LOWEST_SUPPORTED_VERSION = 1;
        public static final short HIGHEST_SUPPORTED_VERSION = 1;

        public PauseMirrorTopicData(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public PauseMirrorTopicData() {
            this.topic = "";
            this.enable = false;
            this.linkLevel = false;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 1;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field topic was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field topic had invalid length " + length);
            }
            this.topic = _context.read(EntityType.TOPIC_NAME, _readable.readString(length));
            this.enable = _readable.readByte() != 0;
            this.linkLevel = _readable.readByte() != 0;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            if (_version < 1) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of PauseMirrorTopicData");
            }
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue(this.topic);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _writable.writeByte(this.enable ? (byte)1 : 0);
            _writable.writeByte(this.linkLevel ? (byte)1 : 0);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _context.write(EntityType.TOPIC_NAME, this.topic).getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'topic' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.topic, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _size.addBytes(1);
            _size.addBytes(1);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PauseMirrorTopicData)) {
                return false;
            }
            PauseMirrorTopicData other = (PauseMirrorTopicData)obj;
            if (this.topic == null ? other.topic != null : !this.topic.equals(other.topic)) {
                return false;
            }
            if (this.enable != other.enable) {
                return false;
            }
            if (this.linkLevel != other.linkLevel) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.topic == null ? 0 : this.topic.hashCode());
            hashCode = 31 * hashCode + (this.enable ? 1231 : 1237);
            hashCode = 31 * hashCode + (this.linkLevel ? 1231 : 1237);
            return hashCode;
        }

        @Override
        public PauseMirrorTopicData duplicate() {
            PauseMirrorTopicData _duplicate = new PauseMirrorTopicData();
            _duplicate.topic = this.topic;
            _duplicate.enable = this.enable;
            _duplicate.linkLevel = this.linkLevel;
            return _duplicate;
        }

        public String toString() {
            return "PauseMirrorTopicData(topic=" + (this.topic == null ? "null" : "'" + this.topic.toString() + "'") + ", enable=" + (this.enable ? "true" : "false") + ", linkLevel=" + (this.linkLevel ? "true" : "false") + ")";
        }

        public String topic() {
            return this.topic;
        }

        public boolean enable() {
            return this.enable;
        }

        public boolean linkLevel() {
            return this.linkLevel;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public PauseMirrorTopicData setTopic(String v) {
            this.topic = v;
            return this;
        }

        public PauseMirrorTopicData setEnable(boolean v) {
            this.enable = v;
            return this;
        }

        public PauseMirrorTopicData setLinkLevel(boolean v) {
            this.linkLevel = v;
            return this;
        }
    }

    public static class ClearMirrorTopicData
    implements Message {
        String topic;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 1;

        public ClearMirrorTopicData(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public ClearMirrorTopicData() {
            this.topic = "";
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 1;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field topic was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field topic had invalid length " + length);
            }
            this.topic = _context.read(EntityType.TOPIC_NAME, _readable.readString(length));
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue(this.topic);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _context.write(EntityType.TOPIC_NAME, this.topic).getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'topic' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.topic, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ClearMirrorTopicData)) {
                return false;
            }
            ClearMirrorTopicData other = (ClearMirrorTopicData)obj;
            if (this.topic == null ? other.topic != null : !this.topic.equals(other.topic)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.topic == null ? 0 : this.topic.hashCode());
            return hashCode;
        }

        @Override
        public ClearMirrorTopicData duplicate() {
            ClearMirrorTopicData _duplicate = new ClearMirrorTopicData();
            _duplicate.topic = this.topic;
            return _duplicate;
        }

        public String toString() {
            return "ClearMirrorTopicData(topic=" + (this.topic == null ? "null" : "'" + this.topic.toString() + "'") + ")";
        }

        public String topic() {
            return this.topic;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public ClearMirrorTopicData setTopic(String v) {
            this.topic = v;
            return this;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field("topic", Type.COMPACT_STRING, "The mirror topic's name."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
        }
    }

    public static class StopMirrorTopicData
    implements Message {
        String topic;
        boolean synchronize;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("topic", Type.COMPACT_STRING, "The mirror topic's name."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema SCHEMA_1 = new Schema(new Field("topic", Type.COMPACT_STRING, "The mirror topic's name."), new Field("synchronize", Type.BOOLEAN, "Whether to synchronize with the source topic before stopping mirroring."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 1;

        public StopMirrorTopicData(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public StopMirrorTopicData() {
            this.topic = "";
            this.synchronize = true;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 1;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field topic was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field topic had invalid length " + length);
            }
            this.topic = _context.read(EntityType.TOPIC_NAME, _readable.readString(length));
            this.synchronize = _version >= 1 ? _readable.readByte() != 0 : true;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue(this.topic);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            if (_version >= 1) {
                _writable.writeByte(this.synchronize ? (byte)1 : 0);
            } else if (!this.synchronize) {
                throw new UnsupportedVersionException("Attempted to write a non-default synchronize at version " + _version);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _context.write(EntityType.TOPIC_NAME, this.topic).getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'topic' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.topic, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            if (_version >= 1) {
                _size.addBytes(1);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof StopMirrorTopicData)) {
                return false;
            }
            StopMirrorTopicData other = (StopMirrorTopicData)obj;
            if (this.topic == null ? other.topic != null : !this.topic.equals(other.topic)) {
                return false;
            }
            if (this.synchronize != other.synchronize) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.topic == null ? 0 : this.topic.hashCode());
            hashCode = 31 * hashCode + (this.synchronize ? 1231 : 1237);
            return hashCode;
        }

        @Override
        public StopMirrorTopicData duplicate() {
            StopMirrorTopicData _duplicate = new StopMirrorTopicData();
            _duplicate.topic = this.topic;
            _duplicate.synchronize = this.synchronize;
            return _duplicate;
        }

        public String toString() {
            return "StopMirrorTopicData(topic=" + (this.topic == null ? "null" : "'" + this.topic.toString() + "'") + ", synchronize=" + (this.synchronize ? "true" : "false") + ")";
        }

        public String topic() {
            return this.topic;
        }

        public boolean synchronize() {
            return this.synchronize;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public StopMirrorTopicData setTopic(String v) {
            this.topic = v;
            return this;
        }

        public StopMirrorTopicData setSynchronize(boolean v) {
            this.synchronize = v;
            return this;
        }
    }

    public static class OpData
    implements Message {
        List<StopMirrorTopicData> stopMirrorTopic;
        List<ClearMirrorTopicData> clearMirrorTopic;
        List<PauseMirrorTopicData> pauseMirrorTopic;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("stop_mirror_topic", CompactArrayOf.nullable(StopMirrorTopicData.SCHEMA_0), "Stops a topic's mirroring to become a writable topic."), new Field("clear_mirror_topic", CompactArrayOf.nullable(ClearMirrorTopicData.SCHEMA_0), "Clears a topic's mirror information."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema SCHEMA_1 = new Schema(new Field("stop_mirror_topic", CompactArrayOf.nullable(StopMirrorTopicData.SCHEMA_1), "Stops a topic's mirroring to become a writable topic."), new Field("clear_mirror_topic", CompactArrayOf.nullable(ClearMirrorTopicData.SCHEMA_0), "Clears a topic's mirror information."), new Field("pause_mirror_topic", CompactArrayOf.nullable(PauseMirrorTopicData.SCHEMA_1), "Pauses a mirror topic's replication."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 1;

        public OpData(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public OpData() {
            this.stopMirrorTopic = null;
            this.clearMirrorTopic = null;
            this.pauseMirrorTopic = null;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 6;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            int i;
            ArrayList<StopMirrorTopicData> newCollection;
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                this.stopMirrorTopic = null;
            } else {
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                newCollection = new ArrayList<StopMirrorTopicData>(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new StopMirrorTopicData(_readable, _version, _context));
                }
                this.stopMirrorTopic = newCollection;
            }
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                this.clearMirrorTopic = null;
            } else {
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add((StopMirrorTopicData)((Object)new ClearMirrorTopicData(_readable, _version, _context)));
                }
                this.clearMirrorTopic = newCollection;
            }
            if (_version >= 1) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    this.pauseMirrorTopic = null;
                } else {
                    if (arrayLength > _readable.remaining()) {
                        throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                    }
                    newCollection = new ArrayList(arrayLength);
                    for (i = 0; i < arrayLength; ++i) {
                        newCollection.add((StopMirrorTopicData)((Object)new PauseMirrorTopicData(_readable, _version, _context)));
                    }
                    this.pauseMirrorTopic = newCollection;
                }
            } else {
                this.pauseMirrorTopic = null;
            }
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of OpData");
            }
            int _numTaggedFields = 0;
            if (this.stopMirrorTopic == null) {
                _writable.writeUnsignedVarint(0);
            } else {
                _writable.writeUnsignedVarint(this.stopMirrorTopic.size() + 1);
                for (StopMirrorTopicData stopMirrorTopicElement : this.stopMirrorTopic) {
                    stopMirrorTopicElement.write(_writable, _cache, _version, _context);
                }
            }
            if (this.clearMirrorTopic == null) {
                _writable.writeUnsignedVarint(0);
            } else {
                _writable.writeUnsignedVarint(this.clearMirrorTopic.size() + 1);
                for (ClearMirrorTopicData clearMirrorTopicElement : this.clearMirrorTopic) {
                    clearMirrorTopicElement.write(_writable, _cache, _version, _context);
                }
            }
            if (_version >= 1) {
                if (this.pauseMirrorTopic == null) {
                    _writable.writeUnsignedVarint(0);
                } else {
                    _writable.writeUnsignedVarint(this.pauseMirrorTopic.size() + 1);
                    for (PauseMirrorTopicData pauseMirrorTopicElement : this.pauseMirrorTopic) {
                        pauseMirrorTopicElement.write(_writable, _cache, _version, _context);
                    }
                }
            } else if (this.pauseMirrorTopic != null) {
                throw new UnsupportedVersionException("Attempted to write a non-default pauseMirrorTopic at version " + _version);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (this.stopMirrorTopic == null) {
                _size.addBytes(1);
            } else {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.stopMirrorTopic.size() + 1));
                for (StopMirrorTopicData stopMirrorTopicElement : this.stopMirrorTopic) {
                    stopMirrorTopicElement.addSize(_size, _cache, _version, _context);
                }
            }
            if (this.clearMirrorTopic == null) {
                _size.addBytes(1);
            } else {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.clearMirrorTopic.size() + 1));
                for (ClearMirrorTopicData clearMirrorTopicElement : this.clearMirrorTopic) {
                    clearMirrorTopicElement.addSize(_size, _cache, _version, _context);
                }
            }
            if (_version >= 1) {
                if (this.pauseMirrorTopic == null) {
                    _size.addBytes(1);
                } else {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.pauseMirrorTopic.size() + 1));
                    for (PauseMirrorTopicData pauseMirrorTopicElement : this.pauseMirrorTopic) {
                        pauseMirrorTopicElement.addSize(_size, _cache, _version, _context);
                    }
                }
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof OpData)) {
                return false;
            }
            OpData other = (OpData)obj;
            if (this.stopMirrorTopic == null ? other.stopMirrorTopic != null : !this.stopMirrorTopic.equals(other.stopMirrorTopic)) {
                return false;
            }
            if (this.clearMirrorTopic == null ? other.clearMirrorTopic != null : !this.clearMirrorTopic.equals(other.clearMirrorTopic)) {
                return false;
            }
            if (this.pauseMirrorTopic == null ? other.pauseMirrorTopic != null : !this.pauseMirrorTopic.equals(other.pauseMirrorTopic)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.stopMirrorTopic == null ? 0 : this.stopMirrorTopic.hashCode());
            hashCode = 31 * hashCode + (this.clearMirrorTopic == null ? 0 : this.clearMirrorTopic.hashCode());
            hashCode = 31 * hashCode + (this.pauseMirrorTopic == null ? 0 : this.pauseMirrorTopic.hashCode());
            return hashCode;
        }

        @Override
        public OpData duplicate() {
            OpData _duplicate = new OpData();
            if (this.stopMirrorTopic == null) {
                _duplicate.stopMirrorTopic = null;
            } else {
                ArrayList<StopMirrorTopicData> newStopMirrorTopic = new ArrayList<StopMirrorTopicData>(this.stopMirrorTopic.size());
                for (StopMirrorTopicData stopMirrorTopicData : this.stopMirrorTopic) {
                    newStopMirrorTopic.add(stopMirrorTopicData.duplicate());
                }
                _duplicate.stopMirrorTopic = newStopMirrorTopic;
            }
            if (this.clearMirrorTopic == null) {
                _duplicate.clearMirrorTopic = null;
            } else {
                ArrayList<ClearMirrorTopicData> newClearMirrorTopic = new ArrayList<ClearMirrorTopicData>(this.clearMirrorTopic.size());
                for (ClearMirrorTopicData clearMirrorTopicData : this.clearMirrorTopic) {
                    newClearMirrorTopic.add(clearMirrorTopicData.duplicate());
                }
                _duplicate.clearMirrorTopic = newClearMirrorTopic;
            }
            if (this.pauseMirrorTopic == null) {
                _duplicate.pauseMirrorTopic = null;
            } else {
                ArrayList<PauseMirrorTopicData> newPauseMirrorTopic = new ArrayList<PauseMirrorTopicData>(this.pauseMirrorTopic.size());
                for (PauseMirrorTopicData pauseMirrorTopicData : this.pauseMirrorTopic) {
                    newPauseMirrorTopic.add(pauseMirrorTopicData.duplicate());
                }
                _duplicate.pauseMirrorTopic = newPauseMirrorTopic;
            }
            return _duplicate;
        }

        public String toString() {
            return "OpData(stopMirrorTopic=" + (this.stopMirrorTopic == null ? "null" : MessageUtil.deepToString(this.stopMirrorTopic.iterator())) + ", clearMirrorTopic=" + (this.clearMirrorTopic == null ? "null" : MessageUtil.deepToString(this.clearMirrorTopic.iterator())) + ", pauseMirrorTopic=" + (this.pauseMirrorTopic == null ? "null" : MessageUtil.deepToString(this.pauseMirrorTopic.iterator())) + ")";
        }

        public List<StopMirrorTopicData> stopMirrorTopic() {
            return this.stopMirrorTopic;
        }

        public List<ClearMirrorTopicData> clearMirrorTopic() {
            return this.clearMirrorTopic;
        }

        public List<PauseMirrorTopicData> pauseMirrorTopic() {
            return this.pauseMirrorTopic;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public OpData setStopMirrorTopic(List<StopMirrorTopicData> v) {
            this.stopMirrorTopic = v;
            return this;
        }

        public OpData setClearMirrorTopic(List<ClearMirrorTopicData> v) {
            this.clearMirrorTopic = v;
            return this;
        }

        public OpData setPauseMirrorTopic(List<PauseMirrorTopicData> v) {
            this.pauseMirrorTopic = v;
            return this;
        }
    }
}

