/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.clients.admin.ClusterLinkDescription;
import org.apache.kafka.common.ClusterLinkError;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.message.DescribeClusterLinksResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractResponse;

public class DescribeClusterLinksResponse
extends AbstractResponse {
    private final DescribeClusterLinksResponseData data;

    public DescribeClusterLinksResponse(DescribeClusterLinksResponseData data) {
        super(ApiKeys.DESCRIBE_CLUSTER_LINKS);
        this.data = data;
    }

    public DescribeClusterLinksResponse(int throttleTimeMs, Throwable e) {
        super(ApiKeys.DESCRIBE_CLUSTER_LINKS);
        this.data = new DescribeClusterLinksResponseData().setThrottleTimeMs(throttleTimeMs).setErrorCode(Errors.forException(e).code()).setErrorMessage(e.getMessage());
    }

    public void complete(KafkaFutureImpl<Collection<ClusterLinkDescription>> result) {
        Errors error = Errors.forCode(this.data.errorCode());
        if (error != Errors.NONE) {
            result.completeExceptionally(error.exception(this.data.errorMessage()));
            return;
        }
        ArrayList<ClusterLinkDescription> clusterLinks = new ArrayList<ClusterLinkDescription>(this.data.entries().size());
        for (DescribeClusterLinksResponseData.EntryData entryData : this.data.entries()) {
            Uuid clusterLinkId = entryData.linkId();
            clusterLinks.add(new ClusterLinkDescription(entryData.linkName(), clusterLinkId, entryData.remoteClusterId(), entryData.localClusterId(), entryData.topics(), ClusterLinkDescription.LinkState.fromShort(entryData.linkState()), ClusterLinkDescription.LinkMode.fromShort(entryData.linkMode()), ClusterLinkDescription.ConnectionMode.fromShort(entryData.connectionMode()), ClusterLinkError.fromShort(entryData.linkErrorCode()), entryData.linkErrorMessage(), entryData.linkCoordinatorId(), entryData.linkCoordinatorHost(), entryData.linkCoordinatorPort(), ClusterLinkDescription.LinkState.fromShort(entryData.remoteLinkState()), ClusterLinkError.fromShort(entryData.remoteLinkErrorCode()), entryData.remoteLinkErrorMessage(), entryData.remoteLinkStateTimeMs()));
        }
        result.complete(clusterLinks);
    }

    public Set<String> clusterLinkNames() {
        HashSet<String> clusterLinkNames = new HashSet<String>();
        Errors error = Errors.forCode(this.data.errorCode());
        if (error != Errors.NONE) {
            return clusterLinkNames;
        }
        for (DescribeClusterLinksResponseData.EntryData entryData : this.data.entries()) {
            clusterLinkNames.add(entryData.linkName());
        }
        return clusterLinkNames;
    }

    @Override
    public DescribeClusterLinksResponseData data() {
        return this.data;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return Collections.singletonMap(Errors.forCode(this.data.errorCode()), 1);
    }

    public static DescribeClusterLinksResponse parse(ByteBuffer buffer, short version, MessageContext context) {
        return new DescribeClusterLinksResponse(new DescribeClusterLinksResponseData(new ByteBufferAccessor(buffer), version, context));
    }
}

