/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals.events;

import java.util.concurrent.CompletableFuture;
import org.apache.kafka.clients.consumer.internals.ConsumerUtils;
import org.apache.kafka.clients.consumer.internals.events.ApplicationEvent;
import org.apache.kafka.common.utils.Timer;

public abstract class CompletableApplicationEvent<T>
extends ApplicationEvent {
    private final CompletableFuture<T> future = new CompletableFuture();

    protected CompletableApplicationEvent(ApplicationEvent.Type type) {
        super(type);
    }

    public CompletableFuture<T> future() {
        return this.future;
    }

    public T get(Timer timer) {
        return ConsumerUtils.getResult(this.future, timer);
    }

    public void chain(CompletableFuture<T> providedFuture) {
        providedFuture.whenComplete((value, exception) -> {
            if (exception != null) {
                this.future.completeExceptionally((Throwable)exception);
            } else {
                this.future.complete(value);
            }
        });
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CompletableApplicationEvent that = (CompletableApplicationEvent)o;
        return this.future.equals(that.future);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.future.hashCode();
        return result;
    }

    @Override
    protected String toStringBase() {
        return super.toStringBase() + ", future=" + this.future;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.toStringBase() + '}';
    }
}

