/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.authenticator;

import java.util.Objects;

public class PathAwareSniHostName {
    private final String routingPathPrefix;
    private final String strippedHostName;
    private final String logicalClusterId;
    private final String subdomain;
    private final String apeId;

    public PathAwareSniHostName(String rawHostName) {
        this(rawHostName, null);
    }

    public PathAwareSniHostName(String rawHostName, String subdomainPrefix) {
        Objects.requireNonNull(rawHostName);
        if (rawHostName.length() > 3 && rawHostName.charAt(2) == '-' && (rawHostName.startsWith("lkc-", 3) || rawHostName.startsWith("e-", 3))) {
            this.routingPathPrefix = rawHostName.substring(0, 2);
            this.strippedHostName = rawHostName.substring(3);
        } else {
            this.routingPathPrefix = null;
            this.strippedHostName = rawHostName;
        }
        int endLkcPos = -1;
        if (this.strippedHostName.startsWith("lkc-")) {
            int dotPos;
            int dashPos = this.strippedHostName.indexOf(45, 4);
            int n = endLkcPos = dashPos < (dotPos = this.strippedHostName.indexOf(46, 4)) ? dashPos : dotPos;
            this.logicalClusterId = endLkcPos != -1 ? this.strippedHostName.substring(0, endLkcPos) : null;
        } else {
            this.logicalClusterId = null;
        }
        int n = endLkcPos = endLkcPos == -1 ? 0 : endLkcPos;
        if (subdomainPrefix == null || subdomainPrefix == "") {
            this.subdomain = null;
            this.apeId = null;
        } else {
            int subdomainPos = this.strippedHostName.indexOf(subdomainPrefix, endLkcPos);
            if (subdomainPos != -1) {
                int apePos;
                this.subdomain = this.strippedHostName.substring(subdomainPos);
                this.apeId = subdomainPos - endLkcPos > 4 ? ((apePos = this.strippedHostName.indexOf(".ape", endLkcPos)) != -1 && apePos < subdomainPos ? this.strippedHostName.substring(apePos + 1, subdomainPos - 1) : null) : null;
            } else {
                this.subdomain = null;
                this.apeId = null;
            }
        }
    }

    public String routingPathPrefix() {
        return this.routingPathPrefix;
    }

    public String strippedHostname() {
        return this.strippedHostName;
    }

    public String logicalClusterId() {
        return this.logicalClusterId;
    }

    public String apeId() {
        return this.apeId;
    }

    public String subdomain() {
        return this.subdomain;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PathAwareSniHostName that = (PathAwareSniHostName)o;
        return Objects.equals(this.routingPathPrefix, that.routingPathPrefix) && this.strippedHostName.equals(that.strippedHostName) && Objects.equals(this.logicalClusterId, that.logicalClusterId);
    }

    public int hashCode() {
        return Objects.hash(this.routingPathPrefix, this.strippedHostName, this.logicalClusterId);
    }

    public String toString() {
        return "PathAwareSniHostName[routingPathPrefix=" + this.routingPathPrefix + ",strippedHostName=" + this.strippedHostName + ",logicalClusterId=" + this.logicalClusterId + ",subdomain=" + this.subdomain + ",ape=" + this.apeId;
    }
}

