/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.traffic;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TrafficNetworkIdRoutes {
    public static final TrafficNetworkIdRoutes EMPTY = new TrafficNetworkIdRoutes(null, null);
    private final Set<String> networkIdRoutes;
    private final Set<String> dnsDomainSuffixes;
    private final boolean allowAllDNSDomainSuffixes;

    public TrafficNetworkIdRoutes(List<String> networkIdRoutes, List<String> dnsDomainSuffixes) {
        this.networkIdRoutes = networkIdRoutes == null ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<String>(networkIdRoutes));
        this.dnsDomainSuffixes = dnsDomainSuffixes == null ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<String>(dnsDomainSuffixes));
        this.allowAllDNSDomainSuffixes = this.networkIdRoutes.size() > 0 && this.dnsDomainSuffixes.isEmpty();
    }

    public boolean allows(String networkId) {
        return this.networkIdRoutes.contains(networkId);
    }

    public boolean allowsDNSDomainSuffix(String certSAN) {
        if (certSAN == null || certSAN.isEmpty()) {
            return false;
        }
        if (this.allowAllDNSDomainSuffixes) {
            return true;
        }
        for (String dnsDomainSuffix : this.dnsDomainSuffixes) {
            if (!certSAN.endsWith(dnsDomainSuffix)) continue;
            return true;
        }
        return false;
    }

    public Set<String> networkIdRoutes() {
        return this.networkIdRoutes;
    }

    public String toString() {
        return "TrafficNetworkIdRoutes{networkIdRoutes=" + this.networkIdRoutes + "dnsDomainSuffixes=" + this.dnsDomainSuffixes + '}';
    }
}

