/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.AppendRecordsResponseData;
import org.apache.kafka.common.protocol.MessageUtil;

public class AppendRecordsResponseDataJsonConverter {
    public static AppendRecordsResponseData read(JsonNode _node, short _version) {
        AppendRecordsResponseData _object = new AppendRecordsResponseData();
        JsonNode _throttleTimeMsNode = _node.get("throttleTimeMs");
        if (_throttleTimeMsNode == null) {
            throw new RuntimeException("AppendRecordsResponseData: unable to locate field 'throttleTimeMs', which is mandatory in version " + _version);
        }
        _object.throttleTimeMs = MessageUtil.jsonNodeToInt(_throttleTimeMsNode, "AppendRecordsResponseData");
        JsonNode _errorCodeNode = _node.get("errorCode");
        if (_errorCodeNode == null) {
            throw new RuntimeException("AppendRecordsResponseData: unable to locate field 'errorCode', which is mandatory in version " + _version);
        }
        _object.errorCode = MessageUtil.jsonNodeToShort(_errorCodeNode, "AppendRecordsResponseData");
        JsonNode _topicsNode = _node.get("topics");
        if (_topicsNode == null) {
            throw new RuntimeException("AppendRecordsResponseData: unable to locate field 'topics', which is mandatory in version " + _version);
        }
        if (!_topicsNode.isArray()) {
            throw new RuntimeException("AppendRecordsResponseData expected a JSON array, but got " + _node.getNodeType());
        }
        ArrayList<AppendRecordsResponseData.TopicData> _collection = new ArrayList<AppendRecordsResponseData.TopicData>(_topicsNode.size());
        _object.topics = _collection;
        for (JsonNode _element : _topicsNode) {
            _collection.add(TopicDataJsonConverter.read(_element, _version));
        }
        return _object;
    }

    public static JsonNode write(AppendRecordsResponseData _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        _node.set("throttleTimeMs", (JsonNode)new IntNode(_object.throttleTimeMs));
        _node.set("errorCode", (JsonNode)new ShortNode(_object.errorCode));
        ArrayNode _topicsArray = new ArrayNode(JsonNodeFactory.instance);
        for (AppendRecordsResponseData.TopicData _element : _object.topics) {
            _topicsArray.add(TopicDataJsonConverter.write(_element, _version, _serializeRecords));
        }
        _node.set("topics", (JsonNode)_topicsArray);
        return _node;
    }

    public static JsonNode write(AppendRecordsResponseData _object, short _version) {
        return AppendRecordsResponseDataJsonConverter.write(_object, _version, true);
    }

    public static class TopicDataJsonConverter {
        public static AppendRecordsResponseData.TopicData read(JsonNode _node, short _version) {
            AppendRecordsResponseData.TopicData _object = new AppendRecordsResponseData.TopicData();
            JsonNode _topicIdNode = _node.get("topicId");
            if (_topicIdNode == null) {
                throw new RuntimeException("TopicData: unable to locate field 'topicId', which is mandatory in version " + _version);
            }
            if (!_topicIdNode.isTextual()) {
                throw new RuntimeException("TopicData expected a JSON string type, but got " + _node.getNodeType());
            }
            _object.topicId = Uuid.fromString(_topicIdNode.asText());
            JsonNode _partitionsNode = _node.get("partitions");
            if (_partitionsNode == null) {
                throw new RuntimeException("TopicData: unable to locate field 'partitions', which is mandatory in version " + _version);
            }
            if (!_partitionsNode.isArray()) {
                throw new RuntimeException("TopicData expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<AppendRecordsResponseData.PartitionData> _collection = new ArrayList<AppendRecordsResponseData.PartitionData>(_partitionsNode.size());
            _object.partitions = _collection;
            for (JsonNode _element : _partitionsNode) {
                _collection.add(PartitionDataJsonConverter.read(_element, _version));
            }
            return _object;
        }

        public static JsonNode write(AppendRecordsResponseData.TopicData _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("topicId", (JsonNode)new TextNode(_object.topicId.toString()));
            ArrayNode _partitionsArray = new ArrayNode(JsonNodeFactory.instance);
            for (AppendRecordsResponseData.PartitionData _element : _object.partitions) {
                _partitionsArray.add(PartitionDataJsonConverter.write(_element, _version, _serializeRecords));
            }
            _node.set("partitions", (JsonNode)_partitionsArray);
            return _node;
        }

        public static JsonNode write(AppendRecordsResponseData.TopicData _object, short _version) {
            return TopicDataJsonConverter.write(_object, _version, true);
        }
    }

    public static class PartitionDataJsonConverter {
        public static AppendRecordsResponseData.PartitionData read(JsonNode _node, short _version) {
            AppendRecordsResponseData.PartitionData _object = new AppendRecordsResponseData.PartitionData();
            JsonNode _partitionIndexNode = _node.get("partitionIndex");
            if (_partitionIndexNode == null) {
                throw new RuntimeException("PartitionData: unable to locate field 'partitionIndex', which is mandatory in version " + _version);
            }
            _object.partitionIndex = MessageUtil.jsonNodeToInt(_partitionIndexNode, "PartitionData");
            JsonNode _errorCodeNode = _node.get("errorCode");
            if (_errorCodeNode == null) {
                throw new RuntimeException("PartitionData: unable to locate field 'errorCode', which is mandatory in version " + _version);
            }
            _object.errorCode = MessageUtil.jsonNodeToShort(_errorCodeNode, "PartitionData");
            JsonNode _logEndOffsetNode = _node.get("logEndOffset");
            if (_logEndOffsetNode == null) {
                throw new RuntimeException("PartitionData: unable to locate field 'logEndOffset', which is mandatory in version " + _version);
            }
            _object.logEndOffset = MessageUtil.jsonNodeToLong(_logEndOffsetNode, "PartitionData");
            JsonNode _logStartOffsetNode = _node.get("logStartOffset");
            _object.logStartOffset = _logStartOffsetNode == null ? -1L : MessageUtil.jsonNodeToLong(_logStartOffsetNode, "PartitionData");
            return _object;
        }

        public static JsonNode write(AppendRecordsResponseData.PartitionData _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("partitionIndex", (JsonNode)new IntNode(_object.partitionIndex));
            _node.set("errorCode", (JsonNode)new ShortNode(_object.errorCode));
            _node.set("logEndOffset", (JsonNode)new LongNode(_object.logEndOffset));
            if (_object.logStartOffset != -1L) {
                _node.set("logStartOffset", (JsonNode)new LongNode(_object.logStartOffset));
            }
            return _node;
        }

        public static JsonNode write(AppendRecordsResponseData.PartitionData _object, short _version) {
            return PartitionDataJsonConverter.write(_object, _version, true);
        }
    }
}

