/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.clients.consumer.internals.ConsumerInterceptors;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.FencedInstanceIdException;

public class OffsetCommitCallbackInvoker {
    private final ConsumerInterceptors<?, ?> interceptors;
    private boolean hasFencedException = false;
    private final BlockingQueue<OffsetCommitCallbackTask> callbackQueue = new LinkedBlockingQueue<OffsetCommitCallbackTask>();

    OffsetCommitCallbackInvoker(ConsumerInterceptors<?, ?> interceptors) {
        this.interceptors = interceptors;
    }

    public void enqueueInterceptorInvocation(Map<TopicPartition, OffsetAndMetadata> offsets) {
        if (!this.interceptors.isEmpty()) {
            this.callbackQueue.add(new OffsetCommitCallbackTask((offsetsParam, exception) -> this.interceptors.onCommit(offsetsParam), offsets, null));
        }
    }

    public void enqueueUserCallbackInvocation(OffsetCommitCallback callback, Map<TopicPartition, OffsetAndMetadata> offsets, Exception exception) {
        this.callbackQueue.add(new OffsetCommitCallbackTask(callback, offsets, exception));
    }

    public void executeCallbacks() {
        while (!this.callbackQueue.isEmpty()) {
            OffsetCommitCallbackTask task = (OffsetCommitCallbackTask)this.callbackQueue.poll();
            if (task == null) continue;
            if (task.exception instanceof FencedInstanceIdException) {
                this.hasFencedException = true;
            }
            task.callback.onComplete(task.offsets, task.exception);
        }
    }

    public boolean hasFencedException() {
        return this.hasFencedException;
    }

    private static class OffsetCommitCallbackTask {
        public final Map<TopicPartition, OffsetAndMetadata> offsets;
        public final Exception exception;
        public final OffsetCommitCallback callback;

        public OffsetCommitCallbackTask(OffsetCommitCallback callback, Map<TopicPartition, OffsetAndMetadata> offsets, Exception exception) {
            this.offsets = offsets;
            this.exception = exception;
            this.callback = callback;
        }
    }
}

