/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.message.DescribeTopicPartitionsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractResponse;

public class DescribeTopicPartitionsResponse
extends AbstractResponse {
    private final DescribeTopicPartitionsResponseData data;

    public DescribeTopicPartitionsResponse(DescribeTopicPartitionsResponseData data) {
        super(ApiKeys.DESCRIBE_TOPIC_PARTITIONS);
        this.data = data;
    }

    @Override
    public DescribeTopicPartitionsResponseData data() {
        return this.data;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return true;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> errorCounts = new HashMap<Errors, Integer>();
        this.data.topics().forEach(topicResponse -> {
            topicResponse.partitions().forEach(p -> this.updateErrorCounts(errorCounts, Errors.forCode(p.errorCode())));
            this.updateErrorCounts(errorCounts, Errors.forCode(topicResponse.errorCode()));
        });
        return errorCounts;
    }

    public static DescribeTopicPartitionsResponse prepareResponse(int throttleTimeMs, List<DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopic> topics) {
        DescribeTopicPartitionsResponseData responseData = new DescribeTopicPartitionsResponseData();
        responseData.setThrottleTimeMs(throttleTimeMs);
        topics.forEach(topicResponse -> responseData.topics().add(topicResponse));
        return new DescribeTopicPartitionsResponse(responseData);
    }

    public static DescribeTopicPartitionsResponse parse(ByteBuffer buffer, short version, MessageContext context) {
        return new DescribeTopicPartitionsResponse(new DescribeTopicPartitionsResponseData(new ByteBufferAccessor(buffer), version, context));
    }
}

