/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.security.oauthbearer;

public class ValidationUtils {
    public static String sanitizeString(String name, String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("The value for %s must be non-null", name));
        }
        if (value.isEmpty()) {
            throw new IllegalArgumentException(String.format("The value for %s must be non-empty", name));
        }
        if ((value = value.trim()).isEmpty()) {
            throw new IllegalArgumentException(String.format("The value for %s must not contain only whitespace", name));
        }
        return value;
    }

    public static Integer sanitizeInteger(String name, Integer value, Integer min) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("The value for %s must be non-null", name));
        }
        if (value < min) {
            throw new IllegalArgumentException(String.format("The value for %s must not be less than %d", name, min));
        }
        return value;
    }
}

