/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.Bytes;

public class SaslAuthenticateRequestData
implements ApiMessage {
    byte[] authBytes;
    String networkId;
    String environmentId;
    short networkType;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema[] SCHEMAS;
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 2;

    public SaslAuthenticateRequestData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public SaslAuthenticateRequestData() {
        this.authBytes = Bytes.EMPTY;
        this.networkId = null;
        this.environmentId = null;
        this.networkType = 0;
    }

    @Override
    public short apiKey() {
        return 36;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 2;
    }

    @Override
    public final void read(Readable _readable, short _version, MessageContext _context) {
        int length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : _readable.readInt();
        if (length < 0) {
            throw new RuntimeException("non-nullable field authBytes was serialized as null");
        }
        byte[] newBytes = _readable.readArray(length);
        this.authBytes = newBytes;
        this.networkId = null;
        this.environmentId = null;
        this.networkType = 0;
        this._unknownTaggedFields = null;
        if (_version >= 2) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            block5: for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    case 10000: {
                        int length2 = _readable.readUnsignedVarint() - 1;
                        if (length2 < 0) {
                            this.networkId = null;
                            continue block5;
                        }
                        if (length2 > Short.MAX_VALUE) {
                            throw new RuntimeException("string field networkId had invalid length " + length2);
                        }
                        this.networkId = _readable.readString(length2);
                        continue block5;
                    }
                    case 10001: {
                        int length2 = _readable.readUnsignedVarint() - 1;
                        if (length2 < 0) {
                            this.environmentId = null;
                            continue block5;
                        }
                        if (length2 > Short.MAX_VALUE) {
                            throw new RuntimeException("string field environmentId had invalid length " + length2);
                        }
                        this.environmentId = _readable.readString(length2);
                        continue block5;
                    }
                    case 10002: {
                        this.networkType = _readable.readShort();
                        continue block5;
                    }
                    default: {
                        this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                    }
                }
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        if (_version >= 2) {
            _writable.writeUnsignedVarint(this.authBytes.length + 1);
        } else {
            _writable.writeInt(this.authBytes.length);
        }
        _writable.writeByteArray(this.authBytes);
        if (_version >= 2) {
            if (this.networkId != null) {
                ++_numTaggedFields;
            }
        } else if (this.networkId != null) {
            throw new UnsupportedVersionException("Attempted to write a non-default networkId at version " + _version);
        }
        if (_version >= 2) {
            if (this.environmentId != null) {
                ++_numTaggedFields;
            }
        } else if (this.environmentId != null) {
            throw new UnsupportedVersionException("Attempted to write a non-default environmentId at version " + _version);
        }
        if (_version >= 2) {
            if (this.networkType != 0) {
                ++_numTaggedFields;
            }
        } else if (this.networkType != 0) {
            throw new UnsupportedVersionException("Attempted to write a non-default networkType at version " + _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 2) {
            byte[] _stringBytes;
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, 10000);
            if (this.networkId != null) {
                _writable.writeUnsignedVarint(10000);
                _stringBytes = _cache.getSerializedValue(this.networkId);
                _writable.writeUnsignedVarint(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
                _writable.writeByteArray(_stringBytes);
            }
            if (this.environmentId != null) {
                _writable.writeUnsignedVarint(10001);
                _stringBytes = _cache.getSerializedValue(this.environmentId);
                _writable.writeUnsignedVarint(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
                _writable.writeByteArray(_stringBytes);
            }
            if (this.networkType != 0) {
                _writable.writeUnsignedVarint(10002);
                _writable.writeUnsignedVarint(2);
                _writable.writeShort(this.networkType);
            }
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _stringPrefixSize;
        byte[] _stringBytes;
        int _numTaggedFields = 0;
        _size.addBytes(this.authBytes.length);
        if (_version >= 2) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.authBytes.length + 1));
        } else {
            _size.addBytes(4);
        }
        if (_version >= 2 && this.networkId != null) {
            ++_numTaggedFields;
            _size.addBytes(2);
            _stringBytes = this.networkId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'networkId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.networkId, _stringBytes);
            _stringPrefixSize = ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1);
            _size.addBytes(_stringBytes.length + _stringPrefixSize + ByteUtils.sizeOfUnsignedVarint(_stringPrefixSize + _stringBytes.length));
        }
        if (_version >= 2 && this.environmentId != null) {
            ++_numTaggedFields;
            _size.addBytes(2);
            _stringBytes = this.environmentId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'environmentId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.environmentId, _stringBytes);
            _stringPrefixSize = ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1);
            _size.addBytes(_stringBytes.length + _stringPrefixSize + ByteUtils.sizeOfUnsignedVarint(_stringPrefixSize + _stringBytes.length));
        }
        if (_version >= 2 && this.networkType != 0) {
            ++_numTaggedFields;
            _size.addBytes(2);
            _size.addBytes(1);
            _size.addBytes(2);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_version >= 2) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SaslAuthenticateRequestData)) {
            return false;
        }
        SaslAuthenticateRequestData other = (SaslAuthenticateRequestData)obj;
        if (!Arrays.equals(this.authBytes, other.authBytes)) {
            return false;
        }
        if (this.networkId == null ? other.networkId != null : !this.networkId.equals(other.networkId)) {
            return false;
        }
        if (this.environmentId == null ? other.environmentId != null : !this.environmentId.equals(other.environmentId)) {
            return false;
        }
        if (this.networkType != other.networkType) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + Arrays.hashCode(this.authBytes);
        hashCode = 31 * hashCode + (this.networkId == null ? 0 : this.networkId.hashCode());
        hashCode = 31 * hashCode + (this.environmentId == null ? 0 : this.environmentId.hashCode());
        hashCode = 31 * hashCode + this.networkType;
        return hashCode;
    }

    @Override
    public SaslAuthenticateRequestData duplicate() {
        SaslAuthenticateRequestData _duplicate = new SaslAuthenticateRequestData();
        _duplicate.authBytes = MessageUtil.duplicate(this.authBytes);
        _duplicate.networkId = this.networkId == null ? null : this.networkId;
        _duplicate.environmentId = this.environmentId == null ? null : this.environmentId;
        _duplicate.networkType = this.networkType;
        return _duplicate;
    }

    public String toString() {
        return "SaslAuthenticateRequestData(authBytes=" + Arrays.toString(this.authBytes) + ", networkId=" + (this.networkId == null ? "null" : "'" + this.networkId.toString() + "'") + ", environmentId=" + (this.environmentId == null ? "null" : "'" + this.environmentId.toString() + "'") + ", networkType=" + this.networkType + ")";
    }

    public byte[] authBytes() {
        return this.authBytes;
    }

    public String networkId() {
        return this.networkId;
    }

    public String environmentId() {
        return this.environmentId;
    }

    public short networkType() {
        return this.networkType;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public SaslAuthenticateRequestData setAuthBytes(byte[] v) {
        this.authBytes = v;
        return this;
    }

    public SaslAuthenticateRequestData setNetworkId(String v) {
        this.networkId = v;
        return this;
    }

    public SaslAuthenticateRequestData setEnvironmentId(String v) {
        this.environmentId = v;
        return this;
    }

    public SaslAuthenticateRequestData setNetworkType(short v) {
        this.networkType = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field("auth_bytes", Type.BYTES, "The SASL authentication bytes from the client, as defined by the SASL mechanism."));
        SCHEMA_2 = new Schema(new Field("auth_bytes", Type.COMPACT_BYTES, "The SASL authentication bytes from the client, as defined by the SASL mechanism."), Field.TaggedFieldsSection.of(10000, new Field("network_id", Type.COMPACT_NULLABLE_STRING, "The network ID originating the authenticate request."), 10001, new Field("environment_id", Type.COMPACT_NULLABLE_STRING, "The environment ID originating the authenticate request."), 10002, new Field("network_type", Type.INT16, "The network type originating the authenticate request.")));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
    }
}

