/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.EntityType;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.ImplicitLinkedHashMultiCollection;

public class CreateTopicsRequestData
implements ApiMessage {
    CreatableTopicCollection topics;
    int timeoutMs;
    boolean validateOnly;
    boolean isClusterLinkingValidatedByBroker;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("topics", new ArrayOf(CreatableTopic.SCHEMA_0), "The topics to create."), new Field("timeout_ms", Type.INT32, "How long to wait in milliseconds before timing out the request."));
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema SCHEMA_5;
    public static final Schema SCHEMA_6;
    public static final Schema SCHEMA_7;
    public static final Schema[] SCHEMAS;
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 7;

    public CreateTopicsRequestData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public CreateTopicsRequestData() {
        this.topics = new CreatableTopicCollection(0);
        this.timeoutMs = 60000;
        this.validateOnly = false;
        this.isClusterLinkingValidatedByBroker = false;
    }

    @Override
    public short apiKey() {
        return 19;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 7;
    }

    @Override
    public final void read(Readable _readable, short _version, MessageContext _context) {
        int i;
        CreatableTopicCollection newCollection;
        int arrayLength;
        if (_version >= 5) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field topics was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new CreatableTopicCollection(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new CreatableTopic(_readable, _version, _context));
            }
            this.topics = newCollection;
        } else {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field topics was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new CreatableTopicCollection(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new CreatableTopic(_readable, _version, _context));
            }
            this.topics = newCollection;
        }
        this.timeoutMs = _readable.readInt();
        this.validateOnly = _version >= 1 ? _readable.readByte() != 0 : false;
        this.isClusterLinkingValidatedByBroker = false;
        this._unknownTaggedFields = null;
        if (_version >= 5) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            block5: for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    case 10000: {
                        this.isClusterLinkingValidatedByBroker = _readable.readByte() != 0;
                        continue block5;
                    }
                    default: {
                        this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                    }
                }
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        if (_version >= 5) {
            _writable.writeUnsignedVarint(this.topics.size() + 1);
            for (CreatableTopic topicsElement : this.topics) {
                topicsElement.write(_writable, _cache, _version, _context);
            }
        } else {
            _writable.writeInt(this.topics.size());
            for (CreatableTopic topicsElement : this.topics) {
                topicsElement.write(_writable, _cache, _version, _context);
            }
        }
        _writable.writeInt(this.timeoutMs);
        if (_version >= 1) {
            _writable.writeByte(this.validateOnly ? (byte)1 : 0);
        } else if (this.validateOnly) {
            throw new UnsupportedVersionException("Attempted to write a non-default validateOnly at version " + _version);
        }
        if (_version >= 5) {
            if (this.isClusterLinkingValidatedByBroker) {
                ++_numTaggedFields;
            }
        } else if (this.isClusterLinkingValidatedByBroker) {
            throw new UnsupportedVersionException("Attempted to write a non-default isClusterLinkingValidatedByBroker at version " + _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 5) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, 10000);
            if (this.isClusterLinkingValidatedByBroker) {
                _writable.writeUnsignedVarint(10000);
                _writable.writeUnsignedVarint(1);
                _writable.writeByte(this.isClusterLinkingValidatedByBroker ? (byte)1 : 0);
            }
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        if (_version >= 5) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.topics.size() + 1));
        } else {
            _size.addBytes(4);
        }
        for (CreatableTopic topicsElement : this.topics) {
            topicsElement.addSize(_size, _cache, _version, _context);
        }
        _size.addBytes(4);
        if (_version >= 1) {
            _size.addBytes(1);
        }
        if (_version >= 5 && this.isClusterLinkingValidatedByBroker) {
            ++_numTaggedFields;
            _size.addBytes(2);
            _size.addBytes(1);
            _size.addBytes(1);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_version >= 5) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CreateTopicsRequestData)) {
            return false;
        }
        CreateTopicsRequestData other = (CreateTopicsRequestData)obj;
        if (this.topics == null ? other.topics != null : !this.topics.equals(other.topics)) {
            return false;
        }
        if (this.timeoutMs != other.timeoutMs) {
            return false;
        }
        if (this.validateOnly != other.validateOnly) {
            return false;
        }
        if (this.isClusterLinkingValidatedByBroker != other.isClusterLinkingValidatedByBroker) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        hashCode = 31 * hashCode + this.timeoutMs;
        hashCode = 31 * hashCode + (this.validateOnly ? 1231 : 1237);
        hashCode = 31 * hashCode + (this.isClusterLinkingValidatedByBroker ? 1231 : 1237);
        return hashCode;
    }

    @Override
    public CreateTopicsRequestData duplicate() {
        CreateTopicsRequestData _duplicate = new CreateTopicsRequestData();
        CreatableTopicCollection newTopics = new CreatableTopicCollection(this.topics.size());
        for (CreatableTopic _element : this.topics) {
            newTopics.add(_element.duplicate());
        }
        _duplicate.topics = newTopics;
        _duplicate.timeoutMs = this.timeoutMs;
        _duplicate.validateOnly = this.validateOnly;
        _duplicate.isClusterLinkingValidatedByBroker = this.isClusterLinkingValidatedByBroker;
        return _duplicate;
    }

    public String toString() {
        return "CreateTopicsRequestData(topics=" + MessageUtil.deepToString(this.topics.iterator()) + ", timeoutMs=" + this.timeoutMs + ", validateOnly=" + (this.validateOnly ? "true" : "false") + ", isClusterLinkingValidatedByBroker=" + (this.isClusterLinkingValidatedByBroker ? "true" : "false") + ")";
    }

    public CreatableTopicCollection topics() {
        return this.topics;
    }

    public int timeoutMs() {
        return this.timeoutMs;
    }

    public boolean validateOnly() {
        return this.validateOnly;
    }

    public boolean isClusterLinkingValidatedByBroker() {
        return this.isClusterLinkingValidatedByBroker;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public CreateTopicsRequestData setTopics(CreatableTopicCollection v) {
        this.topics = v;
        return this;
    }

    public CreateTopicsRequestData setTimeoutMs(int v) {
        this.timeoutMs = v;
        return this;
    }

    public CreateTopicsRequestData setValidateOnly(boolean v) {
        this.validateOnly = v;
        return this;
    }

    public CreateTopicsRequestData setIsClusterLinkingValidatedByBroker(boolean v) {
        this.isClusterLinkingValidatedByBroker = v;
        return this;
    }

    static {
        SCHEMA_4 = SCHEMA_3 = (SCHEMA_2 = (SCHEMA_1 = new Schema(new Field("topics", new ArrayOf(CreatableTopic.SCHEMA_0), "The topics to create."), new Field("timeout_ms", Type.INT32, "How long to wait in milliseconds before timing out the request."), new Field("validate_only", Type.BOOLEAN, "If true, check that the topics can be created as specified, but don't create anything."))));
        SCHEMA_6 = SCHEMA_5 = new Schema(new Field("topics", new CompactArrayOf(CreatableTopic.SCHEMA_5), "The topics to create."), new Field("timeout_ms", Type.INT32, "How long to wait in milliseconds before timing out the request."), new Field("validate_only", Type.BOOLEAN, "If true, check that the topics can be created as specified, but don't create anything."), Field.TaggedFieldsSection.of(10000, new Field("is_cluster_linking_validated_by_broker", Type.BOOLEAN, "If true, this request was created by a ZK broker in migration mode. This is used to prevent a second validation by a ZK controller.")));
        SCHEMA_7 = new Schema(new Field("topics", new CompactArrayOf(CreatableTopic.SCHEMA_7), "The topics to create."), new Field("timeout_ms", Type.INT32, "How long to wait in milliseconds before timing out the request."), new Field("validate_only", Type.BOOLEAN, "If true, check that the topics can be created as specified, but don't create anything."), Field.TaggedFieldsSection.of(10000, new Field("is_cluster_linking_validated_by_broker", Type.BOOLEAN, "If true, this request was created by a ZK broker in migration mode. This is used to prevent a second validation by a ZK controller.")));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7};
    }

    public static class CreatableTopicCollection
    extends ImplicitLinkedHashMultiCollection<CreatableTopic> {
        public CreatableTopicCollection() {
        }

        public CreatableTopicCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public CreatableTopicCollection(Iterator<CreatableTopic> iterator) {
            super(iterator);
        }

        @Override
        public CreatableTopic find(String name) {
            CreatableTopic _key = new CreatableTopic();
            _key.setName(name);
            return this.find(_key);
        }

        @Override
        public List<CreatableTopic> findAll(String name) {
            CreatableTopic _key = new CreatableTopic();
            _key.setName(name);
            return this.findAll(_key);
        }

        public CreatableTopicCollection duplicate() {
            CreatableTopicCollection _duplicate = new CreatableTopicCollection(this.size());
            for (CreatableTopic _element : this) {
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class CreateableTopicConfigCollection
    extends ImplicitLinkedHashMultiCollection<CreateableTopicConfig> {
        public CreateableTopicConfigCollection() {
        }

        public CreateableTopicConfigCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public CreateableTopicConfigCollection(Iterator<CreateableTopicConfig> iterator) {
            super(iterator);
        }

        @Override
        public CreateableTopicConfig find(String name) {
            CreateableTopicConfig _key = new CreateableTopicConfig();
            _key.setName(name);
            return this.find(_key);
        }

        @Override
        public List<CreateableTopicConfig> findAll(String name) {
            CreateableTopicConfig _key = new CreateableTopicConfig();
            _key.setName(name);
            return this.findAll(_key);
        }

        public CreateableTopicConfigCollection duplicate() {
            CreateableTopicConfigCollection _duplicate = new CreateableTopicConfigCollection(this.size());
            for (CreateableTopicConfig _element : this) {
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class CreateableTopicConfig
    implements Message,
    ImplicitLinkedHashCollection.Element {
        String name;
        String value;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema SCHEMA_7;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 7;

        public CreateableTopicConfig(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
            this.prev = -2;
            this.next = -2;
        }

        public CreateableTopicConfig() {
            this.name = "";
            this.value = "";
            this.prev = -2;
            this.next = -2;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 7;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 7) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of CreateableTopicConfig");
            }
            int length = _version >= 5 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            length = _version >= 5 ? _readable.readUnsignedVarint() - 1 : (int)_readable.readShort();
            if (length < 0) {
                this.value = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field value had invalid length " + length);
                }
                this.value = _readable.readString(length);
            }
            this._unknownTaggedFields = null;
            if (_version >= 5) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue(this.name);
            if (_version >= 5) {
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
            } else {
                _writable.writeShort((short)_stringBytes.length);
            }
            _writable.writeByteArray(_stringBytes);
            if (this.value == null) {
                if (_version >= 5) {
                    _writable.writeUnsignedVarint(0);
                } else {
                    _writable.writeShort((short)-1);
                }
            } else {
                _stringBytes = _cache.getSerializedValue(this.value);
                if (_version >= 5) {
                    _writable.writeUnsignedVarint(_stringBytes.length + 1);
                } else {
                    _writable.writeShort((short)_stringBytes.length);
                }
                _writable.writeByteArray(_stringBytes);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 5) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 7) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of CreateableTopicConfig");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.name, _stringBytes);
            if (_version >= 5) {
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            } else {
                _size.addBytes(_stringBytes.length + 2);
            }
            if (this.value == null) {
                if (_version >= 5) {
                    _size.addBytes(1);
                } else {
                    _size.addBytes(2);
                }
            } else {
                _stringBytes = this.value.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'value' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.value, _stringBytes);
                if (_version >= 5) {
                    _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
                } else {
                    _size.addBytes(_stringBytes.length + 2);
                }
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 5) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof CreateableTopicConfig)) {
                return false;
            }
            CreateableTopicConfig other = (CreateableTopicConfig)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CreateableTopicConfig)) {
                return false;
            }
            CreateableTopicConfig other = (CreateableTopicConfig)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            return hashCode;
        }

        @Override
        public CreateableTopicConfig duplicate() {
            CreateableTopicConfig _duplicate = new CreateableTopicConfig();
            _duplicate.name = this.name;
            _duplicate.value = this.value == null ? null : this.value;
            return _duplicate;
        }

        public String toString() {
            return "CreateableTopicConfig(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", value=" + (this.value == null ? "null" : "'" + this.value.toString() + "'") + ")";
        }

        public String name() {
            return this.name;
        }

        public String value() {
            return this.value;
        }

        @Override
        public int next() {
            return this.next;
        }

        @Override
        public int prev() {
            return this.prev;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public CreateableTopicConfig setName(String v) {
            this.name = v;
            return this;
        }

        public CreateableTopicConfig setValue(String v) {
            this.value = v;
            return this;
        }

        @Override
        public void setNext(int v) {
            this.next = v;
        }

        @Override
        public void setPrev(int v) {
            this.prev = v;
        }

        static {
            SCHEMA_4 = SCHEMA_3 = (SCHEMA_2 = (SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("name", Type.STRING, "The configuration name."), new Field("value", Type.NULLABLE_STRING, "The configuration value.")))));
            SCHEMA_7 = SCHEMA_6 = (SCHEMA_5 = new Schema(new Field("name", Type.COMPACT_STRING, "The configuration name."), new Field("value", Type.COMPACT_NULLABLE_STRING, "The configuration value."), Field.TaggedFieldsSection.of(new Object[0])));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7};
        }
    }

    public static class CreatableReplicaAssignmentCollection
    extends ImplicitLinkedHashMultiCollection<CreatableReplicaAssignment> {
        public CreatableReplicaAssignmentCollection() {
        }

        public CreatableReplicaAssignmentCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public CreatableReplicaAssignmentCollection(Iterator<CreatableReplicaAssignment> iterator) {
            super(iterator);
        }

        @Override
        public CreatableReplicaAssignment find(int partitionIndex) {
            CreatableReplicaAssignment _key = new CreatableReplicaAssignment();
            _key.setPartitionIndex(partitionIndex);
            return this.find(_key);
        }

        @Override
        public List<CreatableReplicaAssignment> findAll(int partitionIndex) {
            CreatableReplicaAssignment _key = new CreatableReplicaAssignment();
            _key.setPartitionIndex(partitionIndex);
            return this.findAll(_key);
        }

        public CreatableReplicaAssignmentCollection duplicate() {
            CreatableReplicaAssignmentCollection _duplicate = new CreatableReplicaAssignmentCollection(this.size());
            for (CreatableReplicaAssignment _element : this) {
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class CreatableReplicaAssignment
    implements Message,
    ImplicitLinkedHashCollection.Element {
        int partitionIndex;
        List<Integer> brokerIds;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema SCHEMA_7;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 7;

        public CreatableReplicaAssignment(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
            this.prev = -2;
            this.next = -2;
        }

        public CreatableReplicaAssignment() {
            this.partitionIndex = 0;
            this.brokerIds = new ArrayList<Integer>(0);
            this.prev = -2;
            this.next = -2;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 7;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 7) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of CreatableReplicaAssignment");
            }
            this.partitionIndex = _readable.readInt();
            int arrayLength = _version >= 5 ? _readable.readUnsignedVarint() - 1 : _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field brokerIds was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<Integer> newCollection = new ArrayList<Integer>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readInt());
            }
            this.brokerIds = newCollection;
            this._unknownTaggedFields = null;
            if (_version >= 5) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.partitionIndex);
            if (_version >= 5) {
                _writable.writeUnsignedVarint(this.brokerIds.size() + 1);
            } else {
                _writable.writeInt(this.brokerIds.size());
            }
            for (Integer brokerIdsElement : this.brokerIds) {
                _writable.writeInt(brokerIdsElement);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 5) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 7) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of CreatableReplicaAssignment");
            }
            _size.addBytes(4);
            if (_version >= 5) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.brokerIds.size() + 1));
            } else {
                _size.addBytes(4);
            }
            _size.addBytes(this.brokerIds.size() * 4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 5) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof CreatableReplicaAssignment)) {
                return false;
            }
            CreatableReplicaAssignment other = (CreatableReplicaAssignment)obj;
            return this.partitionIndex == other.partitionIndex;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CreatableReplicaAssignment)) {
                return false;
            }
            CreatableReplicaAssignment other = (CreatableReplicaAssignment)obj;
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            if (this.brokerIds == null ? other.brokerIds != null : !this.brokerIds.equals(other.brokerIds)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partitionIndex;
            return hashCode;
        }

        @Override
        public CreatableReplicaAssignment duplicate() {
            CreatableReplicaAssignment _duplicate = new CreatableReplicaAssignment();
            _duplicate.partitionIndex = this.partitionIndex;
            ArrayList<Integer> newBrokerIds = new ArrayList<Integer>(this.brokerIds.size());
            for (Integer _element : this.brokerIds) {
                newBrokerIds.add(_element);
            }
            _duplicate.brokerIds = newBrokerIds;
            return _duplicate;
        }

        public String toString() {
            return "CreatableReplicaAssignment(partitionIndex=" + this.partitionIndex + ", brokerIds=" + MessageUtil.deepToString(this.brokerIds.iterator()) + ")";
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public List<Integer> brokerIds() {
            return this.brokerIds;
        }

        @Override
        public int next() {
            return this.next;
        }

        @Override
        public int prev() {
            return this.prev;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public CreatableReplicaAssignment setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public CreatableReplicaAssignment setBrokerIds(List<Integer> v) {
            this.brokerIds = v;
            return this;
        }

        @Override
        public void setNext(int v) {
            this.next = v;
        }

        @Override
        public void setPrev(int v) {
            this.prev = v;
        }

        static {
            SCHEMA_4 = SCHEMA_3 = (SCHEMA_2 = (SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("broker_ids", new ArrayOf(Type.INT32), "The brokers to place the partition on.")))));
            SCHEMA_7 = SCHEMA_6 = (SCHEMA_5 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("broker_ids", new CompactArrayOf(Type.INT32), "The brokers to place the partition on."), Field.TaggedFieldsSection.of(new Object[0])));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7};
        }
    }

    public static class CreatableTopic
    implements Message,
    ImplicitLinkedHashCollection.Element {
        String name;
        int numPartitions;
        short replicationFactor;
        CreatableReplicaAssignmentCollection assignments;
        CreateableTopicConfigCollection configs;
        String linkName;
        String mirrorTopic;
        Uuid sourceTopicId;
        long mirrorStartOffsetSpec;
        List<Long> mirrorStartOffsets;
        long stoppedSequenceNumber;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema SCHEMA_7;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 7;

        public CreatableTopic(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
            this.prev = -2;
            this.next = -2;
        }

        public CreatableTopic() {
            this.name = "";
            this.numPartitions = 0;
            this.replicationFactor = 0;
            this.assignments = new CreatableReplicaAssignmentCollection(0);
            this.configs = new CreateableTopicConfigCollection(0);
            this.linkName = null;
            this.mirrorTopic = null;
            this.sourceTopicId = Uuid.ZERO_UUID;
            this.mirrorStartOffsetSpec = Long.MIN_VALUE;
            this.mirrorStartOffsets = new ArrayList<Long>(0);
            this.stoppedSequenceNumber = 0L;
            this.prev = -2;
            this.next = -2;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 7;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            int i;
            ImplicitLinkedHashMultiCollection newCollection;
            int arrayLength;
            if (_version > 7) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of CreatableTopic");
            }
            int length = _version >= 5 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _context.read(EntityType.TOPIC_NAME, _readable.readString(length));
            this.numPartitions = _readable.readInt();
            this.replicationFactor = _readable.readShort();
            if (_version >= 5) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field assignments was serialized as null");
                }
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                newCollection = new CreatableReplicaAssignmentCollection(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new CreatableReplicaAssignment(_readable, _version, _context));
                }
                this.assignments = newCollection;
            } else {
                arrayLength = _readable.readInt();
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field assignments was serialized as null");
                }
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                newCollection = new CreatableReplicaAssignmentCollection(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new CreatableReplicaAssignment(_readable, _version, _context));
                }
                this.assignments = newCollection;
            }
            if (_version >= 5) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field configs was serialized as null");
                }
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                newCollection = new CreateableTopicConfigCollection(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new CreateableTopicConfig(_readable, _version, _context));
                }
                this.configs = newCollection;
            } else {
                arrayLength = _readable.readInt();
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field configs was serialized as null");
                }
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                newCollection = new CreateableTopicConfigCollection(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new CreateableTopicConfig(_readable, _version, _context));
                }
                this.configs = newCollection;
            }
            this.linkName = null;
            this.mirrorTopic = null;
            this.sourceTopicId = Uuid.ZERO_UUID;
            this.mirrorStartOffsetSpec = Long.MIN_VALUE;
            this.mirrorStartOffsets = new ArrayList<Long>(0);
            this.stoppedSequenceNumber = 0L;
            this._unknownTaggedFields = null;
            if (_version >= 5) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                block12: for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        case 10000: {
                            int length2 = _readable.readUnsignedVarint() - 1;
                            if (length2 < 0) {
                                this.linkName = null;
                                continue block12;
                            }
                            if (length2 > Short.MAX_VALUE) {
                                throw new RuntimeException("string field linkName had invalid length " + length2);
                            }
                            this.linkName = _context.read(EntityType.LINK_NAME, _readable.readString(length2));
                            continue block12;
                        }
                        case 10001: {
                            int length2 = _readable.readUnsignedVarint() - 1;
                            if (length2 < 0) {
                                this.mirrorTopic = null;
                                continue block12;
                            }
                            if (length2 > Short.MAX_VALUE) {
                                throw new RuntimeException("string field mirrorTopic had invalid length " + length2);
                            }
                            this.mirrorTopic = _context.read(EntityType.TOPIC_NAME, _readable.readString(length2));
                            continue block12;
                        }
                        case 10002: {
                            if (_version >= 7) {
                                this.sourceTopicId = _readable.readUuid();
                                continue block12;
                            }
                            throw new RuntimeException("Tag 10002 is not valid for version " + _version);
                        }
                        case 10003: {
                            if (_version >= 7) {
                                this.mirrorStartOffsetSpec = _readable.readLong();
                                continue block12;
                            }
                            throw new RuntimeException("Tag 10003 is not valid for version " + _version);
                        }
                        case 10004: {
                            if (_version >= 7) {
                                int arrayLength2 = _readable.readUnsignedVarint() - 1;
                                if (arrayLength2 < 0) {
                                    this.mirrorStartOffsets = null;
                                    continue block12;
                                }
                                if (arrayLength2 > _readable.remaining()) {
                                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength2 + ", but there are only " + _readable.remaining() + " bytes remaining.");
                                }
                                ArrayList<Long> newCollection2 = new ArrayList<Long>(arrayLength2);
                                for (int i2 = 0; i2 < arrayLength2; ++i2) {
                                    newCollection2.add(_readable.readLong());
                                }
                                this.mirrorStartOffsets = newCollection2;
                                continue block12;
                            }
                            throw new RuntimeException("Tag 10004 is not valid for version " + _version);
                        }
                        case 10005: {
                            if (_version >= 7) {
                                this.stoppedSequenceNumber = _readable.readLong();
                                continue block12;
                            }
                            throw new RuntimeException("Tag 10005 is not valid for version " + _version);
                        }
                        default: {
                            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                        }
                    }
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            CreatableReplicaAssignment assignmentsElement;
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.name);
            if (_version >= 5) {
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            } else {
                _writable.writeShort((short)((byte[])_stringBytes).length);
            }
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeInt(this.numPartitions);
            _writable.writeShort(this.replicationFactor);
            if (_version >= 5) {
                _writable.writeUnsignedVarint(this.assignments.size() + 1);
                _stringBytes = this.assignments.iterator();
                while (_stringBytes.hasNext()) {
                    assignmentsElement = (CreatableReplicaAssignment)_stringBytes.next();
                    assignmentsElement.write(_writable, _cache, _version, _context);
                }
            } else {
                _writable.writeInt(this.assignments.size());
                _stringBytes = this.assignments.iterator();
                while (_stringBytes.hasNext()) {
                    assignmentsElement = (CreatableReplicaAssignment)_stringBytes.next();
                    assignmentsElement.write(_writable, _cache, _version, _context);
                }
            }
            if (_version >= 5) {
                _writable.writeUnsignedVarint(this.configs.size() + 1);
                for (CreateableTopicConfig configsElement : this.configs) {
                    configsElement.write(_writable, _cache, _version, _context);
                }
            } else {
                _writable.writeInt(this.configs.size());
                for (CreateableTopicConfig configsElement : this.configs) {
                    configsElement.write(_writable, _cache, _version, _context);
                }
            }
            if (_version >= 5) {
                if (this.linkName != null) {
                    ++_numTaggedFields;
                }
            } else if (this.linkName != null) {
                throw new UnsupportedVersionException("Attempted to write a non-default linkName at version " + _version);
            }
            if (_version >= 5) {
                if (this.mirrorTopic != null) {
                    ++_numTaggedFields;
                }
            } else if (this.mirrorTopic != null) {
                throw new UnsupportedVersionException("Attempted to write a non-default mirrorTopic at version " + _version);
            }
            if (_version >= 7) {
                if (!this.sourceTopicId.equals(Uuid.ZERO_UUID)) {
                    ++_numTaggedFields;
                }
            } else if (!this.sourceTopicId.equals(Uuid.ZERO_UUID)) {
                throw new UnsupportedVersionException("Attempted to write a non-default sourceTopicId at version " + _version);
            }
            if (_version >= 7 && this.mirrorStartOffsetSpec != Long.MIN_VALUE) {
                ++_numTaggedFields;
            }
            if (_version >= 7) {
                if (this.mirrorStartOffsets == null || !this.mirrorStartOffsets.isEmpty()) {
                    ++_numTaggedFields;
                }
            } else if (this.mirrorStartOffsets == null || !this.mirrorStartOffsets.isEmpty()) {
                throw new UnsupportedVersionException("Attempted to write a non-default mirrorStartOffsets at version " + _version);
            }
            if (_version >= 7) {
                if (this.stoppedSequenceNumber != 0L) {
                    ++_numTaggedFields;
                }
            } else if (this.stoppedSequenceNumber != 0L) {
                throw new UnsupportedVersionException("Attempted to write a non-default stoppedSequenceNumber at version " + _version);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 5) {
                byte[] _stringBytes2;
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, 10000);
                if (this.linkName != null) {
                    _writable.writeUnsignedVarint(10000);
                    _stringBytes2 = _cache.getSerializedValue(this.linkName);
                    _writable.writeUnsignedVarint(_stringBytes2.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes2.length + 1));
                    _writable.writeUnsignedVarint(_stringBytes2.length + 1);
                    _writable.writeByteArray(_stringBytes2);
                }
                if (this.mirrorTopic != null) {
                    _writable.writeUnsignedVarint(10001);
                    _stringBytes2 = _cache.getSerializedValue(this.mirrorTopic);
                    _writable.writeUnsignedVarint(_stringBytes2.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes2.length + 1));
                    _writable.writeUnsignedVarint(_stringBytes2.length + 1);
                    _writable.writeByteArray(_stringBytes2);
                }
                if (_version >= 7 && !this.sourceTopicId.equals(Uuid.ZERO_UUID)) {
                    _writable.writeUnsignedVarint(10002);
                    _writable.writeUnsignedVarint(16);
                    _writable.writeUuid(this.sourceTopicId);
                }
                if (_version >= 7 && this.mirrorStartOffsetSpec != Long.MIN_VALUE) {
                    _writable.writeUnsignedVarint(10003);
                    _writable.writeUnsignedVarint(8);
                    _writable.writeLong(this.mirrorStartOffsetSpec);
                }
                if (_version >= 7) {
                    if (this.mirrorStartOffsets == null) {
                        _writable.writeUnsignedVarint(10004);
                        _writable.writeUnsignedVarint(1);
                        _writable.writeUnsignedVarint(0);
                    } else if (!this.mirrorStartOffsets.isEmpty()) {
                        _writable.writeUnsignedVarint(10004);
                        _writable.writeUnsignedVarint(_cache.getArraySizeInBytes(this.mirrorStartOffsets));
                        _writable.writeUnsignedVarint(this.mirrorStartOffsets.size() + 1);
                        for (Long mirrorStartOffsetsElement : this.mirrorStartOffsets) {
                            _writable.writeLong(mirrorStartOffsetsElement);
                        }
                    }
                }
                if (_version >= 7 && this.stoppedSequenceNumber != 0L) {
                    _writable.writeUnsignedVarint(10005);
                    _writable.writeUnsignedVarint(8);
                    _writable.writeLong(this.stoppedSequenceNumber);
                }
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 7) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of CreatableTopic");
            }
            Object _stringBytes = _context.write(EntityType.TOPIC_NAME, this.name).getBytes(StandardCharsets.UTF_8);
            if (((byte[])_stringBytes).length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.name, (byte[])_stringBytes);
            if (_version >= 5) {
                _size.addBytes(((byte[])_stringBytes).length + ByteUtils.sizeOfUnsignedVarint(((byte[])_stringBytes).length + 1));
            } else {
                _size.addBytes(((byte[])_stringBytes).length + 2);
            }
            _size.addBytes(4);
            _size.addBytes(2);
            if (_version >= 5) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.assignments.size() + 1));
            } else {
                _size.addBytes(4);
            }
            _stringBytes = this.assignments.iterator();
            while (_stringBytes.hasNext()) {
                CreatableReplicaAssignment assignmentsElement = (CreatableReplicaAssignment)_stringBytes.next();
                assignmentsElement.addSize(_size, _cache, _version, _context);
            }
            if (_version >= 5) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.configs.size() + 1));
            } else {
                _size.addBytes(4);
            }
            for (CreateableTopicConfig configsElement : this.configs) {
                configsElement.addSize(_size, _cache, _version, _context);
            }
            if (_version >= 5 && this.linkName != null) {
                ++_numTaggedFields;
                _size.addBytes(2);
                _stringBytes = _context.write(EntityType.LINK_NAME, this.linkName).getBytes(StandardCharsets.UTF_8);
                if (((byte[])_stringBytes).length > Short.MAX_VALUE) {
                    throw new RuntimeException("'linkName' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.linkName, (byte[])_stringBytes);
                int _stringPrefixSize = ByteUtils.sizeOfUnsignedVarint(((byte[])_stringBytes).length + 1);
                _size.addBytes(((byte[])_stringBytes).length + _stringPrefixSize + ByteUtils.sizeOfUnsignedVarint(_stringPrefixSize + ((byte[])_stringBytes).length));
            }
            if (_version >= 5 && this.mirrorTopic != null) {
                ++_numTaggedFields;
                _size.addBytes(2);
                _stringBytes = _context.write(EntityType.TOPIC_NAME, this.mirrorTopic).getBytes(StandardCharsets.UTF_8);
                if (((byte[])_stringBytes).length > Short.MAX_VALUE) {
                    throw new RuntimeException("'mirrorTopic' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.mirrorTopic, (byte[])_stringBytes);
                int _stringPrefixSize = ByteUtils.sizeOfUnsignedVarint(((byte[])_stringBytes).length + 1);
                _size.addBytes(((byte[])_stringBytes).length + _stringPrefixSize + ByteUtils.sizeOfUnsignedVarint(_stringPrefixSize + ((byte[])_stringBytes).length));
            }
            if (_version >= 7 && !this.sourceTopicId.equals(Uuid.ZERO_UUID)) {
                ++_numTaggedFields;
                _size.addBytes(2);
                _size.addBytes(1);
                _size.addBytes(16);
            }
            if (_version >= 7 && this.mirrorStartOffsetSpec != Long.MIN_VALUE) {
                ++_numTaggedFields;
                _size.addBytes(2);
                _size.addBytes(1);
                _size.addBytes(8);
            }
            if (_version >= 7) {
                if (this.mirrorStartOffsets == null) {
                    ++_numTaggedFields;
                    _size.addBytes(2);
                    _size.addBytes(1);
                    _size.addBytes(1);
                } else if (!this.mirrorStartOffsets.isEmpty()) {
                    ++_numTaggedFields;
                    _size.addBytes(2);
                    int _sizeBeforeArray = _size.totalSize();
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.mirrorStartOffsets.size() + 1));
                    _size.addBytes(this.mirrorStartOffsets.size() * 8);
                    int _arraySize = _size.totalSize() - _sizeBeforeArray;
                    _cache.setArraySizeInBytes(this.mirrorStartOffsets, _arraySize);
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_arraySize));
                }
            }
            if (_version >= 7 && this.stoppedSequenceNumber != 0L) {
                ++_numTaggedFields;
                _size.addBytes(2);
                _size.addBytes(1);
                _size.addBytes(8);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 5) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof CreatableTopic)) {
                return false;
            }
            CreatableTopic other = (CreatableTopic)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CreatableTopic)) {
                return false;
            }
            CreatableTopic other = (CreatableTopic)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.numPartitions != other.numPartitions) {
                return false;
            }
            if (this.replicationFactor != other.replicationFactor) {
                return false;
            }
            if (this.assignments == null ? other.assignments != null : !this.assignments.equals(other.assignments)) {
                return false;
            }
            if (this.configs == null ? other.configs != null : !this.configs.equals(other.configs)) {
                return false;
            }
            if (this.linkName == null ? other.linkName != null : !this.linkName.equals(other.linkName)) {
                return false;
            }
            if (this.mirrorTopic == null ? other.mirrorTopic != null : !this.mirrorTopic.equals(other.mirrorTopic)) {
                return false;
            }
            if (!this.sourceTopicId.equals(other.sourceTopicId)) {
                return false;
            }
            if (this.mirrorStartOffsetSpec != other.mirrorStartOffsetSpec) {
                return false;
            }
            if (this.mirrorStartOffsets == null ? other.mirrorStartOffsets != null : !this.mirrorStartOffsets.equals(other.mirrorStartOffsets)) {
                return false;
            }
            if (this.stoppedSequenceNumber != other.stoppedSequenceNumber) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            return hashCode;
        }

        @Override
        public CreatableTopic duplicate() {
            CreatableTopic _duplicate = new CreatableTopic();
            _duplicate.name = this.name;
            _duplicate.numPartitions = this.numPartitions;
            _duplicate.replicationFactor = this.replicationFactor;
            CreatableReplicaAssignmentCollection newAssignments = new CreatableReplicaAssignmentCollection(this.assignments.size());
            for (Object _element : this.assignments) {
                newAssignments.add(((CreatableReplicaAssignment)_element).duplicate());
            }
            _duplicate.assignments = newAssignments;
            CreateableTopicConfigCollection newConfigs = new CreateableTopicConfigCollection(this.configs.size());
            for (CreateableTopicConfig _element : this.configs) {
                newConfigs.add(_element.duplicate());
            }
            _duplicate.configs = newConfigs;
            _duplicate.linkName = this.linkName == null ? null : this.linkName;
            _duplicate.mirrorTopic = this.mirrorTopic == null ? null : this.mirrorTopic;
            _duplicate.sourceTopicId = this.sourceTopicId;
            _duplicate.mirrorStartOffsetSpec = this.mirrorStartOffsetSpec;
            if (this.mirrorStartOffsets == null) {
                _duplicate.mirrorStartOffsets = null;
            } else {
                ArrayList<Long> newMirrorStartOffsets = new ArrayList<Long>(this.mirrorStartOffsets.size());
                for (Long _element : this.mirrorStartOffsets) {
                    newMirrorStartOffsets.add(_element);
                }
                _duplicate.mirrorStartOffsets = newMirrorStartOffsets;
            }
            _duplicate.stoppedSequenceNumber = this.stoppedSequenceNumber;
            return _duplicate;
        }

        public String toString() {
            return "CreatableTopic(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", numPartitions=" + this.numPartitions + ", replicationFactor=" + this.replicationFactor + ", assignments=" + MessageUtil.deepToString(this.assignments.iterator()) + ", configs=" + MessageUtil.deepToString(this.configs.iterator()) + ", linkName=" + (this.linkName == null ? "null" : "'" + this.linkName.toString() + "'") + ", mirrorTopic=" + (this.mirrorTopic == null ? "null" : "'" + this.mirrorTopic.toString() + "'") + ", sourceTopicId=" + this.sourceTopicId.toString() + ", mirrorStartOffsetSpec=" + this.mirrorStartOffsetSpec + ", mirrorStartOffsets=" + (this.mirrorStartOffsets == null ? "null" : MessageUtil.deepToString(this.mirrorStartOffsets.iterator())) + ", stoppedSequenceNumber=" + this.stoppedSequenceNumber + ")";
        }

        public String name() {
            return this.name;
        }

        public int numPartitions() {
            return this.numPartitions;
        }

        public short replicationFactor() {
            return this.replicationFactor;
        }

        public CreatableReplicaAssignmentCollection assignments() {
            return this.assignments;
        }

        public CreateableTopicConfigCollection configs() {
            return this.configs;
        }

        public String linkName() {
            return this.linkName;
        }

        public String mirrorTopic() {
            return this.mirrorTopic;
        }

        public Uuid sourceTopicId() {
            return this.sourceTopicId;
        }

        public long mirrorStartOffsetSpec() {
            return this.mirrorStartOffsetSpec;
        }

        public List<Long> mirrorStartOffsets() {
            return this.mirrorStartOffsets;
        }

        public long stoppedSequenceNumber() {
            return this.stoppedSequenceNumber;
        }

        @Override
        public int next() {
            return this.next;
        }

        @Override
        public int prev() {
            return this.prev;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public CreatableTopic setName(String v) {
            this.name = v;
            return this;
        }

        public CreatableTopic setNumPartitions(int v) {
            this.numPartitions = v;
            return this;
        }

        public CreatableTopic setReplicationFactor(short v) {
            this.replicationFactor = v;
            return this;
        }

        public CreatableTopic setAssignments(CreatableReplicaAssignmentCollection v) {
            this.assignments = v;
            return this;
        }

        public CreatableTopic setConfigs(CreateableTopicConfigCollection v) {
            this.configs = v;
            return this;
        }

        public CreatableTopic setLinkName(String v) {
            this.linkName = v;
            return this;
        }

        public CreatableTopic setMirrorTopic(String v) {
            this.mirrorTopic = v;
            return this;
        }

        public CreatableTopic setSourceTopicId(Uuid v) {
            this.sourceTopicId = v;
            return this;
        }

        public CreatableTopic setMirrorStartOffsetSpec(long v) {
            this.mirrorStartOffsetSpec = v;
            return this;
        }

        public CreatableTopic setMirrorStartOffsets(List<Long> v) {
            this.mirrorStartOffsets = v;
            return this;
        }

        public CreatableTopic setStoppedSequenceNumber(long v) {
            this.stoppedSequenceNumber = v;
            return this;
        }

        @Override
        public void setNext(int v) {
            this.next = v;
        }

        @Override
        public void setPrev(int v) {
            this.prev = v;
        }

        static {
            SCHEMA_4 = SCHEMA_3 = (SCHEMA_2 = (SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("name", Type.STRING, "The topic name."), new Field("num_partitions", Type.INT32, "The number of partitions to create in the topic, or -1 if we are either specifying a manual partition assignment or using the default partitions."), new Field("replication_factor", Type.INT16, "The number of replicas to create for each partition in the topic, or -1 if we are either specifying a manual partition assignment or using the default replication factor."), new Field("assignments", new ArrayOf(CreatableReplicaAssignment.SCHEMA_0), "The manual partition assignment, or the empty array if we are using automatic assignment."), new Field("configs", new ArrayOf(CreateableTopicConfig.SCHEMA_0), "The custom topic configurations to set.")))));
            SCHEMA_6 = SCHEMA_5 = new Schema(new Field("name", Type.COMPACT_STRING, "The topic name."), new Field("num_partitions", Type.INT32, "The number of partitions to create in the topic, or -1 if we are either specifying a manual partition assignment or using the default partitions."), new Field("replication_factor", Type.INT16, "The number of replicas to create for each partition in the topic, or -1 if we are either specifying a manual partition assignment or using the default replication factor."), new Field("assignments", new CompactArrayOf(CreatableReplicaAssignment.SCHEMA_5), "The manual partition assignment, or the empty array if we are using automatic assignment."), new Field("configs", new CompactArrayOf(CreateableTopicConfig.SCHEMA_5), "The custom topic configurations to set."), Field.TaggedFieldsSection.of(10000, new Field("link_name", Type.COMPACT_NULLABLE_STRING, "The cluster link name for topic mirroring."), 10001, new Field("mirror_topic", Type.COMPACT_NULLABLE_STRING, "The topic name over the cluster link that the topic will mirror.")));
            SCHEMA_7 = new Schema(new Field("name", Type.COMPACT_STRING, "The topic name."), new Field("num_partitions", Type.INT32, "The number of partitions to create in the topic, or -1 if we are either specifying a manual partition assignment or using the default partitions."), new Field("replication_factor", Type.INT16, "The number of replicas to create for each partition in the topic, or -1 if we are either specifying a manual partition assignment or using the default replication factor."), new Field("assignments", new CompactArrayOf(CreatableReplicaAssignment.SCHEMA_5), "The manual partition assignment, or the empty array if we are using automatic assignment."), new Field("configs", new CompactArrayOf(CreateableTopicConfig.SCHEMA_5), "The custom topic configurations to set."), Field.TaggedFieldsSection.of(10000, new Field("link_name", Type.COMPACT_NULLABLE_STRING, "The cluster link name for topic mirroring."), 10001, new Field("mirror_topic", Type.COMPACT_NULLABLE_STRING, "The topic name over the cluster link that the topic will mirror."), 10002, new Field("source_topic_id", Type.UUID, "The topic ID of the mirror topic."), 10003, new Field("mirror_start_offset_spec", Type.INT64, "Offset spec for the offset to start mirroring from, using the same format as ListOffsetsRequest. Default of Long.MIN_VALUE uses the cluster link default spec."), 10004, new Field("mirror_start_offsets", CompactArrayOf.nullable(Type.INT64), "List of earliest offsets to start mirroring from, ordered by partition. By default, mirroring starts from the first available offset. This is an internal field set in KRaft mode when forwarding the request to the controller."), 10005, new Field("stopped_sequence_number", Type.INT64, "The stopped sequence number we want to update for the topic. Only used when creating a new mirror topic.")));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7};
        }
    }
}

