/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import org.apache.kafka.common.message.DescribeClusterRequestData;
import org.apache.kafka.common.message.DescribeClusterResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.DescribeClusterResponse;

public class DescribeClusterRequest
extends AbstractRequest {
    private final DescribeClusterRequestData data;

    public DescribeClusterRequest(DescribeClusterRequestData data, short version) {
        super(ApiKeys.DESCRIBE_CLUSTER, version);
        this.data = data;
    }

    @Override
    public DescribeClusterRequestData data() {
        return this.data;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        ApiError apiError = ApiError.fromThrowable(e);
        return new DescribeClusterResponse(new DescribeClusterResponseData().setErrorCode(apiError.error().code()).setErrorMessage(apiError.message()));
    }

    @Override
    public String toString(boolean verbose) {
        return this.data.toString();
    }

    public static DescribeClusterRequest parse(ByteBuffer buffer, short version, MessageContext context) {
        return new DescribeClusterRequest(new DescribeClusterRequestData(new ByteBufferAccessor(buffer), version, context), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<DescribeClusterRequest> {
        private final DescribeClusterRequestData data;

        public Builder(DescribeClusterRequestData data) {
            super(ApiKeys.DESCRIBE_CLUSTER);
            this.data = data;
        }

        @Override
        public DescribeClusterRequest build(short version) {
            return new DescribeClusterRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

