/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.kafka.common.message.JoinGroupResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractResponse;

public class JoinGroupResponse
extends AbstractResponse {
    private final JoinGroupResponseData data;

    public JoinGroupResponse(JoinGroupResponseData data, short version) {
        super(ApiKeys.JOIN_GROUP);
        this.data = data;
        if (version < 7 && data.protocolName() == null) {
            data.setProtocolName("");
        }
        if (version >= 7 && data.protocolName() != null && data.protocolName().isEmpty()) {
            data.setProtocolName(null);
        }
    }

    @Override
    public JoinGroupResponseData data() {
        return this.data;
    }

    public boolean isLeader() {
        return this.data.memberId().equals(this.data.leader());
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    public Errors error() {
        return Errors.forCode(this.data.errorCode());
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return this.errorCounts(Errors.forCode(this.data.errorCode()));
    }

    public static JoinGroupResponse parse(ByteBuffer buffer, short version, MessageContext context) {
        return new JoinGroupResponse(new JoinGroupResponseData(new ByteBufferAccessor(buffer), version, context), version);
    }

    @Override
    public String toString() {
        return this.data.toString();
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 3;
    }
}

