/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Random;
import org.apache.kafka.common.utils.KafkaThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Exit {
    private static final Logger log = LoggerFactory.getLogger(Exit.class);
    private static final Random RAND = new Random();
    private static final Procedure DEFAULT_HALT_PROCEDURE = (statusCode, message) -> Runtime.getRuntime().halt(statusCode);
    private static final Procedure DEFAULT_EXIT_PROCEDURE = (statusCode, message) -> System.exit(statusCode);
    private static final ShutdownHookAdder DEFAULT_SHUTDOWN_HOOK_ADDER = (name, runnable) -> {
        if (name != null) {
            Runtime.getRuntime().addShutdownHook(KafkaThread.nonDaemon(name, runnable));
        } else {
            Runtime.getRuntime().addShutdownHook(new Thread(runnable));
        }
    };
    private static final Procedure NOOP_HALT_PROCEDURE = (statusCode, message) -> {
        throw new IllegalStateException("Halt called after resetting procedures; possible race condition present in test");
    };
    private static final Procedure NOOP_EXIT_PROCEDURE = (statusCode, message) -> {
        throw new IllegalStateException("Exit called after resetting procedures; possible race condition present in test");
    };
    private static volatile Procedure exitProcedure = DEFAULT_EXIT_PROCEDURE;
    private static volatile Procedure haltProcedure = DEFAULT_HALT_PROCEDURE;
    private static volatile ShutdownHookAdder shutdownHookAdder = DEFAULT_SHUTDOWN_HOOK_ADDER;

    public static void exit(int statusCode) {
        Exit.exit(statusCode, null);
    }

    public static void exit(int statusCode, String message) {
        String disableSystemExit = System.getProperty("disableSystemExit");
        if (disableSystemExit != null && disableSystemExit.equals("true") && exitProcedure == DEFAULT_EXIT_PROCEDURE) {
            Exit.logExit(statusCode, message);
        } else {
            exitProcedure.execute(statusCode, message);
        }
    }

    private static void logExit(int status, String message) {
        log.error("Test run detected, exit call {} with message {} logged but ignored. Stacktrace will be saved in file. Treat as test failure. Actual exit, rare.", (Object)status, (Object)message);
        Exit.logStackTrace();
    }

    private static void logStackTrace() {
        Exception e = new Exception("Exiting or halting application at:");
        StackTraceElement[] stackTrace = e.getStackTrace();
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss_SSS");
        LocalDateTime now = LocalDateTime.now();
        String timePart = dtf.format(now);
        long threadId = Thread.currentThread().getId();
        String threadName = Thread.currentThread().getName();
        String threadPart = Long.toString(threadId) + "_" + threadName;
        int randomPart = RAND.nextInt(1000000);
        String stackTraceDir = System.getProperty("stackTraceDir");
        String stackTraceFileName = stackTraceDir + File.separator + "stacktrace_" + timePart + "_" + threadPart + "_" + randomPart + ".log";
        try (FileWriter fileWriter = new FileWriter(stackTraceFileName, true);
             PrintWriter printWriter = new PrintWriter(fileWriter);){
            printWriter.println(e.getMessage());
            for (int i = 1; i < stackTrace.length; ++i) {
                String className = stackTrace[i].getClassName();
                if (className.startsWith("org.gradle.") || className.startsWith("org.junit.")) continue;
                printWriter.println("\tat " + stackTrace[i]);
            }
        }
        catch (IOException ex) {
            log.error("Error writing stack trace to file: {}", (Object)stackTraceFileName, (Object)ex);
        }
    }

    public static void halt(int statusCode) {
        Exit.halt(statusCode, null);
    }

    public static void halt(int statusCode, String message) {
        String disableSystemExit = System.getProperty("disableSystemExit");
        if (disableSystemExit != null && disableSystemExit.equals("true") && haltProcedure == DEFAULT_HALT_PROCEDURE) {
            Exit.logHalt(statusCode, message);
        } else {
            haltProcedure.execute(statusCode, message);
        }
    }

    private static void logHalt(int statusCode, String message) {
        log.error("Test run detected, halt call {} with message {} logged but ignored. Stacktrace will be saved in file. Treat as test failure. Actual halt, rare.", (Object)statusCode, (Object)message);
        Exit.logStackTrace();
    }

    public static void addShutdownHook(String name, Runnable runnable) {
        shutdownHookAdder.addShutdownHook(name, runnable);
    }

    public static void setExitProcedure(Procedure procedure) {
        exitProcedure = procedure;
    }

    public static void setHaltProcedure(Procedure procedure) {
        haltProcedure = procedure;
    }

    public static void setShutdownHookAdder(ShutdownHookAdder shutdownHookAdder) {
        Exit.shutdownHookAdder = shutdownHookAdder;
    }

    public static void resetExitProcedure() {
        exitProcedure = NOOP_EXIT_PROCEDURE;
    }

    public static void resetHaltProcedure() {
        haltProcedure = NOOP_HALT_PROCEDURE;
    }

    public static void resetShutdownHookAdder() {
        shutdownHookAdder = DEFAULT_SHUTDOWN_HOOK_ADDER;
    }

    @FunctionalInterface
    public static interface ShutdownHookAdder {
        public void addShutdownHook(String var1, Runnable var2);
    }

    @FunctionalInterface
    public static interface Procedure {
        public void execute(int var1, String var2);
    }
}

