/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatRequestData;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ConsumerGroupHeartbeatResponse;

public class ConsumerGroupHeartbeatRequest
extends AbstractRequest {
    public static final int LEAVE_GROUP_MEMBER_EPOCH = -1;
    public static final int LEAVE_GROUP_STATIC_MEMBER_EPOCH = -2;
    public static final int JOIN_GROUP_MEMBER_EPOCH = 0;
    private final ConsumerGroupHeartbeatRequestData data;

    public ConsumerGroupHeartbeatRequest(ConsumerGroupHeartbeatRequestData data, short version) {
        super(ApiKeys.CONSUMER_GROUP_HEARTBEAT, version);
        this.data = data;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        return new ConsumerGroupHeartbeatResponse(new ConsumerGroupHeartbeatResponseData().setThrottleTimeMs(throttleTimeMs).setErrorCode(Errors.forException(e).code()));
    }

    @Override
    public ConsumerGroupHeartbeatRequestData data() {
        return this.data;
    }

    public static ConsumerGroupHeartbeatRequest parse(ByteBuffer buffer, short version, MessageContext context) {
        return new ConsumerGroupHeartbeatRequest(new ConsumerGroupHeartbeatRequestData(new ByteBufferAccessor(buffer), version, context), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<ConsumerGroupHeartbeatRequest> {
        private final ConsumerGroupHeartbeatRequestData data;

        public Builder(ConsumerGroupHeartbeatRequestData data) {
            this(data, false);
        }

        public Builder(ConsumerGroupHeartbeatRequestData data, boolean enableUnstableLastVersion) {
            super(ApiKeys.CONSUMER_GROUP_HEARTBEAT, enableUnstableLastVersion);
            this.data = data;
        }

        @Override
        public ConsumerGroupHeartbeatRequest build(short version) {
            return new ConsumerGroupHeartbeatRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

