/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.EntityType;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.ImplicitLinkedHashMultiCollection;

public class BeginQuorumEpochRequestData
implements ApiMessage {
    String clusterId;
    int voterId;
    List<TopicData> topics;
    LeaderEndpointCollection leaderEndpoints;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("cluster_id", Type.NULLABLE_STRING, ""), new Field("topics", new ArrayOf(TopicData.SCHEMA_0), ""));
    public static final Schema SCHEMA_1 = new Schema(new Field("cluster_id", Type.COMPACT_NULLABLE_STRING, ""), new Field("voter_id", Type.INT32, "The replica id of the voter receiving the request"), new Field("topics", new CompactArrayOf(TopicData.SCHEMA_1), ""), new Field("leader_endpoints", new CompactArrayOf(LeaderEndpoint.SCHEMA_1), "Endpoints for the leader"), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 1;

    public BeginQuorumEpochRequestData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public BeginQuorumEpochRequestData() {
        this.clusterId = null;
        this.voterId = -1;
        this.topics = new ArrayList<TopicData>(0);
        this.leaderEndpoints = new LeaderEndpointCollection(0);
    }

    @Override
    public short apiKey() {
        return 53;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 1;
    }

    @Override
    public final void read(Readable _readable, short _version, MessageContext _context) {
        int i;
        AbstractCollection newCollection;
        int arrayLength;
        int length = _version >= 1 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
        if (length < 0) {
            this.clusterId = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field clusterId had invalid length " + length);
            }
            this.clusterId = _readable.readString(length);
        }
        this.voterId = _version >= 1 ? _readable.readInt() : -1;
        if (_version >= 1) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field topics was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                ((ArrayList)newCollection).add((TopicData)new TopicData(_readable, _version, _context));
            }
            this.topics = newCollection;
        } else {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field topics was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList<TopicData>(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                ((ArrayList)newCollection).add((TopicData)new TopicData(_readable, _version, _context));
            }
            this.topics = newCollection;
        }
        if (_version >= 1) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field leaderEndpoints was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new LeaderEndpointCollection(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                ((ImplicitLinkedHashCollection)newCollection).add((LeaderEndpoint)new LeaderEndpoint(_readable, _version, _context));
            }
            this.leaderEndpoints = newCollection;
        } else {
            this.leaderEndpoints = new LeaderEndpointCollection(0);
        }
        this._unknownTaggedFields = null;
        if (_version >= 1) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        TopicData topicsElement;
        Object _stringBytes;
        int _numTaggedFields = 0;
        if (this.clusterId == null) {
            if (_version >= 1) {
                _writable.writeUnsignedVarint(0);
            } else {
                _writable.writeShort((short)-1);
            }
        } else {
            _stringBytes = _cache.getSerializedValue(this.clusterId);
            if (_version >= 1) {
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            } else {
                _writable.writeShort((short)((byte[])_stringBytes).length);
            }
            _writable.writeByteArray((byte[])_stringBytes);
        }
        if (_version >= 1) {
            _writable.writeInt(this.voterId);
        }
        if (_version >= 1) {
            _writable.writeUnsignedVarint(this.topics.size() + 1);
            _stringBytes = this.topics.iterator();
            while (_stringBytes.hasNext()) {
                topicsElement = (TopicData)_stringBytes.next();
                topicsElement.write(_writable, _cache, _version, _context);
            }
        } else {
            _writable.writeInt(this.topics.size());
            _stringBytes = this.topics.iterator();
            while (_stringBytes.hasNext()) {
                topicsElement = (TopicData)_stringBytes.next();
                topicsElement.write(_writable, _cache, _version, _context);
            }
        }
        if (_version >= 1) {
            _writable.writeUnsignedVarint(this.leaderEndpoints.size() + 1);
            for (LeaderEndpoint leaderEndpointsElement : this.leaderEndpoints) {
                leaderEndpointsElement.write(_writable, _cache, _version, _context);
            }
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 1) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        if (this.clusterId == null) {
            if (_version >= 1) {
                _size.addBytes(1);
            } else {
                _size.addBytes(2);
            }
        } else {
            byte[] _stringBytes = this.clusterId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'clusterId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.clusterId, _stringBytes);
            if (_version >= 1) {
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            } else {
                _size.addBytes(_stringBytes.length + 2);
            }
        }
        if (_version >= 1) {
            _size.addBytes(4);
        }
        if (_version >= 1) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.topics.size() + 1));
        } else {
            _size.addBytes(4);
        }
        for (TopicData topicsElement : this.topics) {
            topicsElement.addSize(_size, _cache, _version, _context);
        }
        if (_version >= 1) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.leaderEndpoints.size() + 1));
            for (LeaderEndpoint leaderEndpointsElement : this.leaderEndpoints) {
                leaderEndpointsElement.addSize(_size, _cache, _version, _context);
            }
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_version >= 1) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BeginQuorumEpochRequestData)) {
            return false;
        }
        BeginQuorumEpochRequestData other = (BeginQuorumEpochRequestData)obj;
        if (this.clusterId == null ? other.clusterId != null : !this.clusterId.equals(other.clusterId)) {
            return false;
        }
        if (this.voterId != other.voterId) {
            return false;
        }
        if (this.topics == null ? other.topics != null : !this.topics.equals(other.topics)) {
            return false;
        }
        if (this.leaderEndpoints == null ? other.leaderEndpoints != null : !this.leaderEndpoints.equals(other.leaderEndpoints)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.clusterId == null ? 0 : this.clusterId.hashCode());
        hashCode = 31 * hashCode + this.voterId;
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        hashCode = 31 * hashCode + (this.leaderEndpoints == null ? 0 : this.leaderEndpoints.hashCode());
        return hashCode;
    }

    @Override
    public BeginQuorumEpochRequestData duplicate() {
        BeginQuorumEpochRequestData _duplicate = new BeginQuorumEpochRequestData();
        _duplicate.clusterId = this.clusterId == null ? null : this.clusterId;
        _duplicate.voterId = this.voterId;
        ArrayList<TopicData> newTopics = new ArrayList<TopicData>(this.topics.size());
        for (TopicData _element : this.topics) {
            newTopics.add(_element.duplicate());
        }
        _duplicate.topics = newTopics;
        LeaderEndpointCollection newLeaderEndpoints = new LeaderEndpointCollection(this.leaderEndpoints.size());
        for (LeaderEndpoint _element : this.leaderEndpoints) {
            newLeaderEndpoints.add(_element.duplicate());
        }
        _duplicate.leaderEndpoints = newLeaderEndpoints;
        return _duplicate;
    }

    public String toString() {
        return "BeginQuorumEpochRequestData(clusterId=" + (this.clusterId == null ? "null" : "'" + this.clusterId.toString() + "'") + ", voterId=" + this.voterId + ", topics=" + MessageUtil.deepToString(this.topics.iterator()) + ", leaderEndpoints=" + MessageUtil.deepToString(this.leaderEndpoints.iterator()) + ")";
    }

    public String clusterId() {
        return this.clusterId;
    }

    public int voterId() {
        return this.voterId;
    }

    public List<TopicData> topics() {
        return this.topics;
    }

    public LeaderEndpointCollection leaderEndpoints() {
        return this.leaderEndpoints;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public BeginQuorumEpochRequestData setClusterId(String v) {
        this.clusterId = v;
        return this;
    }

    public BeginQuorumEpochRequestData setVoterId(int v) {
        this.voterId = v;
        return this;
    }

    public BeginQuorumEpochRequestData setTopics(List<TopicData> v) {
        this.topics = v;
        return this;
    }

    public BeginQuorumEpochRequestData setLeaderEndpoints(LeaderEndpointCollection v) {
        this.leaderEndpoints = v;
        return this;
    }

    public static class LeaderEndpointCollection
    extends ImplicitLinkedHashMultiCollection<LeaderEndpoint> {
        public LeaderEndpointCollection() {
        }

        public LeaderEndpointCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public LeaderEndpointCollection(Iterator<LeaderEndpoint> iterator) {
            super(iterator);
        }

        @Override
        public LeaderEndpoint find(String name) {
            LeaderEndpoint _key = new LeaderEndpoint();
            _key.setName(name);
            return this.find(_key);
        }

        @Override
        public List<LeaderEndpoint> findAll(String name) {
            LeaderEndpoint _key = new LeaderEndpoint();
            _key.setName(name);
            return this.findAll(_key);
        }

        public LeaderEndpointCollection duplicate() {
            LeaderEndpointCollection _duplicate = new LeaderEndpointCollection(this.size());
            for (LeaderEndpoint _element : this) {
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class LeaderEndpoint
    implements Message,
    ImplicitLinkedHashCollection.Element {
        String name;
        String host;
        int port;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_1 = new Schema(new Field("name", Type.COMPACT_STRING, "The name of the endpoint"), new Field("host", Type.COMPACT_STRING, "The node's hostname"), new Field("port", Type.UINT16, "The node's port"), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{null, SCHEMA_1};
        public static final short LOWEST_SUPPORTED_VERSION = 1;
        public static final short HIGHEST_SUPPORTED_VERSION = 1;

        public LeaderEndpoint(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
            this.prev = -2;
            this.next = -2;
        }

        public LeaderEndpoint() {
            this.name = "";
            this.host = "";
            this.port = 0;
            this.prev = -2;
            this.next = -2;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 1;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of LeaderEndpoint");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field host was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field host had invalid length " + length);
            }
            this.host = _readable.readString(length);
            this.port = _readable.readUnsignedShort();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            if (_version < 1) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of LeaderEndpoint");
            }
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue(this.name);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _stringBytes = _cache.getSerializedValue(this.host);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _writable.writeUnsignedShort(this.port);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of LeaderEndpoint");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.name, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _stringBytes = this.host.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'host' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.host, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _size.addBytes(2);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        @Override
        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof LeaderEndpoint)) {
                return false;
            }
            LeaderEndpoint other = (LeaderEndpoint)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof LeaderEndpoint)) {
                return false;
            }
            LeaderEndpoint other = (LeaderEndpoint)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
                return false;
            }
            if (this.port != other.port) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            return hashCode;
        }

        @Override
        public LeaderEndpoint duplicate() {
            LeaderEndpoint _duplicate = new LeaderEndpoint();
            _duplicate.name = this.name;
            _duplicate.host = this.host;
            _duplicate.port = this.port;
            return _duplicate;
        }

        public String toString() {
            return "LeaderEndpoint(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", host=" + (this.host == null ? "null" : "'" + this.host.toString() + "'") + ", port=" + this.port + ")";
        }

        public String name() {
            return this.name;
        }

        public String host() {
            return this.host;
        }

        public int port() {
            return this.port;
        }

        @Override
        public int next() {
            return this.next;
        }

        @Override
        public int prev() {
            return this.prev;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public LeaderEndpoint setName(String v) {
            this.name = v;
            return this;
        }

        public LeaderEndpoint setHost(String v) {
            this.host = v;
            return this;
        }

        public LeaderEndpoint setPort(int v) {
            if (v < 0 || v > 65535) {
                throw new RuntimeException("Invalid value " + v + " for unsigned short field.");
            }
            this.port = v;
            return this;
        }

        @Override
        public void setNext(int v) {
            this.next = v;
        }

        @Override
        public void setPrev(int v) {
            this.prev = v;
        }
    }

    public static class PartitionData
    implements Message {
        int partitionIndex;
        Uuid voterDirectoryId;
        int leaderId;
        int leaderEpoch;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("partition_index", Type.INT32, "The partition index"), new Field("leader_id", Type.INT32, "The ID of the newly elected leader"), new Field("leader_epoch", Type.INT32, "The epoch of the newly elected leader"));
        public static final Schema SCHEMA_1 = new Schema(new Field("partition_index", Type.INT32, "The partition index"), new Field("voter_directory_id", Type.UUID, "The directory id of the receiving replica"), new Field("leader_id", Type.INT32, "The ID of the newly elected leader"), new Field("leader_epoch", Type.INT32, "The epoch of the newly elected leader"), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 1;

        public PartitionData(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public PartitionData() {
            this.partitionIndex = 0;
            this.voterDirectoryId = Uuid.ZERO_UUID;
            this.leaderId = 0;
            this.leaderEpoch = 0;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 1;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of PartitionData");
            }
            this.partitionIndex = _readable.readInt();
            this.voterDirectoryId = _version >= 1 ? _readable.readUuid() : Uuid.ZERO_UUID;
            this.leaderId = _readable.readInt();
            this.leaderEpoch = _readable.readInt();
            this._unknownTaggedFields = null;
            if (_version >= 1) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.partitionIndex);
            if (_version >= 1) {
                _writable.writeUuid(this.voterDirectoryId);
            }
            _writable.writeInt(this.leaderId);
            _writable.writeInt(this.leaderEpoch);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 1) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of PartitionData");
            }
            _size.addBytes(4);
            if (_version >= 1) {
                _size.addBytes(16);
            }
            _size.addBytes(4);
            _size.addBytes(4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 1) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PartitionData)) {
                return false;
            }
            PartitionData other = (PartitionData)obj;
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            if (!this.voterDirectoryId.equals(other.voterDirectoryId)) {
                return false;
            }
            if (this.leaderId != other.leaderId) {
                return false;
            }
            if (this.leaderEpoch != other.leaderEpoch) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partitionIndex;
            hashCode = 31 * hashCode + this.voterDirectoryId.hashCode();
            hashCode = 31 * hashCode + this.leaderId;
            hashCode = 31 * hashCode + this.leaderEpoch;
            return hashCode;
        }

        @Override
        public PartitionData duplicate() {
            PartitionData _duplicate = new PartitionData();
            _duplicate.partitionIndex = this.partitionIndex;
            _duplicate.voterDirectoryId = this.voterDirectoryId;
            _duplicate.leaderId = this.leaderId;
            _duplicate.leaderEpoch = this.leaderEpoch;
            return _duplicate;
        }

        public String toString() {
            return "PartitionData(partitionIndex=" + this.partitionIndex + ", voterDirectoryId=" + this.voterDirectoryId.toString() + ", leaderId=" + this.leaderId + ", leaderEpoch=" + this.leaderEpoch + ")";
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public Uuid voterDirectoryId() {
            return this.voterDirectoryId;
        }

        public int leaderId() {
            return this.leaderId;
        }

        public int leaderEpoch() {
            return this.leaderEpoch;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public PartitionData setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public PartitionData setVoterDirectoryId(Uuid v) {
            this.voterDirectoryId = v;
            return this;
        }

        public PartitionData setLeaderId(int v) {
            this.leaderId = v;
            return this;
        }

        public PartitionData setLeaderEpoch(int v) {
            this.leaderEpoch = v;
            return this;
        }
    }

    public static class TopicData
    implements Message {
        String topicName;
        List<PartitionData> partitions;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("topic_name", Type.STRING, "The topic name"), new Field("partitions", new ArrayOf(PartitionData.SCHEMA_0), ""));
        public static final Schema SCHEMA_1 = new Schema(new Field("topic_name", Type.COMPACT_STRING, "The topic name"), new Field("partitions", new CompactArrayOf(PartitionData.SCHEMA_1), ""), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 1;

        public TopicData(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public TopicData() {
            this.topicName = "";
            this.partitions = new ArrayList<PartitionData>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 1;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            int i;
            ArrayList<PartitionData> newCollection;
            int arrayLength;
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of TopicData");
            }
            int length = _version >= 1 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field topicName was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field topicName had invalid length " + length);
            }
            this.topicName = _context.read(EntityType.TOPIC_NAME, _readable.readString(length));
            if (_version >= 1) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field partitions was serialized as null");
                }
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new PartitionData(_readable, _version, _context));
                }
                this.partitions = newCollection;
            } else {
                arrayLength = _readable.readInt();
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field partitions was serialized as null");
                }
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                newCollection = new ArrayList<PartitionData>(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new PartitionData(_readable, _version, _context));
                }
                this.partitions = newCollection;
            }
            this._unknownTaggedFields = null;
            if (_version >= 1) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.topicName);
            if (_version >= 1) {
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            } else {
                _writable.writeShort((short)((byte[])_stringBytes).length);
            }
            _writable.writeByteArray((byte[])_stringBytes);
            if (_version >= 1) {
                _writable.writeUnsignedVarint(this.partitions.size() + 1);
                _stringBytes = this.partitions.iterator();
                while (_stringBytes.hasNext()) {
                    PartitionData partitionsElement = (PartitionData)_stringBytes.next();
                    partitionsElement.write(_writable, _cache, _version, _context);
                }
            } else {
                _writable.writeInt(this.partitions.size());
                _stringBytes = this.partitions.iterator();
                while (_stringBytes.hasNext()) {
                    PartitionData partitionsElement = (PartitionData)_stringBytes.next();
                    partitionsElement.write(_writable, _cache, _version, _context);
                }
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 1) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of TopicData");
            }
            byte[] _stringBytes = _context.write(EntityType.TOPIC_NAME, this.topicName).getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'topicName' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.topicName, _stringBytes);
            if (_version >= 1) {
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            } else {
                _size.addBytes(_stringBytes.length + 2);
            }
            if (_version >= 1) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.partitions.size() + 1));
            } else {
                _size.addBytes(4);
            }
            for (PartitionData partitionsElement : this.partitions) {
                partitionsElement.addSize(_size, _cache, _version, _context);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 1) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TopicData)) {
                return false;
            }
            TopicData other = (TopicData)obj;
            if (this.topicName == null ? other.topicName != null : !this.topicName.equals(other.topicName)) {
                return false;
            }
            if (this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.topicName == null ? 0 : this.topicName.hashCode());
            hashCode = 31 * hashCode + (this.partitions == null ? 0 : this.partitions.hashCode());
            return hashCode;
        }

        @Override
        public TopicData duplicate() {
            TopicData _duplicate = new TopicData();
            _duplicate.topicName = this.topicName;
            ArrayList<PartitionData> newPartitions = new ArrayList<PartitionData>(this.partitions.size());
            for (PartitionData _element : this.partitions) {
                newPartitions.add(_element.duplicate());
            }
            _duplicate.partitions = newPartitions;
            return _duplicate;
        }

        public String toString() {
            return "TopicData(topicName=" + (this.topicName == null ? "null" : "'" + this.topicName.toString() + "'") + ", partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public String topicName() {
            return this.topicName;
        }

        public List<PartitionData> partitions() {
            return this.partitions;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public TopicData setTopicName(String v) {
            this.topicName = v;
            return this;
        }

        public TopicData setPartitions(List<PartitionData> v) {
            this.partitions = v;
            return this;
        }
    }
}

