/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant;

import io.confluent.kafka.multitenant.InetAddressToTenantMapping;
import java.net.InetAddress;
import java.util.Optional;

public class SingletonInetAddressToTenantMapping
implements InetAddressToTenantMapping {
    private final InetAddress address;
    private final Optional<String> tenantId;

    public SingletonInetAddressToTenantMapping(InetAddress address, String tenantId) {
        this.address = address;
        this.tenantId = tenantId == null || tenantId.isEmpty() ? Optional.empty() : Optional.of(tenantId);
    }

    @Override
    public Optional<String> tenant(InetAddress address) {
        if (this.address.equals(address)) {
            return this.tenantId;
        }
        return Optional.empty();
    }

    @Override
    public Optional<String> apiKey(InetAddress address) {
        return Optional.empty();
    }
}

