/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients;

import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.ClusterResource;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicType;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.requests.MetadataResponse;

public class MetadataSnapshot {
    private final String clusterId;
    private final Map<Integer, Node> nodes;
    private final Set<String> unauthorizedTopics;
    private final Set<String> invalidTopics;
    private final Set<String> internalTopics;
    private final Node controller;
    private final Map<TopicPartition, MetadataResponse.PartitionMetadata> metadataByPartition;
    private final Map<String, Uuid> topicIds;
    private final Map<String, TopicType> topicTypes;
    private final Map<Uuid, String> topicNames;
    private Cluster clusterInstance;

    public MetadataSnapshot(String clusterId, Map<Integer, Node> nodes, Collection<MetadataResponse.PartitionMetadata> partitions, Set<String> unauthorizedTopics, Set<String> invalidTopics, Set<String> internalTopics, Node controller, Map<String, Uuid> topicIds) {
        this(clusterId, nodes, partitions, unauthorizedTopics, invalidTopics, internalTopics, controller, topicIds, null);
    }

    public MetadataSnapshot(String clusterId, Map<Integer, Node> nodes, Collection<MetadataResponse.PartitionMetadata> partitions, Set<String> unauthorizedTopics, Set<String> invalidTopics, Set<String> internalTopics, Node controller, Map<String, Uuid> topicIds, Cluster clusterInstance) {
        this(clusterId, nodes, partitions, unauthorizedTopics, invalidTopics, internalTopics, controller, topicIds, clusterInstance, Collections.emptyMap());
    }

    public MetadataSnapshot(String clusterId, Map<Integer, Node> nodes, Collection<MetadataResponse.PartitionMetadata> partitions, Set<String> unauthorizedTopics, Set<String> invalidTopics, Set<String> internalTopics, Node controller, Map<String, Uuid> topicIds, Cluster clusterInstance, Map<String, TopicType> topicTypes) {
        this.clusterId = clusterId;
        this.nodes = Collections.unmodifiableMap(nodes);
        this.unauthorizedTopics = Collections.unmodifiableSet(unauthorizedTopics);
        this.invalidTopics = Collections.unmodifiableSet(invalidTopics);
        this.internalTopics = Collections.unmodifiableSet(internalTopics);
        this.controller = controller;
        this.topicIds = Collections.unmodifiableMap(topicIds);
        this.topicNames = Collections.unmodifiableMap(topicIds.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey)));
        HashMap<TopicPartition, MetadataResponse.PartitionMetadata> tmpMetadataByPartition = new HashMap<TopicPartition, MetadataResponse.PartitionMetadata>(partitions.size());
        for (MetadataResponse.PartitionMetadata p : partitions) {
            tmpMetadataByPartition.put(p.topicPartition, p);
        }
        this.metadataByPartition = Collections.unmodifiableMap(tmpMetadataByPartition);
        this.topicTypes = Collections.unmodifiableMap(topicTypes);
        if (clusterInstance == null) {
            this.computeClusterView();
        } else {
            this.clusterInstance = clusterInstance;
        }
    }

    Optional<MetadataResponse.PartitionMetadata> partitionMetadata(TopicPartition topicPartition) {
        return Optional.ofNullable(this.metadataByPartition.get(topicPartition));
    }

    Map<String, Uuid> topicIds() {
        return this.topicIds;
    }

    Map<Uuid, String> topicNames() {
        return this.topicNames;
    }

    TopicType topicType(String topicName) {
        return this.topicTypes.get(topicName);
    }

    Optional<Node> nodeById(int id) {
        return Optional.ofNullable(this.nodes.get(id));
    }

    public Cluster cluster() {
        if (this.clusterInstance == null) {
            throw new IllegalStateException("Cached Cluster instance should not be null, but was.");
        }
        return this.clusterInstance;
    }

    public OptionalInt leaderEpochFor(TopicPartition tp) {
        MetadataResponse.PartitionMetadata partitionMetadata = this.metadataByPartition.get(tp);
        if (partitionMetadata == null || !partitionMetadata.leaderEpoch.isPresent()) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(partitionMetadata.leaderEpoch.get());
    }

    ClusterResource clusterResource() {
        return new ClusterResource(this.clusterId);
    }

    MetadataSnapshot mergeWith(String newClusterId, Map<Integer, Node> newNodes, Collection<MetadataResponse.PartitionMetadata> addPartitions, Set<String> addUnauthorizedTopics, Set<String> addInvalidTopics, Set<String> addInternalTopics, Node newController, Map<String, Uuid> addTopicIds, Map<String, TopicType> addTopicTypes, BiPredicate<String, Boolean> retainTopic) {
        Predicate<String> shouldRetainTopic = topic -> retainTopic.test((String)topic, this.internalTopics.contains(topic));
        HashMap<TopicPartition, MetadataResponse.PartitionMetadata> newMetadataByPartition = new HashMap<TopicPartition, MetadataResponse.PartitionMetadata>(addPartitions.size());
        for (MetadataResponse.PartitionMetadata partitionMetadata : addPartitions) {
            newMetadataByPartition.put(partitionMetadata.topicPartition, partitionMetadata);
        }
        for (Map.Entry entry : this.metadataByPartition.entrySet()) {
            if (!shouldRetainTopic.test(((TopicPartition)entry.getKey()).topic())) continue;
            newMetadataByPartition.putIfAbsent((TopicPartition)entry.getKey(), (MetadataResponse.PartitionMetadata)entry.getValue());
        }
        HashMap<String, Uuid> newTopicIds = new HashMap<String, Uuid>();
        HashMap<String, TopicType> hashMap = new HashMap<String, TopicType>();
        for (String topicName : this.topicTypes.keySet()) {
            if (!shouldRetainTopic.test(topicName)) continue;
            hashMap.put(topicName, this.topicTypes.get(topicName));
            if (!this.topicIds.containsKey(topicName)) continue;
            newTopicIds.put(topicName, this.topicIds.get(topicName));
        }
        for (String topicName : addTopicTypes.keySet()) {
            TopicType newTopicType = addTopicTypes.get(topicName);
            hashMap.put(topicName, newTopicType);
            Uuid id = addTopicIds.get(topicName);
            if (id != null) {
                newTopicIds.put(topicName, id);
                continue;
            }
            newTopicIds.remove(topicName);
        }
        Set<String> newUnauthorizedTopics = MetadataSnapshot.fillSet(addUnauthorizedTopics, this.unauthorizedTopics, shouldRetainTopic);
        Set<String> newInvalidTopics = MetadataSnapshot.fillSet(addInvalidTopics, this.invalidTopics, shouldRetainTopic);
        Set<String> newInternalTopics = MetadataSnapshot.fillSet(addInternalTopics, this.internalTopics, shouldRetainTopic);
        return new MetadataSnapshot(newClusterId, newNodes, newMetadataByPartition.values(), newUnauthorizedTopics, newInvalidTopics, newInternalTopics, newController, newTopicIds, null, hashMap);
    }

    private static <T> Set<T> fillSet(Set<T> baseSet, Set<T> fillSet, Predicate<T> predicate) {
        HashSet<T> result = new HashSet<T>(baseSet);
        for (T element : fillSet) {
            if (!predicate.test(element)) continue;
            result.add(element);
        }
        return result;
    }

    private void computeClusterView() {
        List<PartitionInfo> partitionInfos = this.metadataByPartition.values().stream().map(metadata -> MetadataResponse.toPartitionInfo(metadata, this.nodes)).collect(Collectors.toList());
        this.clusterInstance = new Cluster(this.clusterId, this.nodes.values(), partitionInfos, this.unauthorizedTopics, this.invalidTopics, this.internalTopics, this.controller, this.topicIds, this.topicTypes);
    }

    static MetadataSnapshot bootstrap(List<InetSocketAddress> addresses) {
        HashMap<Integer, Node> nodes = new HashMap<Integer, Node>();
        int nodeId = -1;
        for (InetSocketAddress address : addresses) {
            nodes.put(nodeId, new Node(nodeId, address.getHostString(), address.getPort()));
            --nodeId;
        }
        return new MetadataSnapshot(null, nodes, Collections.emptyList(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), null, Collections.emptyMap(), Cluster.bootstrap(addresses));
    }

    static MetadataSnapshot empty() {
        return new MetadataSnapshot(null, Collections.emptyMap(), Collections.emptyList(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), null, Collections.emptyMap(), Cluster.empty());
    }

    public String toString() {
        return "MetadataSnapshot{clusterId='" + this.clusterId + '\'' + ", nodes=" + this.nodes + ", partitions=" + this.metadataByPartition.values() + ", controller=" + this.controller + '}';
    }
}

