/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum BrokerComponent {
    UNKNOWN(-1, false, Integer.MIN_VALUE),
    UNSPECIFIED(0, true, 2),
    STORAGE(1, false, 3),
    NETWORK(2, false, 4),
    EXTERNAL_CONNECTIVITY_STARTUP(3, false, 5);

    private final byte id;
    private final int minSupportedVersion;
    private final boolean downgradeAllowed;
    private static final Map<Byte, BrokerComponent> BYTE_ENUM_MAP;
    private static final Map<String, BrokerComponent> STR_ENUM_MAP;

    private BrokerComponent(byte id, boolean downgradeAllowed, int minSupportedVersion) {
        this.id = id;
        this.downgradeAllowed = downgradeAllowed;
        this.minSupportedVersion = minSupportedVersion;
    }

    public byte id() {
        return this.id;
    }

    public boolean isDowngradeAllowed() {
        return this.downgradeAllowed;
    }

    public int minSupportedVersion() {
        return this.minSupportedVersion;
    }

    public BrokerComponent maybeDowngrade(short version) {
        if (!this.isValid(version) && this.isDowngradeAllowed()) {
            return UNSPECIFIED;
        }
        return this;
    }

    public boolean isValid(short version) {
        if (version >= 2) {
            if (this == UNKNOWN) {
                return false;
            }
            return version >= this.minSupportedVersion;
        }
        return true;
    }

    public static BrokerComponent forId(byte id) {
        return BYTE_ENUM_MAP.getOrDefault(id, UNKNOWN);
    }

    public static BrokerComponent forString(String str) {
        return STR_ENUM_MAP.getOrDefault(str, UNKNOWN);
    }

    static {
        BYTE_ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(BrokerComponent.values()).collect(Collectors.toMap(BrokerComponent::id, Function.identity())));
        STR_ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(BrokerComponent.values()).collect(Collectors.toMap(Enum::toString, Function.identity())));
    }
}

