/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.EntityType;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class DescribeTenantsResponseData
implements ApiMessage {
    int throttleTimeMs;
    short errorCode;
    String errorMessage;
    List<TenantDescription> tenantDescriptions;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The error code."), new Field("error_message", Type.COMPACT_NULLABLE_STRING, "The error message, or null if there was no error."), new Field("tenant_descriptions", new CompactArrayOf(TenantDescription.SCHEMA_0), "The list of tenants and their detailed information."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema SCHEMA_1 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The error code."), new Field("error_message", Type.COMPACT_NULLABLE_STRING, "The error message, or null if there was no error."), new Field("tenant_descriptions", new CompactArrayOf(TenantDescription.SCHEMA_1), "The list of tenants and their detailed information."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 1;

    public DescribeTenantsResponseData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public DescribeTenantsResponseData() {
        this.throttleTimeMs = 0;
        this.errorCode = 0;
        this.errorMessage = "";
        this.tenantDescriptions = new ArrayList<TenantDescription>(0);
    }

    @Override
    public short apiKey() {
        return 10030;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 1;
    }

    @Override
    public final void read(Readable _readable, short _version, MessageContext _context) {
        this.throttleTimeMs = _readable.readInt();
        this.errorCode = _readable.readShort();
        int length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            this.errorMessage = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field errorMessage had invalid length " + length);
            }
            this.errorMessage = _context.read(EntityType.ERROR_MESSAGE, _readable.readString(length));
        }
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field tenantDescriptions was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ArrayList<TenantDescription> newCollection = new ArrayList<TenantDescription>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new TenantDescription(_readable, _version, _context));
        }
        this.tenantDescriptions = newCollection;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        Object _stringBytes;
        int _numTaggedFields = 0;
        _writable.writeInt(this.throttleTimeMs);
        _writable.writeShort(this.errorCode);
        if (this.errorMessage == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _stringBytes = _cache.getSerializedValue(this.errorMessage);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
        }
        _writable.writeUnsignedVarint(this.tenantDescriptions.size() + 1);
        _stringBytes = this.tenantDescriptions.iterator();
        while (_stringBytes.hasNext()) {
            TenantDescription tenantDescriptionsElement = (TenantDescription)_stringBytes.next();
            tenantDescriptionsElement.write(_writable, _cache, _version, _context);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        _size.addBytes(2);
        if (this.errorMessage == null) {
            _size.addBytes(1);
        } else {
            byte[] _stringBytes = _context.write(EntityType.ERROR_MESSAGE, this.errorMessage).getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'errorMessage' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.errorMessage, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.tenantDescriptions.size() + 1));
        for (TenantDescription tenantDescriptionsElement : this.tenantDescriptions) {
            tenantDescriptionsElement.addSize(_size, _cache, _version, _context);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DescribeTenantsResponseData)) {
            return false;
        }
        DescribeTenantsResponseData other = (DescribeTenantsResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
            return false;
        }
        if (this.tenantDescriptions == null ? other.tenantDescriptions != null : !this.tenantDescriptions.equals(other.tenantDescriptions)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
        hashCode = 31 * hashCode + (this.tenantDescriptions == null ? 0 : this.tenantDescriptions.hashCode());
        return hashCode;
    }

    @Override
    public DescribeTenantsResponseData duplicate() {
        DescribeTenantsResponseData _duplicate = new DescribeTenantsResponseData();
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        _duplicate.errorCode = this.errorCode;
        _duplicate.errorMessage = this.errorMessage == null ? null : this.errorMessage;
        ArrayList<TenantDescription> newTenantDescriptions = new ArrayList<TenantDescription>(this.tenantDescriptions.size());
        for (TenantDescription _element : this.tenantDescriptions) {
            newTenantDescriptions.add(_element.duplicate());
        }
        _duplicate.tenantDescriptions = newTenantDescriptions;
        return _duplicate;
    }

    public String toString() {
        return "DescribeTenantsResponseData(throttleTimeMs=" + this.throttleTimeMs + ", errorCode=" + this.errorCode + ", errorMessage=" + (this.errorMessage == null ? "null" : "'" + this.errorMessage.toString() + "'") + ", tenantDescriptions=" + MessageUtil.deepToString(this.tenantDescriptions.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public short errorCode() {
        return this.errorCode;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public List<TenantDescription> tenantDescriptions() {
        return this.tenantDescriptions;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public DescribeTenantsResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public DescribeTenantsResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public DescribeTenantsResponseData setErrorMessage(String v) {
        this.errorMessage = v;
        return this;
    }

    public DescribeTenantsResponseData setTenantDescriptions(List<TenantDescription> v) {
        this.tenantDescriptions = v;
        return this;
    }

    public static class TenantDescription
    implements Message {
        String tenantId;
        int cellId;
        List<Integer> cellIds;
        int partitionPlacementStrategy;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("tenant_id", Type.COMPACT_STRING, "The id of the tenant."), new Field("cell_id", Type.INT32, "Deprecated : The single cell where all tenant partitions are hosted."), new Field("partition_placement_strategy", Type.INT32, "The partition placement strategy describes how tenant partitions can be distributed."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema SCHEMA_1 = new Schema(new Field("tenant_id", Type.COMPACT_STRING, "The id of the tenant."), new Field("cell_ids", new CompactArrayOf(Type.INT32), "The cell ids where all tenant partitions are hosted."), new Field("partition_placement_strategy", Type.INT32, "The partition placement strategy describes how tenant partitions can be distributed."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 1;

        public TenantDescription(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public TenantDescription() {
            this.tenantId = "";
            this.cellId = 0;
            this.cellIds = new ArrayList<Integer>(0);
            this.partitionPlacementStrategy = 0;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 1;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of TenantDescription");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field tenantId was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field tenantId had invalid length " + length);
            }
            this.tenantId = _readable.readString(length);
            this.cellId = _version <= 0 ? _readable.readInt() : 0;
            if (_version >= 1) {
                int arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field cellIds was serialized as null");
                }
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                ArrayList<Integer> newCollection = new ArrayList<Integer>(arrayLength);
                for (int i = 0; i < arrayLength; ++i) {
                    newCollection.add(_readable.readInt());
                }
                this.cellIds = newCollection;
            } else {
                this.cellIds = new ArrayList<Integer>(0);
            }
            this.partitionPlacementStrategy = _readable.readInt();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.tenantId);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
            if (_version <= 0) {
                _writable.writeInt(this.cellId);
            } else if (this.cellId != 0) {
                throw new UnsupportedVersionException("Attempted to write a non-default cellId at version " + _version);
            }
            if (_version >= 1) {
                _writable.writeUnsignedVarint(this.cellIds.size() + 1);
                _stringBytes = this.cellIds.iterator();
                while (_stringBytes.hasNext()) {
                    Integer cellIdsElement = (Integer)_stringBytes.next();
                    _writable.writeInt(cellIdsElement);
                }
            } else if (!this.cellIds.isEmpty()) {
                throw new UnsupportedVersionException("Attempted to write a non-default cellIds at version " + _version);
            }
            _writable.writeInt(this.partitionPlacementStrategy);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of TenantDescription");
            }
            byte[] _stringBytes = this.tenantId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'tenantId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.tenantId, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            if (_version <= 0) {
                _size.addBytes(4);
            }
            if (_version >= 1) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.cellIds.size() + 1));
                _size.addBytes(this.cellIds.size() * 4);
            }
            _size.addBytes(4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TenantDescription)) {
                return false;
            }
            TenantDescription other = (TenantDescription)obj;
            if (this.tenantId == null ? other.tenantId != null : !this.tenantId.equals(other.tenantId)) {
                return false;
            }
            if (this.cellId != other.cellId) {
                return false;
            }
            if (this.cellIds == null ? other.cellIds != null : !this.cellIds.equals(other.cellIds)) {
                return false;
            }
            if (this.partitionPlacementStrategy != other.partitionPlacementStrategy) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.tenantId == null ? 0 : this.tenantId.hashCode());
            hashCode = 31 * hashCode + this.cellId;
            hashCode = 31 * hashCode + (this.cellIds == null ? 0 : this.cellIds.hashCode());
            hashCode = 31 * hashCode + this.partitionPlacementStrategy;
            return hashCode;
        }

        @Override
        public TenantDescription duplicate() {
            TenantDescription _duplicate = new TenantDescription();
            _duplicate.tenantId = this.tenantId;
            _duplicate.cellId = this.cellId;
            ArrayList<Integer> newCellIds = new ArrayList<Integer>(this.cellIds.size());
            for (Integer _element : this.cellIds) {
                newCellIds.add(_element);
            }
            _duplicate.cellIds = newCellIds;
            _duplicate.partitionPlacementStrategy = this.partitionPlacementStrategy;
            return _duplicate;
        }

        public String toString() {
            return "TenantDescription(tenantId=" + (this.tenantId == null ? "null" : "'" + this.tenantId.toString() + "'") + ", cellId=" + this.cellId + ", cellIds=" + MessageUtil.deepToString(this.cellIds.iterator()) + ", partitionPlacementStrategy=" + this.partitionPlacementStrategy + ")";
        }

        public String tenantId() {
            return this.tenantId;
        }

        public int cellId() {
            return this.cellId;
        }

        public List<Integer> cellIds() {
            return this.cellIds;
        }

        public int partitionPlacementStrategy() {
            return this.partitionPlacementStrategy;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public TenantDescription setTenantId(String v) {
            this.tenantId = v;
            return this;
        }

        public TenantDescription setCellId(int v) {
            this.cellId = v;
            return this;
        }

        public TenantDescription setCellIds(List<Integer> v) {
            this.cellIds = v;
            return this;
        }

        public TenantDescription setPartitionPlacementStrategy(int v) {
            this.partitionPlacementStrategy = v;
            return this;
        }
    }
}

