/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class ListGroupsRequestData
implements ApiMessage {
    List<String> statesFilter;
    List<String> typesFilter;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema SCHEMA_5;
    public static final Schema[] SCHEMAS;
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 5;

    public ListGroupsRequestData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public ListGroupsRequestData() {
        this.statesFilter = new ArrayList<String>(0);
        this.typesFilter = new ArrayList<String>(0);
    }

    @Override
    public short apiKey() {
        return 16;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 5;
    }

    @Override
    public final void read(Readable _readable, short _version, MessageContext _context) {
        int length;
        int i;
        ArrayList<String> newCollection;
        int arrayLength;
        if (_version >= 4) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field statesFilter was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList<String>(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                length = _readable.readUnsignedVarint() - 1;
                if (length < 0) {
                    throw new RuntimeException("non-nullable field statesFilter element was serialized as null");
                }
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field statesFilter element had invalid length " + length);
                }
                newCollection.add(_readable.readString(length));
            }
            this.statesFilter = newCollection;
        } else {
            this.statesFilter = new ArrayList<String>(0);
        }
        if (_version >= 5) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field typesFilter was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                length = _readable.readUnsignedVarint() - 1;
                if (length < 0) {
                    throw new RuntimeException("non-nullable field typesFilter element was serialized as null");
                }
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field typesFilter element had invalid length " + length);
                }
                newCollection.add(_readable.readString(length));
            }
            this.typesFilter = newCollection;
        } else {
            this.typesFilter = new ArrayList<String>(0);
        }
        this._unknownTaggedFields = null;
        if (_version >= 3) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        byte[] _stringBytes;
        int _numTaggedFields = 0;
        if (_version >= 4) {
            _writable.writeUnsignedVarint(this.statesFilter.size() + 1);
            for (String statesFilterElement : this.statesFilter) {
                _stringBytes = _cache.getSerializedValue(statesFilterElement);
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
                _writable.writeByteArray(_stringBytes);
            }
        } else if (!this.statesFilter.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default statesFilter at version " + _version);
        }
        if (_version >= 5) {
            _writable.writeUnsignedVarint(this.typesFilter.size() + 1);
            for (String typesFilterElement : this.typesFilter) {
                _stringBytes = _cache.getSerializedValue(typesFilterElement);
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
                _writable.writeByteArray(_stringBytes);
            }
        } else if (!this.typesFilter.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default typesFilter at version " + _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 3) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        byte[] _stringBytes;
        int _numTaggedFields = 0;
        if (_version >= 4) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.statesFilter.size() + 1));
            for (String statesFilterElement : this.statesFilter) {
                _stringBytes = statesFilterElement.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'statesFilterElement' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(statesFilterElement, _stringBytes);
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            }
        }
        if (_version >= 5) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.typesFilter.size() + 1));
            for (String typesFilterElement : this.typesFilter) {
                _stringBytes = typesFilterElement.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'typesFilterElement' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(typesFilterElement, _stringBytes);
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            }
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_version >= 3) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ListGroupsRequestData)) {
            return false;
        }
        ListGroupsRequestData other = (ListGroupsRequestData)obj;
        if (this.statesFilter == null ? other.statesFilter != null : !this.statesFilter.equals(other.statesFilter)) {
            return false;
        }
        if (this.typesFilter == null ? other.typesFilter != null : !this.typesFilter.equals(other.typesFilter)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.statesFilter == null ? 0 : this.statesFilter.hashCode());
        hashCode = 31 * hashCode + (this.typesFilter == null ? 0 : this.typesFilter.hashCode());
        return hashCode;
    }

    @Override
    public ListGroupsRequestData duplicate() {
        ListGroupsRequestData _duplicate = new ListGroupsRequestData();
        ArrayList<String> newStatesFilter = new ArrayList<String>(this.statesFilter.size());
        for (String _element : this.statesFilter) {
            newStatesFilter.add(_element);
        }
        _duplicate.statesFilter = newStatesFilter;
        ArrayList<String> newTypesFilter = new ArrayList<String>(this.typesFilter.size());
        for (String _element : this.typesFilter) {
            newTypesFilter.add(_element);
        }
        _duplicate.typesFilter = newTypesFilter;
        return _duplicate;
    }

    public String toString() {
        return "ListGroupsRequestData(statesFilter=" + MessageUtil.deepToString(this.statesFilter.iterator()) + ", typesFilter=" + MessageUtil.deepToString(this.typesFilter.iterator()) + ")";
    }

    public List<String> statesFilter() {
        return this.statesFilter;
    }

    public List<String> typesFilter() {
        return this.typesFilter;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public ListGroupsRequestData setStatesFilter(List<String> v) {
        this.statesFilter = v;
        return this;
    }

    public ListGroupsRequestData setTypesFilter(List<String> v) {
        this.typesFilter = v;
        return this;
    }

    static {
        SCHEMA_2 = SCHEMA_1 = (SCHEMA_0 = new Schema(new Field[0]));
        SCHEMA_3 = new Schema(Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMA_4 = new Schema(new Field("states_filter", new CompactArrayOf(Type.COMPACT_STRING), "The states of the groups we want to list. If empty, all groups are returned with their state."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMA_5 = new Schema(new Field("states_filter", new CompactArrayOf(Type.COMPACT_STRING), "The states of the groups we want to list. If empty, all groups are returned with their state."), new Field("types_filter", new CompactArrayOf(Type.COMPACT_STRING), "The types of the groups we want to list. If empty, all groups are returned with their type."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5};
    }
}

