/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BinaryNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.Arrays;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.SaslAuthenticateRequestData;
import org.apache.kafka.common.protocol.MessageUtil;

public class SaslAuthenticateRequestDataJsonConverter {
    public static SaslAuthenticateRequestData read(JsonNode _node, short _version) {
        SaslAuthenticateRequestData _object = new SaslAuthenticateRequestData();
        JsonNode _authBytesNode = _node.get("authBytes");
        if (_authBytesNode == null) {
            throw new RuntimeException("SaslAuthenticateRequestData: unable to locate field 'authBytes', which is mandatory in version " + _version);
        }
        _object.authBytes = MessageUtil.jsonNodeToBinary(_authBytesNode, "SaslAuthenticateRequestData");
        JsonNode _networkIdNode = _node.get("networkId");
        if (_networkIdNode == null) {
            _object.networkId = null;
        } else if (_networkIdNode.isNull()) {
            _object.networkId = null;
        } else {
            if (!_networkIdNode.isTextual()) {
                throw new RuntimeException("SaslAuthenticateRequestData expected a string type, but got " + _node.getNodeType());
            }
            _object.networkId = _networkIdNode.asText();
        }
        JsonNode _environmentIdNode = _node.get("environmentId");
        if (_environmentIdNode == null) {
            _object.environmentId = null;
        } else if (_environmentIdNode.isNull()) {
            _object.environmentId = null;
        } else {
            if (!_environmentIdNode.isTextual()) {
                throw new RuntimeException("SaslAuthenticateRequestData expected a string type, but got " + _node.getNodeType());
            }
            _object.environmentId = _environmentIdNode.asText();
        }
        JsonNode _networkTypeNode = _node.get("networkType");
        _object.networkType = _networkTypeNode == null ? (short)0 : MessageUtil.jsonNodeToShort(_networkTypeNode, "SaslAuthenticateRequestData");
        JsonNode _organizationIdNode = _node.get("organizationId");
        if (_organizationIdNode == null) {
            _object.organizationId = "";
        } else {
            if (!_organizationIdNode.isTextual()) {
                throw new RuntimeException("SaslAuthenticateRequestData expected a string type, but got " + _node.getNodeType());
            }
            _object.organizationId = _organizationIdNode.asText();
        }
        return _object;
    }

    public static JsonNode write(SaslAuthenticateRequestData _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        _node.set("authBytes", (JsonNode)new BinaryNode(Arrays.copyOf(_object.authBytes, _object.authBytes.length)));
        if (_version >= 2) {
            if (_object.networkId != null) {
                _node.set("networkId", (JsonNode)new TextNode(_object.networkId));
            }
        } else if (_object.networkId != null) {
            throw new UnsupportedVersionException("Attempted to write a non-default networkId at version " + _version);
        }
        if (_version >= 2) {
            if (_object.environmentId != null) {
                _node.set("environmentId", (JsonNode)new TextNode(_object.environmentId));
            }
        } else if (_object.environmentId != null) {
            throw new UnsupportedVersionException("Attempted to write a non-default environmentId at version " + _version);
        }
        if (_version >= 2) {
            if (_object.networkType != 0) {
                _node.set("networkType", (JsonNode)new ShortNode(_object.networkType));
            }
        } else if (_object.networkType != 0) {
            throw new UnsupportedVersionException("Attempted to write a non-default networkType at version " + _version);
        }
        if (_version >= 2) {
            if (!_object.organizationId.equals("")) {
                _node.set("organizationId", (JsonNode)new TextNode(_object.organizationId));
            }
        } else if (!_object.organizationId.equals("")) {
            throw new UnsupportedVersionException("Attempted to write a non-default organizationId at version " + _version);
        }
        return _node;
    }

    public static JsonNode write(SaslAuthenticateRequestData _object, short _version) {
        return SaslAuthenticateRequestDataJsonConverter.write(_object, _version, true);
    }
}

