/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.util.Locale;

public enum ProxyProtocolCommand {
    LOCAL(0),
    PROXY(1);

    public final int value;

    private ProxyProtocolCommand(int value) {
        this.value = value;
    }

    public static ProxyProtocolCommand forName(String name) {
        return ProxyProtocolCommand.valueOf(name.trim().toUpperCase(Locale.ROOT));
    }

    public static ProxyProtocolCommand forValue(int value) {
        switch (value) {
            case 0: {
                return LOCAL;
            }
            case 1: {
                return PROXY;
            }
        }
        throw new IllegalArgumentException("Command value " + value + " is not a valid command for the PROXY protocol");
    }
}

