/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.kafka.common.message.DescribeTenantsRequestData;
import org.apache.kafka.common.message.DescribeTenantsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.DescribeTenantsResponse;

public class DescribeTenantsRequest
extends AbstractRequest {
    private final DescribeTenantsRequestData data;

    DescribeTenantsRequest(DescribeTenantsRequestData data, short version) {
        super(ApiKeys.DESCRIBE_TENANTS, version);
        this.validate(data);
        this.data = data;
    }

    @Override
    public DescribeTenantsRequestData data() {
        return this.data;
    }

    public List<String> tenants() {
        return this.data.tenantIds();
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable t2) {
        ApiError err = ApiError.fromThrowable(t2);
        return new DescribeTenantsResponse(new DescribeTenantsResponseData().setThrottleTimeMs(throttleTimeMs).setErrorCode(err.error().code()).setErrorMessage(err.message()));
    }

    public static DescribeTenantsRequest parse(ByteBuffer buffer, short version, MessageContext context) {
        return new DescribeTenantsRequest(new DescribeTenantsRequestData(new ByteBufferAccessor(buffer), version, context), version);
    }

    private void validate(DescribeTenantsRequestData data) {
    }

    public static class Builder
    extends AbstractRequest.Builder<DescribeTenantsRequest> {
        private final DescribeTenantsRequestData data;

        public Builder() {
            super(ApiKeys.DESCRIBE_TENANTS);
            this.data = new DescribeTenantsRequestData();
        }

        public Builder(DescribeTenantsRequestData data) {
            super(ApiKeys.DESCRIBE_TENANTS);
            this.data = data;
        }

        public Builder setTenants(List<String> tenants) {
            this.data.setTenantIds(tenants);
            return this;
        }

        @Override
        public DescribeTenantsRequest build(short version) {
            return new DescribeTenantsRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

